/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.db.DbLanguage;
import com.openindex.openestate.impl.db.DbLanguagesHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbLanguagesHandler
extends DbLanguagesHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbLanguagesHandler.class);
    public static final String PROC_REMOVE_LANGUAGES = "remove_openestate_languages";
    public static final String PROC_SAVE_LANGUAGES = "save_openestate_languages";
    public static final String PROC_SET_LANGUAGES_ENABLED = "set_openestate_languages_enabled";
    public static final String VIEW_LANGUAGES = "view_openestate_languages";
    public static final String FIELD_LANGUAGE_ID = "language_id";
    public static final String FIELD_LANGUAGE_CODE = "language_code";
    public static final String FIELD_LANGUAGE_ENABLED = "language_enabled";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    public HSqlDbLanguagesHandler() {
    }

    public HSqlDbLanguagesHandler(String string) {
        super(string);
    }

    protected DbLanguage buildLanguage(ResultSet resultSet) throws SQLException {
        DbLanguage dbLanguage = this.createLanguage();
        dbLanguage.id = resultSet.getLong(FIELD_LANGUAGE_ID);
        dbLanguage.enabled = resultSet.getBoolean(FIELD_LANGUAGE_ENABLED);
        dbLanguage.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbLanguage.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        String string = resultSet.getString(FIELD_LANGUAGE_CODE);
        dbLanguage.locale = string != null ? OpenEstateUtils.buildLocale((String)string) : null;
        return dbLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLanguage[] getLanguages(Connection connection, Boolean bl) throws SQLException {
        DbLanguage[] dbLanguageArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_ENABLED + " = ? ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbLanguage> arrayList = new ArrayList<DbLanguage>();
            while (resultSet.next()) {
                arrayList.add(this.buildLanguage(resultSet));
            }
            dbLanguageArray = arrayList.toArray(new DbLanguage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLanguageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLanguage[] getLanguages(Connection connection, long[] lArray) throws SQLException {
        DbLanguage[] dbLanguageArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbLanguage[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_LANGUAGE_CODE + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbLanguage> arrayList = new ArrayList<DbLanguage>();
            while (resultSet.next()) {
                arrayList.add(this.buildLanguage(resultSet));
            }
            dbLanguageArray = arrayList.toArray(new DbLanguage[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLanguageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLanguageIds(Connection connection, Boolean bl) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT language_id FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT language_id FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_ENABLED + " = ? ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_LANGUAGE_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale[] getLanguageLocales(Connection connection, Boolean bl) throws SQLException {
        Locale[] localeArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT language_code FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_CODE + " IS NOT NULL ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT language_code FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_ENABLED + " = ? AND " + FIELD_LANGUAGE_CODE + " IS NOT NULL ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            while (resultSet.next()) {
                arrayList.add(OpenEstateUtils.buildLocale((String)resultSet.getString(FIELD_LANGUAGE_CODE)));
            }
            localeArray = arrayList.toArray(new Locale[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return localeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> getLanguageMap(Connection connection, Boolean bl) throws SQLException {
        HashMap<Long, String> hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT language_id, language_code FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT language_id, language_code FROM " + this.getSchemaPath(VIEW_LANGUAGES) + " WHERE " + FIELD_LANGUAGE_ENABLED + " = ? ORDER BY " + FIELD_LANGUAGE_CODE + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
            while (resultSet.next()) {
                hashMap2.put(resultSet.getLong(FIELD_LANGUAGE_ID), resultSet.getString(FIELD_LANGUAGE_CODE));
            }
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return hashMap;
    }

    public void removeLanguages(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_LANGUAGES) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveLanguage(Connection connection, DbLanguage dbLanguage) throws SQLException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block7: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_LANGUAGES) + "(:" + FIELD_LANGUAGE_ID + ", :" + FIELD_LANGUAGE_CODE + ", :" + FIELD_LANGUAGE_ENABLED + ");");
                namedCallableStatement.setLong(FIELD_LANGUAGE_ID, dbLanguage.id);
                namedCallableStatement.setBoolean(FIELD_LANGUAGE_ENABLED, dbLanguage.enabled);
                namedCallableStatement.setString(FIELD_LANGUAGE_CODE, dbLanguage.locale != null ? dbLanguage.locale.toString() : null);
                namedCallableStatement.execute();
                long l2 = l = dbLanguage.id < 1L ? namedCallableStatement.getLong(FIELD_LANGUAGE_ID) : dbLanguage.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveLanguageAdditionally(connection, dbLanguage, l, arrayList);
                connection.commit();
                if (dbLanguage.id >= 1L) break block7;
                dbLanguage.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    protected void saveLanguageAdditionally(Connection connection, DbLanguage dbLanguage, long l, List<Statement> list) throws SQLException {
    }

    public void setLanguagesEnabled(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SET_LANGUAGES_ENABLED) + "(:" + FIELD_LANGUAGE_ID + ", :" + FIELD_LANGUAGE_ENABLED + ");");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_LANGUAGE_ID, l);
                namedCallableStatement.setBoolean(FIELD_LANGUAGE_ENABLED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }
}

