/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.daft_ie;

import org.apache.commons.lang3.ArrayUtils;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.converters.DaftIe_2_7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DaftIeVersion implements XmlVersion
{
    V2_7(DaftIe_2_7.class, "2.7", new String[0]);

    private static final Logger LOGGER;
    private final Class converterClass;
    private final String readableVersion;
    private final String[] alias;

    private DaftIeVersion(Class clazz, String string2, String ... stringArray) {
        this.converterClass = clazz;
        this.readableVersion = string2;
        this.alias = stringArray;
    }

    public static DaftIeVersion detectFromString(String string) {
        if (string != null) {
            for (DaftIeVersion daftIeVersion : DaftIeVersion.values()) {
                if (daftIeVersion.toReadableVersion().equalsIgnoreCase(string)) {
                    return daftIeVersion;
                }
                if (daftIeVersion.alias == null) continue;
                for (String string2 : daftIeVersion.alias) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return daftIeVersion;
                }
            }
        }
        return null;
    }

    public XmlConverter getConverter() {
        try {
            return (XmlConverter)this.converterClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create converter!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public DaftIeVersion getNextVersion() {
        DaftIeVersion[] daftIeVersionArray = DaftIeVersion.values();
        int n = ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)((Object)this));
        return daftIeVersionArray.length > ++n ? daftIeVersionArray[n] : null;
    }

    public DaftIeVersion getPreviousVersion() {
        DaftIeVersion[] daftIeVersionArray = DaftIeVersion.values();
        int n = ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)((Object)this));
        return --n >= 0 ? daftIeVersionArray[n] : null;
    }

    public boolean isLatestVersion() {
        return DaftIeUtils.VERSION.equals((Object)this);
    }

    public boolean isNewerThen(XmlVersion xmlVersion) {
        DaftIeVersion[] daftIeVersionArray = DaftIeVersion.values();
        return ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)((Object)this)) > ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)xmlVersion);
    }

    public boolean isOlderThen(XmlVersion xmlVersion) {
        DaftIeVersion[] daftIeVersionArray = DaftIeVersion.values();
        return ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)((Object)this)) < ArrayUtils.indexOf((Object[])daftIeVersionArray, (Object)xmlVersion);
    }

    public String toReadableVersion() {
        return this.readableVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DaftIeVersion.class);
    }
}

