-- -----------------------------------------------------
-- Contacts extensions to the Agency-Addon for OpenEstate-ImmoTool
-- update 5 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_brokerings'
-- Fix update of owners in 'save_immotool_agency_interests'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_brokerings'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_brokerings
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neue Vermarktung erzeugen
    IF val_brokering_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Vermarktung speichern
      INSERT INTO immotool_agency_brokerings (
        contacts_entry_id,
        agency_object_id,
        brokering_exclusive,
        brokering_begin,
        brokering_end,
        brokering_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_contacts_entry_id,
        val_agency_object_id,
        val_brokering_exclusive,
        val_brokering_begin,
        val_brokering_end,
        val_brokering_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_brokering_id = IDENTITY();

    -- Bestehende Vermarktung bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_brokerings
        WHERE brokering_id = val_brokering_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Vermarktung bearbeiten
      UPDATE immotool_agency_brokerings
        SET
          contacts_entry_id = val_contacts_entry_id,
          agency_object_id = val_agency_object_id,
          brokering_exclusive = val_brokering_exclusive,
          brokering_begin = val_brokering_begin,
          brokering_end = val_brokering_end,
          brokering_notes = val_brokering_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          brokering_id = val_brokering_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_interests'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_interests
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neuen Interessent erzeugen
    IF val_interest_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Interessent speichern
      INSERT INTO immotool_agency_interests (
        contacts_entry_id,
        agency_search_id,
        interest_status,
        interest_begin,
        interest_end,
        interest_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_contacts_entry_id,
        val_agency_search_id,
        val_interest_status,
        val_interest_begin,
        val_interest_end,
        val_interest_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_interest_id = IDENTITY();

    -- Bestehenden Interessent bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_interests
        WHERE interest_id = val_interest_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Interessent bearbeiten
      UPDATE immotool_agency_interests
        SET
          contacts_entry_id = val_contacts_entry_id,
          agency_search_id = val_agency_search_id,
          interest_status = val_interest_status,
          interest_begin = val_interest_begin,
          interest_end = val_interest_end,
          interest_notes = val_interest_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          interest_id = val_interest_id;

    END IF;

  END;
.;
