-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 9 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Set type of 'file_mimetype' in 'openestate_objects_files' to 'VARCHAR(255)'
-- Update 'save_openestate_objects_files'
-- Update 'view_openestate_objects_files'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Set type of 'file_mimetype' in 'openestate_objects_files' to 'VARCHAR(255)'
-- -----------------------------------------------------
ALTER TABLE openestate_objects_files
  ALTER COLUMN file_mimetype SET DATA TYPE VARCHAR(255);

-- -----------------------------------------------------
-- Update 'save_openestate_objects_files'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_openestate_objects_files RESTRICT;
\.
CREATE PROCEDURE save_openestate_objects_files(
    INOUT val_file_id BIGINT,
    val_object_id BIGINT,
    val_file_name VARCHAR(255),
    val_file_url VARCHAR(255),
    val_file_content BLOB(1G),
    val_file_content_preview BLOB(1M),
    val_file_mimetype VARCHAR(255),
    val_file_published BOOLEAN,
    val_file_type VARCHAR(100),
    val_file_size BIGINT,
    val_file_image_width INT,
    val_file_image_height INT,
    val_file_position INT
  )
  SPECIFIC save_openestate_objects_files
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_agency_objects(val_object_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Datei
    IF val_file_id < 1 THEN

      -- Datei speichern
      INSERT INTO openestate_objects_files (
        object_id,
        file_name,
        file_url,
        file_mimetype,
        file_published,
        file_type,
        file_size,
        file_image_width,
        file_image_height,
        file_position )
      VALUES (
        val_object_id,
        val_file_name,
        val_file_url,
        val_file_mimetype,
        val_file_published,
        val_file_type,
        val_file_size,
        val_file_image_width,
        val_file_image_height,
        val_file_position );

      -- ID zurückliefern
      SET val_file_id = IDENTITY();

    ELSE

      -- Datei bearbeiten
      UPDATE openestate_objects_files
        SET
          object_id = val_object_id,
          file_name = val_file_name,
          file_url = val_file_url,
          file_mimetype = val_file_mimetype,
          file_published = val_file_published,
          file_type = val_file_type,
          file_size = val_file_size,
          file_image_width = val_file_image_width,
          file_image_height = val_file_image_height,
          file_position = val_file_position,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

    -- Datei ggf. aktualisieren
    IF val_file_content IS NOT NULL THEN

      -- Datei bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content = val_file_content,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

    -- Vorschau ggf. aktualisieren
    IF val_file_content_preview IS NOT NULL THEN

      -- Vorschau bearbeiten
      UPDATE openestate_objects_files
        SET
          file_content_preview = val_file_content_preview,
          modified_at = NOW()
        WHERE
          file_id = val_file_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_openestate_objects_files
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Update 'view_openestate_objects_files'
-- -----------------------------------------------------
ALTER VIEW view_openestate_objects_files AS
  SELECT
    file_id,
    object_id,
    file_name,
    file_url,
    file_mimetype,
    file_published,
    file_type,
    file_size,
    file_image_width,
    file_image_height,
    file_position,
    created_at,
    modified_at
  FROM openestate_objects_files
  WHERE object_id IN (SELECT object_id FROM view_openestate_objects);
