-- -----------------------------------------------------
-- Agency-Addon for OpenEstate-ImmoTool
-- update 10 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_contacts'
-- Fix update of owners in 'save_immotool_agency_exports'
-- Fix update of owners in 'save_immotool_agency_exposes'
-- Fix update of owners in 'save_immotool_agency_objects'
-- Fix update of owners in 'save_immotool_agency_searches'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_contacts'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_contacts
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT contact_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_contacts
      WHERE contact_id = val_contact_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Ansprechpartner-Zusatz einfügen
      INSERT INTO immotool_agency_contacts (
        contact_id,
        contact_enabled,
        contact_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_contact_id,
        val_contact_enabled,
        val_contact_notes,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Ansprechpartner-Zusatz aktualisieren
      UPDATE immotool_agency_contacts
        SET
          contact_enabled = val_contact_enabled,
          contact_notes = val_contact_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          contact_id = val_contact_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_exports'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_exports
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neuen Export erzeugen
    IF val_export_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Export speichern
      INSERT INTO immotool_agency_exports (
        export_name,
        export_enabled,
        export_limit,
        export_last_execution,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_export_name,
        val_export_enabled,
        val_export_limit,
        val_export_last_execution,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_export_id = IDENTITY();

    -- Bestehenden Export bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_exports
        WHERE export_id = val_export_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Export bearbeiten
      UPDATE immotool_agency_exports
        SET
          export_name = val_export_name,
          export_enabled = val_export_enabled,
          export_limit = val_export_limit,
          export_last_execution = val_export_last_execution,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          export_id = val_export_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_exposes'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_exposes
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neues Exposé erzeugen
    IF val_expose_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Exposé speichern
      INSERT INTO immotool_agency_exposes (
        expose_name,
        expose_type,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_expose_name,
        val_expose_type,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_expose_id = IDENTITY();

    -- Bestehendes Exposé bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_agency_exposes
        WHERE expose_id = val_expose_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Exposé bearbeiten
      UPDATE immotool_agency_exposes
        SET
          expose_name = val_expose_name,
          expose_type = val_expose_type,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          expose_id = val_expose_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_objects'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_objects
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT object_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_objects
      WHERE object_id = val_object_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Immobilien-Zusatz einfügen
      INSERT INTO immotool_agency_objects (
        object_id,
        object_status,
        object_export_mode,
        object_import_id,
        object_import_hash,
        object_group_nr,
        object_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_object_id,
        val_object_status,
        val_object_export_mode,
        val_object_import_id,
        val_object_import_hash,
        val_object_group_nr,
        val_object_notes,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Immobilien-Zusatz aktualisieren
      UPDATE immotool_agency_objects
        SET
          object_status = val_object_status,
          object_export_mode = val_object_export_mode,
          object_import_id = val_object_import_id,
          object_import_hash = val_object_import_hash,
          object_group_nr = val_object_group_nr,
          object_notes = val_object_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          object_id = val_object_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_agency_searches'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_agency_searches
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_id BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Datensatz ermitteln
    SELECT search_id, access_permissions, access_owner_id, access_group_id
      INTO current_id, permissions, owner_uid, owner_gid
      FROM immotool_agency_searches
      WHERE search_id = val_search_id;

    -- Datensatz existiert noch nicht
    IF current_id IS NULL THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Suche-Zusatz einfügen
      INSERT INTO immotool_agency_searches (
        search_id,
        search_type,
        search_object_status,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_search_id,
        val_search_type,
        val_search_object_status,
        owner_uid,
        owner_gid,
        permissions );

    -- Datensatz existiert bereits
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Suche-Zusatz aktualisieren
      UPDATE immotool_agency_searches
        SET
          search_type = val_search_type,
          search_object_status = val_search_object_status,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions
        WHERE
          search_id = val_search_id;

    END IF;

  END;
.;
