/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmActivityTable;
import com.openindex.openestate.tool.crm.CrmActivityViewTask;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CrmActivityTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityTablePanel.class);
    private static final String TABLE_ID = "CrmActivityTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_TITLE = 1;
    private static final int FILTER_TYPE = 2;
    private static final int FILTER_DIRECTION = 3;
    private static final int FILTER_STATUS = 4;
    private static final int COUNT_FILTERS = 5;
    private DbCrmActivity.Type currentType = null;
    private List<String> filterValues;
    private JLabel filterIdLabel;
    private JFormattedTextField filterIdField;
    private JLabel filterTitleLabel;
    private JTextField filterTitleField;
    private JLabel filterTypeLabel;
    private JComboBox<DbCrmActivity.Type> filterTypeField;
    private JLabel filterDirectionLabel;
    private JComboBox<DbCrmActivity.Direction> filterDirectionField;
    private JLabel filterStatusLabel;
    private JComboBox<DbCrmActivity.Status> filterStatusField;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private CrmActivityTablePanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new ActivityAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(CrmPlugin.getResourceIcon("crm.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            this.filterValues.add(null);
        }
        this.filterIdLabel = new JLabel();
        this.filterIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.filterIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!CrmActivityTablePanel.this.filterIdField.isEnabled()) {
                    return;
                }
                try {
                    CrmActivityTablePanel.this.filterIdField.commitEdit();
                }
                catch (Exception exception) {
                    CrmActivityTablePanel.this.filterIdField.setValue(null);
                }
                String string2 = string = CrmActivityTablePanel.this.filterIdField.isEditValid() ? CrmActivityTablePanel.this.filterIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && CrmActivityTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase((String)CrmActivityTablePanel.this.filterValues.get(0))) {
                    return;
                }
                CrmActivityTablePanel.this.filterValues.set(0, string);
                CrmActivityTablePanel.this.updateFilters(true);
            }
        });
        this.filterTitleLabel = new JLabel();
        this.filterTitleField = new JTextField();
        this.filterTitleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!CrmActivityTablePanel.this.filterTitleField.isEnabled()) {
                    return;
                }
                String string = CrmActivityTablePanel.this.filterTitleField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && CrmActivityTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)CrmActivityTablePanel.this.filterValues.get(1))) {
                    return;
                }
                CrmActivityTablePanel.this.filterValues.set(1, string);
                CrmActivityTablePanel.this.updateFilters(true);
            }
        });
        this.filterTypeLabel = new JLabel();
        this.filterTypeField = new JComboBox();
        this.filterTypeField.setRenderer((ListCellRenderer<DbCrmActivity.Type>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterTypeField.addItem(null);
        for (DbCrmActivity.Type enum_ : DbCrmActivity.Type.values()) {
            this.filterTypeField.addItem(enum_);
        }
        this.filterTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CrmActivityTablePanel.this.filterTypeField.isEnabled()) {
                    return;
                }
                DbCrmActivity.Type type = (DbCrmActivity.Type)((Object)CrmActivityTablePanel.this.filterTypeField.getSelectedItem());
                if (type == null && CrmActivityTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (type != null && type.name().equalsIgnoreCase((String)CrmActivityTablePanel.this.filterValues.get(2))) {
                    return;
                }
                CrmActivityTablePanel.this.filterValues.set(2, type != null ? type.name() : null);
                if (DbCrmActivity.Type.MEETING.equals((Object)type)) {
                    CrmActivityTablePanel.this.filterDirectionField.setEnabled(false);
                    CrmActivityTablePanel.this.filterValues.set(3, null);
                } else {
                    CrmActivityTablePanel.this.filterDirectionField.setEnabled(true);
                    DbCrmActivity.Direction direction = (DbCrmActivity.Direction)((Object)CrmActivityTablePanel.this.filterDirectionField.getSelectedItem());
                    CrmActivityTablePanel.this.filterValues.set(3, direction != null ? direction.name() : null);
                }
                CrmActivityTablePanel.this.updateFilters(true);
            }
        });
        this.filterDirectionLabel = new JLabel();
        this.filterDirectionField = new JComboBox();
        this.filterDirectionField.setRenderer((ListCellRenderer<DbCrmActivity.Direction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterDirectionField.addItem(null);
        for (Enum enum_ : DbCrmActivity.Direction.values()) {
            this.filterDirectionField.addItem((DbCrmActivity.Direction)enum_);
        }
        this.filterDirectionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CrmActivityTablePanel.this.filterDirectionField.isEnabled()) {
                    return;
                }
                DbCrmActivity.Direction direction = (DbCrmActivity.Direction)((Object)CrmActivityTablePanel.this.filterDirectionField.getSelectedItem());
                if (direction == null && CrmActivityTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (direction != null && direction.name().equalsIgnoreCase((String)CrmActivityTablePanel.this.filterValues.get(3))) {
                    return;
                }
                CrmActivityTablePanel.this.filterValues.set(3, direction != null ? direction.name() : null);
                CrmActivityTablePanel.this.updateFilters(true);
            }
        });
        this.filterStatusLabel = new JLabel();
        this.filterStatusField = new JComboBox();
        this.filterStatusField.setRenderer((ListCellRenderer<DbCrmActivity.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterStatusField.addItem(null);
        for (Enum enum_ : DbCrmActivity.Status.values()) {
            this.filterStatusField.addItem((DbCrmActivity.Status)enum_);
        }
        this.filterStatusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CrmActivityTablePanel.this.filterStatusField.isEnabled()) {
                    return;
                }
                DbCrmActivity.Status status = (DbCrmActivity.Status)((Object)CrmActivityTablePanel.this.filterStatusField.getSelectedItem());
                if (status == null && CrmActivityTablePanel.this.filterValues.get(4) == null) {
                    return;
                }
                if (status != null && status.name().equalsIgnoreCase((String)CrmActivityTablePanel.this.filterValues.get(4))) {
                    return;
                }
                CrmActivityTablePanel.this.filterValues.set(4, status != null ? status.name() : null);
                CrmActivityTablePanel.this.updateFilters(true);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref, 3dlu, right:pref, 3dlu, pref, 3dlu, right:pref, 3dlu, pref");
        defaultFormBuilder.add((Component)this.filterIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.filterIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterTitleLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterTitleField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterTypeLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterTypeField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterDirectionLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterDirectionField).xy(15, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterStatusLabel).xy(17, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterStatusField).xy(19, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static CrmActivityTablePanel createTab() {
        return new CrmActivityTablePanel();
    }

    public static CrmActivityTablePanel createTab(DbCrmActivity.Type type) {
        CrmActivityTablePanel crmActivityTablePanel = new CrmActivityTablePanel();
        if (type != null) {
            crmActivityTablePanel.setType(type);
        }
        return crmActivityTablePanel;
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmActivityTable.Row>(){

            public boolean include(CrmActivityTable.Row row) {
                Number number = CrmActivityTablePanel.this.filterIdField.isEditValid() ? (Number)((Number)CrmActivityTablePanel.this.filterIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getActivity().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmActivityTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(CrmActivityTable.Row row) {
                String string = StringUtils.trimToNull((String)CrmActivityTablePanel.this.filterTitleField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 7.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)row.getActivity().subject)).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmActivityTable.Row>(){

            public boolean include(CrmActivityTable.Row row) {
                DbCrmActivity.Type type = (DbCrmActivity.Type)((Object)CrmActivityTablePanel.this.filterTypeField.getSelectedItem());
                return type == null || type.equals((Object)row.getActivity().type);
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmActivityTable.Row>(){

            public boolean include(CrmActivityTable.Row row) {
                DbCrmActivity.Type type = (DbCrmActivity.Type)((Object)CrmActivityTablePanel.this.filterTypeField.getSelectedItem());
                DbCrmActivity.Direction direction = (DbCrmActivity.Direction)((Object)CrmActivityTablePanel.this.filterDirectionField.getSelectedItem());
                if (direction != null && DbCrmActivity.Type.MEETING.equals((Object)type)) {
                    return false;
                }
                return direction == null || direction.equals((Object)row.getActivity().direction);
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<CrmActivityTable.Row>(){

            public boolean include(CrmActivityTable.Row row) {
                DbCrmActivity.Status status = (DbCrmActivity.Status)((Object)CrmActivityTablePanel.this.filterStatusField.getSelectedItem());
                return status == null || status.equals((Object)row.getActivity().status);
            }
        });
        return this.table;
    }

    private void doActivityAdd(Component component, int n, int n2) {
        if (!CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT)) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (DbCrmActivity.Type type : DbCrmActivity.Type.values()) {
            jPopupMenu.add((Action)((Object)new CrmPlugin.ActivityFormAction(type)));
        }
        jPopupMenu.show(component, n, n2);
    }

    private void doActivityRemove() {
        if (!CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_REMOVE)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getActivityIdAt(n2);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected activities?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new ActivityRemoveTask(lArray));
    }

    private void doActivityView() {
        if (!CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            long l = this.table.getActivityIdAt(n4);
            ImmoToolUtils.executeTask((ImmoToolTask)new CrmActivityViewTask(immoToolProject.getDbDriver(), l, n == 1));
            if (++n2 >= 10) break;
        }
    }

    protected void doHelp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearRows();
        this.table.clearSelection();
        this.updateFilters(false);
        ArrayList<DbCrmActivity> arrayList = new ArrayList<DbCrmActivity>();
        try {
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            DbCrmActivity[] dbCrmActivityArray = dbCrmActivityHandler.getActivities(connection);
            arrayList.addAll(Arrays.asList(dbCrmActivityArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$activitiesList;
                {
                    this.val$activitiesList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbCrmActivity dbCrmActivity : this.val$activitiesList) {
                            CrmActivityTablePanel.this.table.addRow(new CrmActivityTable.Row(dbCrmActivity));
                        }
                    }
                    finally {
                        CrmActivityTablePanel.this.table.setEnabled(true);
                        CrmActivityTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new ActivityViewAction()));
        jPopupMenu.add((Action)((Object)new ActivityRemoveAction()));
        jPopupMenu.show(component, n, n2);
    }

    public DbCrmActivity.Type getCurrentType() {
        return this.currentType;
    }

    protected Icon getHeaderIcon() {
        return CrmPlugin.getResourceIcon("crm.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of activities"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("activities"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of your activities.");
    }

    protected String getTableTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.filterDirectionField.setEnabled(bl);
        this.filterIdField.setEnabled(bl);
        this.filterStatusField.setEnabled(bl);
        this.filterTitleField.setEnabled(bl);
        this.filterTypeField.setEnabled(bl);
    }

    public void setType(DbCrmActivity.Type type) {
        this.currentType = type;
        this.filterTypeField.setSelectedItem((Object)type);
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.filterIdLabel.setText(StringUtils.capitalize((String)I18N.tr("ID")) + ":");
        this.filterTitleLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.filterTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("type")) + ":");
        this.filterDirectionLabel.setText(StringUtils.capitalize((String)I18N.tr("direction")) + ":");
        this.filterStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    private class ActivityViewAction
    extends AbstractI18nAction {
        private ActivityViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityTablePanel.this.doActivityView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
            this.setShortDescription(I18N.tr("Show the selected activities."));
        }
    }

    private class ActivityRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] activityIds;

        private ActivityRemoveTask(long[] lArray) {
            this.activityIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCrmActivityHandler.removeActivities(connection, this.activityIds);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove activities!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            CrmActivityTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            for (long l : this.activityIds) {
                int n = CrmActivityTablePanel.this.table.getRowForActivityId(l);
                if (n <= -1) continue;
                CrmActivityTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class ActivityRemoveAction
    extends AbstractI18nAction {
        private ActivityRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityTablePanel.this.doActivityRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove activity")));
            this.setShortDescription(I18N.tr("Remove the selected activities."));
        }
    }

    private class ActivityAddAction
    extends AbstractI18nAction {
        private ActivityAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmActivityTablePanel.this.doActivityAdd(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new activity."));
        }
    }

    private class Table
    extends CrmActivityTable<CrmActivityTable.Row> {
        public Table() {
            super(CrmActivityTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            CrmActivityTablePanel.this.doActivityRemove();
        }

        protected void doSelect() {
            CrmActivityTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            CrmActivityTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmActivityTablePanel.this.doActivityView();
        }
    }
}

