/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmMarketingViewPanel;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmMarketingViewTask
extends ImmoToolTask<CrmMarketingViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMarketingViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMarketingViewTask.class);
    private final long marketingId;
    private final boolean selectCreatedTab;
    private final CrmMarketingViewPanel viewTab;
    private final AbstractDbDriver dbDriver;

    public CrmMarketingViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public CrmMarketingViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading marketing action {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.marketingId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public CrmMarketingViewTask(AbstractDbDriver abstractDbDriver, long l, CrmMarketingViewPanel crmMarketingViewPanel) {
        super(I18N.tr("Loading marketing action {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.marketingId = l;
        this.selectCreatedTab = true;
        this.viewTab = crmMarketingViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CrmMarketingViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(CrmMarketingViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    CrmMarketingViewPanel crmMarketingViewPanel = (CrmMarketingViewPanel)abstractMainTab;
                    if (this.marketingId < 1L && crmMarketingViewPanel.getCurrentMarketingId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)crmMarketingViewPanel));
                        return null;
                    }
                    if (this.marketingId <= 0L || crmMarketingViewPanel.getCurrentMarketingId() != this.marketingId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)crmMarketingViewPanel));
                    return null;
                }
            }
            if (this.marketingId < 1L) {
                return this.viewTab != null ? this.viewTab : CrmMarketingViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbCrmMarketing dbCrmMarketing = dbCrmMarketingHandler.getMarketing(connection2, this.marketingId);
                if (dbCrmMarketing == null) {
                    throw new Exception("Can't find marketing action #" + this.marketingId + "!");
                }
                dbCrmMarketingHandler.loadFeedbacks(connection2, dbCrmMarketing);
                if (this.viewTab == null) {
                    object = CrmMarketingViewPanel.createTab(dbCrmMarketing);
                    break block8;
                }
                object = this.viewTab;
                ((CrmMarketingViewPanel)((Object)object)).setMarketing(dbCrmMarketing);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load marketing action!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(CrmMarketingViewPanel crmMarketingViewPanel) {
        super.succeeded((Object)crmMarketingViewPanel);
        if (crmMarketingViewPanel != null) {
            ImmoToolAppUtils.showTab((AbstractMainTab)crmMarketingViewPanel, (boolean)this.selectCreatedTab);
            crmMarketingViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }
}

