/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Image;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCrmActivity
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCrmActivity.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCrmActivity.class);
    public long id = 0L;
    public String subject = null;
    public Type type = null;
    public Direction direction = null;
    public Status status = null;
    public String notes = null;
    public Date begin = null;
    public Date end = null;
    public boolean fixed = false;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public List<Long> contactEntryIds = null;

    public static ObjectToStringConverter createObjectToStringConverter() {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof DbCrmActivity) {
                    return ((DbCrmActivity)object).print();
                }
                return "-";
            }

            public String[] getPossibleStringsForItem(Object object) {
                if (object instanceof DbCrmActivity) {
                    DbCrmActivity dbCrmActivity = (DbCrmActivity)object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(this.getPreferredStringForItem(object));
                    if (dbCrmActivity.subject != null && !arrayList.contains(dbCrmActivity.subject)) {
                        arrayList.add(dbCrmActivity.subject);
                    }
                    return arrayList.toArray(new String[0]);
                }
                return super.getPossibleStringsForItem(object);
            }
        };
    }

    public String print() {
        String string = this.begin != null ? DateFormat.getDateTimeInstance(3, 3).format(this.begin) + " | " + this.subject : this.subject;
        return string != null ? string.trim() : "";
    }

    public static enum Type implements Translatable
    {
        CALL(I18n.marktr((String)"call"), "phone.png"),
        LETTER(I18n.marktr((String)"letter"), "mail.png"),
        EMAIL(I18n.marktr((String)"e-mail"), "email.png"),
        FAX(I18n.marktr((String)"fax"), "fax.png"),
        MEETING(I18n.marktr((String)"meeting"), "meeting.png");

        private final String i18nKey;
        private final String icon;

        private Type(String string2, String string3) {
            this.i18nKey = string2;
            this.icon = string3;
        }

        public Icon getIcon(int n) {
            return CrmPlugin.getResourceIcon(this.icon, n);
        }

        public Image getImage(int n) {
            return CrmPlugin.getResourceImage(this.icon, n);
        }

        public URL getImageURL(int n) {
            return CrmPlugin.getResourceImageURL(this.icon, n);
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCrmActivity.class, (String)this.i18nKey, (Locale)locale);
        }

        public boolean supportsEndDate() {
            return CALL.equals((Object)this) || MEETING.equals((Object)this);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum Status implements Translatable
    {
        PLANNED(I18n.marktr((String)"planned")),
        FINISHED(I18n.marktr((String)"finished")),
        CANCELLED(I18n.marktr((String)"cancelled"));

        private final String i18nKey;

        private Status(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCrmActivity.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum Direction implements Translatable
    {
        IN(I18n.marktr((String)"incoming")),
        OUT(I18n.marktr((String)"outgoing"));

        private final String i18nKey;

        private Direction(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCrmActivity.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

