/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingFeedback;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCrmMarketing
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCrmMarketing.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCrmMarketing.class);
    public long id = 0L;
    public String title = null;
    public String notes = null;
    public Status status = null;
    public Interval interval = null;
    public BigDecimal costs = null;
    public Date begin = null;
    public Date end = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public Map<Long, DbCrmMarketingFeedback> feedback = null;

    public static ObjectToStringConverter createObjectToStringConverter() {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof DbCrmMarketing) {
                    return ((DbCrmMarketing)object).print();
                }
                return "-";
            }

            public String[] getPossibleStringsForItem(Object object) {
                if (object instanceof DbCrmMarketing) {
                    DbCrmMarketing dbCrmMarketing = (DbCrmMarketing)object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(this.getPreferredStringForItem(object));
                    if (dbCrmMarketing.title != null && !arrayList.contains(dbCrmMarketing.title)) {
                        arrayList.add(dbCrmMarketing.title);
                    }
                    return arrayList.toArray(new String[0]);
                }
                return super.getPossibleStringsForItem(object);
            }
        };
    }

    public String print() {
        DateFormat dateFormat = DateFormat.getDateInstance(3);
        String string = "";
        if (this.begin != null) {
            string = string + dateFormat.format(this.begin);
        }
        if (this.end != null) {
            string = string + " - " + dateFormat.format(this.end);
        }
        String string2 = !StringUtils.isEmpty((CharSequence)string) ? string.trim() + " | " + this.title : this.title;
        return !StringUtils.isEmpty((CharSequence)string2) ? string2.trim() : "";
    }

    public static enum Status implements Translatable
    {
        PLANNED(I18n.marktr((String)"planned")),
        RUNNING(I18n.marktr((String)"ongoing")),
        FINISHED(I18n.marktr((String)"finished")),
        CANCELLED(I18n.marktr((String)"cancelled"));

        private final String i18nKey;

        private Status(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCrmMarketing.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum Interval implements Translatable
    {
        UNIQUE(I18n.marktr((String)"unique")),
        DAILY(I18n.marktr((String)"daily")),
        WEEKLY(I18n.marktr((String)"weekly")),
        MONTHLY(I18n.marktr((String)"monthly")),
        QUARTERLY(I18n.marktr((String)"three-monthly")),
        HALF_YEARLY(I18n.marktr((String)"half-yearly")),
        YEARLY(I18n.marktr((String)"yearly"));

        private final String i18nKey;

        private Interval(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCrmMarketing.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

