/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmMarketing;
import com.openindex.openestate.tool.crm.db.DbCrmMarketingHandler;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import com.openindex.openestate.tool.gui.DefaultMenu;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmFrameSidebarExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ACTIVITY = 4;
    public static final int MENU_ADD_MARKETING = 5;
    public static final int MENU_ADD_END = 6;
    public static final int MENU_SELECTION = 7;
    public static final int MENU_END = 8;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = CrmFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, CrmFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        CrmFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.SidebarRefreshAction())));
        CrmFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the CRM addon."));
            }
        };
        defaultMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        CrmFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES_EDIT)) {
            for (DbCrmActivity.Type type : DbCrmActivity.Type.values()) {
                defaultMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.ActivityFormAction(type))));
            }
        }
        CrmFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS_EDIT)) {
            if (defaultMenu.getItemCount() > 0) {
                defaultMenu.addSeparator();
            }
            defaultMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.MarketingFormAction())));
        }
        CrmFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        CrmFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)defaultMenu);
        }
        CrmFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        if (treeNode != null) {
            if (treeNode.isActivity() && CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES)) {
                String string = treeNode.getActivityType() != null ? treeNode.getActivityType().getTranslation() : StringUtils.capitalize((String)I18N.tr("activities"));
                jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)string, (int)35)));
                jPopupMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.ActivityTableAction(treeNode.getActivityType(), true))));
            } else if (treeNode.isMarketing() && CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS)) {
                DbCrmMarketing dbCrmMarketing = treeNode.getMarketing();
                String string = treeNode.getMarketing() != null ? StringUtils.trimToEmpty((String)treeNode.getMarketing().title) : StringUtils.capitalize((String)I18N.tr("marketing actions"));
                jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)string, (int)35)));
                jPopupMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.MarketingTableAction(true))));
                if (dbCrmMarketing != null && dbCrmMarketing.id > 0L) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new CrmPlugin.MarketingFormAction(dbCrmMarketing.id))));
                }
            }
        }
        CrmFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        CrmFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)8, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode(0))));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModel createTreeModel() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbCrmMarketingHandler dbCrmMarketingHandler = CrmPlugin.getDbCrmExtension().getCrmMarketingHandler();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            TreeModel treeModel = CrmFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbCrmMarketingHandler);
            return treeModel;
        }
        catch (Exception exception) {
            LOGGER.error("Can't load marketings!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            TreeModel treeModel = null;
            return treeModel;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static TreeModel createTreeModel(ImmoToolProject immoToolProject, Connection connection, DbCrmMarketingHandler dbCrmMarketingHandler) throws SQLException {
        Object object;
        TreeNode treeNode = new TreeNode(0);
        if (CrmPlugin.isUserAllowedTo(CrmPermission.ACTIVITIES)) {
            object = new TreeNode(1);
            for (FrameSidebarAddonExtension frameSidebarAddonExtension : DbCrmActivity.Type.values()) {
                object.add((MutableTreeNode)((Object)new TreeNode((DbCrmActivity.Type)frameSidebarAddonExtension)));
            }
            treeNode.add((MutableTreeNode)object);
        }
        if (CrmPlugin.isUserAllowedTo(CrmPermission.MARKETINGS)) {
            object = new TreeNode(2);
            for (FrameSidebarAddonExtension frameSidebarAddonExtension : dbCrmMarketingHandler.getMarketings(connection, DbCrmMarketing.Status.RUNNING)) {
                object.add((MutableTreeNode)((Object)new TreeNode((DbCrmMarketing)frameSidebarAddonExtension)));
            }
            treeNode.add((MutableTreeNode)object);
        }
        for (FrameSidebarAddonExtension frameSidebarAddonExtension : CrmFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, CrmFrameSidebarExtension.class)) {
            frameSidebarAddonExtension.initTree(connection, (SidebarTreeNode)treeNode);
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode));
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return CrmPlugin.getResourceIcon("crm.png", 32);
    }

    public JPopupMenu getMenu() {
        return CrmFrameSidebarExtension.createActionMenu(null);
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public String getTitle() {
        return I18N.tr("CRM");
    }

    public String getTooltipText() {
        return I18N.tr("Manage CRM data.");
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() {
                return CrmFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandAll();
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            CrmFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid crm-tree was registered!");
            CrmFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        CrmFrameSidebarExtension.setCurrentSidebar(null, null);
    }

    public static class TreeNode
    extends SidebarTreeNode {
        private static final int TYPE_ROOT = 0;
        private static final int TYPE_ACTIVITY = 1;
        private static final int TYPE_MARKETING = 2;
        private DbCrmActivity.Type activityType = null;
        private DbCrmMarketing marketing = null;
        private int type = 0;

        private TreeNode(int n) {
            this.type = n;
            this.activityType = null;
            this.marketing = null;
        }

        private TreeNode(DbCrmMarketing dbCrmMarketing) {
            this.type = 2;
            this.activityType = null;
            this.marketing = dbCrmMarketing;
        }

        private TreeNode(DbCrmActivity.Type type) {
            this.type = 1;
            this.activityType = type;
            this.marketing = null;
        }

        public void doShow(boolean bl) {
            switch (this.type) {
                case 1: {
                    new CrmPlugin.ActivityTableAction(this.activityType, bl).actionPerformed(null);
                    break;
                }
                case 2: {
                    if (this.marketing != null) {
                        new CrmPlugin.MarketingFormAction(this.marketing.id).actionPerformed(null);
                        break;
                    }
                    new CrmPlugin.MarketingTableAction(bl).actionPerformed(null);
                    break;
                }
            }
        }

        public DbCrmActivity.Type getActivityType() {
            return this.activityType;
        }

        public DbCrmMarketing getMarketing() {
            return this.marketing;
        }

        public JPopupMenu getMenu() {
            return CrmFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            switch (this.type) {
                case 1: {
                    return this.activityType != null ? this.activityType.getIcon(16) : CrmPlugin.getResourceIcon("crm.png", 16);
                }
                case 2: {
                    return this.marketing != null ? null : CrmPlugin.getResourceIcon("crm.png", 16);
                }
            }
            return null;
        }

        public String getNodeText() {
            switch (this.type) {
                case 1: {
                    return this.activityType != null ? this.activityType.getTranslation() : this.title(StringUtils.capitalize((String)I18N.tr("activities")));
                }
                case 2: {
                    return this.marketing != null ? StringEscapeUtils.escapeXml11((String)this.marketing.title) : this.title(StringUtils.capitalize((String)I18N.tr("marketing actions")));
                }
            }
            return "";
        }

        public String getNodeTooltip() {
            return null;
        }

        public int getType() {
            return this.type;
        }

        public boolean isActivity() {
            return this.type == 1;
        }

        public boolean isMarketing() {
            return this.type == 2;
        }

        public void setActivityType(DbCrmActivity.Type type) {
            this.activityType = type;
        }

        public void setMarketing(DbCrmMarketing dbCrmMarketing) {
            this.marketing = dbCrmMarketing;
        }
    }

    public static class Tree
    extends SidebarTree {
        public TreeNode getAllActivitiesNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (1 != treeNode2.getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getAllMarketingsNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (2 != treeNode2.getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getRootNode() {
            return (TreeNode)((Object)this.getModel().getRoot());
        }
    }
}

