/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.crm.extensions.ActivityViewExtension;
import com.openindex.openestate.tool.crm.extensions.DbCrmExtension;
import com.openindex.openestate.tool.crm.extensions.MarketingViewExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmPluginUtils.class);

    private CrmPluginUtils() {
    }

    public static Collection<ActivityViewExtension> getActivityViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ActivityViewExtension> arrayList = new ArrayList<ActivityViewExtension>();
        for (Object object : CrmPluginUtils.getExtensionHandlers("ActivityViewExtension", ActivityViewExtension.class, immoToolProject, null)) {
            arrayList.add((ActivityViewExtension)object);
        }
        return arrayList;
    }

    public static DbCrmExtension getDbCrmExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? CrmPluginUtils.getDbCrmExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbCrmExtension getDbCrmExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? CrmPluginUtils.getDbCrmExtension(abstractDbDriver.getName()) : null;
    }

    public static DbCrmExtension getDbCrmExtension(String string) {
        for (Object object : CrmPluginUtils.getExtensionHandlers("DbCrmExtension", DbCrmExtension.class, null, null)) {
            DbCrmExtension dbCrmExtension = (DbCrmExtension)object;
            if (!dbCrmExtension.isSupportedDriver(string)) continue;
            return dbCrmExtension;
        }
        return null;
    }

    public static Collection<DbCrmExtension> getDbCrmExtensions() {
        ArrayList<DbCrmExtension> arrayList = new ArrayList<DbCrmExtension>();
        for (Object object : CrmPluginUtils.getExtensionHandlers("DbCrmExtension", DbCrmExtension.class, null, null)) {
            arrayList.add((DbCrmExtension)object);
        }
        return arrayList;
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-CRM", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    public static Collection<MarketingViewExtension> getMarketingViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MarketingViewExtension> arrayList = new ArrayList<MarketingViewExtension>();
        for (Object object : CrmPluginUtils.getExtensionHandlers("MarketingViewExtension", MarketingViewExtension.class, immoToolProject, null)) {
            arrayList.add((MarketingViewExtension)object);
        }
        return arrayList;
    }
}

