/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.agency;

import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateRelationPanel;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.crm.CrmActivityViewPanel;
import com.openindex.openestate.tool.crm.addons.agency.CrmAgencyUtils;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmActivityAgencyObject;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityEstateTablePanel
extends CrmActivityViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityEstateTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityEstateTablePanel.class);
    private static final String RELATION_TABLE_ID = "CrmActivityEstateTablePanel.RelationTable";
    private DbCrmActivity currentActivity = null;
    private JXTitledSeparator objectsTitle;
    private RelationTable objectsTable;
    private RelationForm relationForm;
    private AbstractI18nAction relationAddAction;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction showActionsAction;

    public CrmActivityEstateTablePanel() {
        this.build();
    }

    private void build() {
        this.objectsTable = new RelationTable();
        this.objectsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.objectsTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.objectsTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.objectsTable.setEnabled(false);
        this.objectsTable.clearSelection();
        this.objectsTable.clearRows();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        try {
            DbCrmAgencyHandler dbCrmAgencyHandler = CrmAgencyUtils.getCrmAgencyHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            Map map = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
            DbCrmActivityAgencyObject[] dbCrmActivityAgencyObjectArray = dbCrmAgencyHandler.getActivityAgencyObjects(connection, this.currentActivity.id);
            long[] lArray = new long[dbCrmActivityAgencyObjectArray.length];
            for (int i = 0; i < dbCrmActivityAgencyObjectArray.length; ++i) {
                lArray[i] = dbCrmActivityAgencyObjectArray[i].agencyObjectId;
            }
            DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, lArray);
            dbAgencyObjectsHandler.loadObjectAttribs(connection, dbObjectArray, map);
            dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, map);
            arrayList.addAll(Arrays.asList(dbObjectArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$objectsList;
                {
                    this.val$objectsList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbObject dbObject : this.val$objectsList) {
                            CrmActivityEstateTablePanel.this.objectsTable.addRow((AbstractTable.Row)new AgencyEstateTable.Row((DbAgencyObject)dbObject));
                        }
                    }
                    finally {
                        CrmActivityEstateTablePanel.this.objectsTable.setEnabled(true);
                        CrmActivityEstateTablePanel.this.showActionsAction.setEnabled(false);
                        CrmActivityEstateTablePanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doObjectView() {
        int n = this.objectsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.objectsTable.getEstateIdAt(this.objectsTable.convertRowIndexToModel(n));
        new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
    }

    private void doRefresh() {
        try {
            this.load(this.currentActivity);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload properties for activity!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload properties for activity!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.objectsTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.objectsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ObjectViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("properties"));
    }

    public boolean isLoadedInBackground() {
        return this.currentActivity != null && this.currentActivity.id > 0L;
    }

    public void load(DbCrmActivity dbCrmActivity) throws ImmoToolException {
        this.currentActivity = dbCrmActivity;
        this.relationForm.unselectRelation();
        this.objectsTable.setEnabled(false);
        this.objectsTable.clearSelection();
        this.objectsTable.clearRows();
        this.showActionsAction.setEnabled(false);
        this.updateTitle();
    }

    public void save(DbCrmActivity dbCrmActivity) throws ImmoToolException {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmActivity dbCrmActivity) throws SQLException, IOException {
        Object object2;
        DbCrmAgencyHandler dbCrmAgencyHandler = CrmAgencyUtils.getCrmAgencyHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbCrmAgencyHandler.getActivityAgencyObjects(connection, dbCrmActivity.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object2 : objectArray) {
                hashMap.put(((DbCrmActivityAgencyObject)object2).agencyObjectId, object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.objectsTable.getRowCount(); ++i) {
            Long l = this.objectsTable.getEstateIdAt(i);
            object2 = hashMap.containsKey(l) ? (DbCrmActivityAgencyObject)hashMap.get(l) : new DbCrmActivityAgencyObject();
            ((DbCrmActivityAgencyObject)object2).agencyObjectId = l;
            ((DbCrmActivityAgencyObject)object2).crmActivityId = dbCrmActivity.id;
            dbCrmAgencyHandler.saveActivityAgencyObject(connection, (DbCrmActivityAgencyObject)object2);
            arrayList.add(l);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Long)entry.getKey();
            if (arrayList.contains(object2)) continue;
            dbCrmAgencyHandler.removeActivityAgencyObject(connection, (DbCrmActivityAgencyObject)entry.getValue());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("properties for the activity"));
        int n2 = n = this.objectsTable != null ? this.objectsTable.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.objectsTitle.setTitle(string);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        public ShowActionsAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmActivityEstateTablePanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        public RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityEstateTablePanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        public RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityEstateTablePanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmActivityEstateTablePanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        public RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityEstateTablePanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ObjectViewAction
    extends AbstractI18nAction {
        public ObjectViewAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityEstateTablePanel.this.doObjectView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private final class RelationTable
    extends AgencyEstateTable<AgencyEstateTable.Row> {
        public RelationTable() {
            super(CrmActivityEstateTablePanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CrmActivityEstateTablePanel.this.doRelationRemove();
        }

        protected void doSelect() {
            if (!this.isEnabled()) {
                return;
            }
            CrmActivityEstateTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmActivityEstateTablePanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CrmActivityEstateTablePanel.this.relationForm.selectRelation(this.getEstateAt(n), null);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmActivityEstateTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmActivityEstateTablePanel.this.doObjectView();
        }
    }

    private final class RelationForm
    extends AgencyEstateRelationPanel {
        private RelationForm() {
            super(false);
        }

        protected void close() {
            if (CrmActivityEstateTablePanel.this.objectsTable.getSelectedRowCount() > 0) {
                CrmActivityEstateTablePanel.this.objectsTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbAgencyObject dbAgencyObject, String string) {
            if (dbAgencyObject == null) {
                return false;
            }
            CrmActivityEstateTablePanel.this.objectsTable.setEnabled(false);
            try {
                if (this.getCurrentAgencyObjectId() < 1L) {
                    CrmActivityEstateTablePanel.this.objectsTable.addRow((AbstractTable.Row)new AgencyEstateTable.Row(dbAgencyObject));
                } else {
                    int n = CrmActivityEstateTablePanel.this.objectsTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmActivityEstateTablePanel.this.objectsTable.convertRowIndexToModel(n);
                        CrmActivityEstateTablePanel.this.objectsTable.setRowAt(n2, (AbstractTable.Row)new AgencyEstateTable.Row(dbAgencyObject));
                    }
                }
            }
            finally {
                CrmActivityEstateTablePanel.this.objectsTable.clearSelection();
                CrmActivityEstateTablePanel.this.objectsTable.setEnabled(true);
                CrmActivityEstateTablePanel.this.updateTitle();
            }
            return true;
        }
    }
}

