/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.openindex.openestate.tool.crm.addons.mail.CrmMailsUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.extensions.MailAccountSetupAdapter;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountSetupCrmExtension
extends MailAccountSetupAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountSetupCrmExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountSetupCrmExtension.class);
    private final JCheckBox crmStoreAfterTransportBox = new JCheckBox();

    public MailAccountSetupCrmExtension() {
        this.crmStoreAfterTransportBox.setName("crmStoreAfterTransportBox");
        this.crmStoreAfterTransportBox.setText("E-Mails bei Versand im CRM archivieren");
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public JComponent[] getWriterFurtherOptions(AbstractMailWriter.Type type) {
        if (!AbstractMailWriter.Type.SMTP.equals((Object)type)) {
            return null;
        }
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(this.crmStoreAfterTransportBox);
        return new JComponent[]{jPanel};
    }

    public void load(DbMailAccount dbMailAccount) {
        super.load(dbMailAccount);
        this.crmStoreAfterTransportBox.setSelected(CrmMailsUtils.isCrmStoreAfterTransport(dbMailAccount));
    }

    public void save(DbMailAccount dbMailAccount) {
        super.save(dbMailAccount);
        CrmMailsUtils.setCrmStoreAfterTransport(dbMailAccount, this.crmStoreAfterTransportBox.isSelected());
    }
}

