/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.openindex.openestate.tool.contacts.addons.mail.MailEditorContactsExtension;
import com.openindex.openestate.tool.crm.addons.mail.CrmMailsUtils;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.extensions.MailEditorAdapter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailEditorCrmExtension
extends MailEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailEditorCrmExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailEditorCrmExtension.class);
    private final JCheckBoxMenuItem crmOptionItem = new JCheckBoxMenuItem();

    public MailEditorCrmExtension() {
        this.crmOptionItem.setName("crmOptionItem");
        this.crmOptionItem.setText("Bei Versand im CRM archivieren");
    }

    public JMenuItem[] createOptionMenuItems(MailEditor mailEditor) {
        JMenuItem[] jMenuItemArray;
        if (this.crmOptionItem != null) {
            JMenuItem[] jMenuItemArray2 = new JMenuItem[1];
            jMenuItemArray = jMenuItemArray2;
            jMenuItemArray2[0] = this.crmOptionItem;
        } else {
            jMenuItemArray = null;
        }
        return jMenuItemArray;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public void saveMessage(Connection connection, DbMailMessage dbMailMessage, Map<MailEditor.RecipientType, List<MailEditor.Address>> map, MailEditor.SaveMode saveMode) throws SQLException {
        super.saveMessage(connection, dbMailMessage, map, saveMode);
        if (MailEditor.SaveMode.OUTBOX.equals((Object)saveMode) && this.crmOptionItem != null && this.crmOptionItem.isSelected()) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (map != null && !map.isEmpty()) {
                for (List list : map.values()) {
                    if (list == null || list.isEmpty()) continue;
                    for (MailEditor.Address address : list) {
                        long[] lArray;
                        if (!(address instanceof MailEditorContactsExtension.ContactsAddress) || ArrayUtils.isEmpty((long[])(lArray = ((MailEditorContactsExtension.ContactsAddress)address).getContactsEntryIds()))) continue;
                        for (long l : lArray) {
                            if (arrayList.contains(l)) continue;
                            arrayList.add(l);
                        }
                    }
                }
            }
            try {
                Object object = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
                CrmMailsUtils.addCrmActivityMailMessage(connection, dbMailMessage, (long[])object);
            }
            catch (SQLException sQLException) {
                LOGGER.error("Can' save CRM activity!");
                LOGGER.error("> " + sQLException.getLocalizedMessage(), (Throwable)sQLException);
                throw sQLException;
            }
            catch (Exception exception) {
                LOGGER.error("Can' save CRM activity!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                throw new SQLException("Can' save CRM activity!", exception);
            }
        }
    }

    public void selectAccount(DbMailAccount dbMailAccount) {
        super.selectAccount(dbMailAccount);
        this.crmOptionItem.setSelected(CrmMailsUtils.isCrmStoreAfterTransport(dbMailAccount));
    }
}

