/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.MailAccountLocalTab;
import com.openindex.openestate.tool.mail.MailAccountPermissionTab;
import com.openindex.openestate.tool.mail.MailAccountPropertiesTab;
import com.openindex.openestate.tool.mail.MailAccountReaderTab;
import com.openindex.openestate.tool.mail.MailAccountSenderTab;
import com.openindex.openestate.tool.mail.MailAccountWriterTab;
import com.openindex.openestate.tool.mail.MailPermission;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandler;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.utils.DisposableComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.java.balloontip.BalloonTip;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailAccountDialog
extends AbstractDialog
implements DisposableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountDialog.class);
    private DbMailExtension dbMailExtension = null;
    private List<Long> removedAccounts = new ArrayList<Long>();
    private DbMailAccount currentAccount = null;
    private int createCounter = 0;
    private SubmitTask submitTask = null;
    private boolean submitted = false;
    private JXTree accountTree;
    private JScrollPane accountScroller;
    private JPanel formPanel;
    private Icon remoteAccountIconSmall;
    private Icon localSharedAccountIconSmall;
    private BalloonTip accountAddBalloonTip;
    private JLabel accountAddBalloonLabel;

    private MailAccountDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.setSize(new Dimension(600, 500));
        this.setLocationRelativeTo(frame);
    }

    private MailAccountDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.setSize(new Dimension(600, 500));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        JButton jButton = new JButton((Action)((Object)new AccountMenuAction()));
        this.accountAddBalloonLabel = new JLabel();
        this.accountAddBalloonLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
        this.accountAddBalloonTip = new BalloonTip((JComponent)jButton, (JComponent)this.accountAddBalloonLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.LEFT_ABOVE, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
        this.accountAddBalloonTip.setVisible(false);
        buttonBarBuilder.addFixed((JComponent)jButton);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)new SubmitAction())));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)new CancelAction())));
    }

    protected JComponent buildMainComponent() {
        this.formPanel = new JPanel(new BorderLayout(5, 5));
        this.formPanel.setOpaque(false);
        return this.formPanel;
    }

    protected JComponent buildMainLeftComponent() {
        this.remoteAccountIconSmall = MailPlugin.getResourceIcon("account_remote.png", 16);
        this.localSharedAccountIconSmall = MailPlugin.getResourceIcon("account_local_shared.png", 16);
        this.accountTree = new JXTree((TreeModel)new DefaultTreeModel(new Node()));
        this.accountTree.setRootVisible(false);
        this.accountTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        this.accountTree.getSelectionModel().setSelectionMode(1);
        this.accountTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!MailAccountDialog.this.accountTree.isEnabled()) {
                    return;
                }
                MailAccountDialog.this.selectNode();
            }
        });
        this.accountTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath;
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && (treePath = MailAccountDialog.this.accountTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    MailAccountDialog.this.accountTree.setSelectionPath(treePath);
                    MailAccountDialog.this.doAccountMenu((Component)MailAccountDialog.this.accountTree, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.accountScroller = new JScrollPane((Component)this.accountTree);
        this.accountScroller.setPreferredSize(new Dimension(150, 100));
        return this.accountScroller;
    }

    public void dispose() {
        if (this.accountAddBalloonTip != null) {
            this.accountAddBalloonTip.closeBalloon();
        }
    }

    private void doAccountAddLocalShared() {
        DbMailAccount dbMailAccount = new DbMailAccount();
        dbMailAccount.settings = new HashMap<String, String>();
        dbMailAccount.name = StringUtils.capitalize((String)I18N.tr("local account")) + " (" + ++this.createCounter + ")";
        dbMailAccount.type = DbMailAccount.Type.LOCAL_SHARED;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.accountTree.getModel().getRoot();
        Node node = new Node(dbMailAccount, this, ImmoToolProject.getAppInstance());
        ((DefaultTreeModel)this.accountTree.getModel()).insertNodeInto(node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        TreePath treePath = new TreePath(new Object[]{defaultMutableTreeNode, node});
        this.accountTree.expandPath(treePath);
        this.accountTree.setEnabled(false);
        this.accountTree.setSelectionPath(treePath);
        this.accountTree.setEnabled(true);
        this.selectNode();
        this.accountTree.treeDidChange();
        this.updateTree();
    }

    private void doAccountAddRemote() {
        DbMailAccount dbMailAccount = new DbMailAccount();
        dbMailAccount.settings = new HashMap<String, String>();
        dbMailAccount.name = StringUtils.capitalize((String)I18N.tr("mail account")) + " (" + ++this.createCounter + ")";
        dbMailAccount.type = DbMailAccount.Type.REMOTE;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.accountTree.getModel().getRoot();
        Node node = new Node(dbMailAccount, this, ImmoToolProject.getAppInstance());
        ((DefaultTreeModel)this.accountTree.getModel()).insertNodeInto(node, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        TreePath treePath = new TreePath(new Object[]{defaultMutableTreeNode, node});
        this.accountTree.expandPath(treePath);
        this.accountTree.setEnabled(false);
        this.accountTree.setSelectionPath(treePath);
        this.accountTree.setEnabled(true);
        this.selectNode();
        this.accountTree.treeDidChange();
        this.updateTree();
    }

    private void doAccountMenu(Component component, int n, int n2) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.accountTree.getModel().getRoot();
        TreePath treePath = this.accountTree.getSelectionPath();
        Node node = treePath != null && treePath.getPathCount() > 1 ? (Node)treePath.getLastPathComponent() : null;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new AccountAddRemoteAction()));
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            jPopupMenu.add((Action)((Object)new AccountAddLocalSharedAction()));
        }
        jPopupMenu.add((Action)((Object)new AccountRemoveAction(node != null && node.mayRemoveAccount)));
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0) {
            jPopupMenu.addSeparator();
            jPopupMenu.add((Action)((Object)new TreeMinimizeAction()));
            jPopupMenu.add((Action)((Object)new TreeMaximizeAction()));
        }
        jPopupMenu.show(component, n, n2);
    }

    private void doAccountRemove() {
        TreePath treePath = this.accountTree.getSelectionPath();
        if (treePath == null || treePath.getPathCount() < 2) {
            return;
        }
        Node node = (Node)treePath.getPathComponent(1);
        if (!node.mayRemoveAccount) {
            return;
        }
        this.removedAccounts.add(node.getAccount().id);
        this.accountTree.setEnabled(false);
        ((DefaultTreeModel)this.accountTree.getModel()).removeNodeFromParent(node);
        this.accountTree.clearSelection();
        this.accountTree.setEnabled(true);
        this.selectNode();
        this.updateTree();
    }

    private void doSubmit() {
        Node node = (Node)this.accountTree.getModel().getRoot();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            if (!node2.mayEditAccount) continue;
            MailAccountDialogForm mailAccountDialogForm = node2.getForm();
            if (mailAccountDialogForm.getValidationHandler() != null) {
                mailAccountDialogForm.getValidationHandler().validate();
                if (!mailAccountDialogForm.getValidationHandler().isValid()) {
                    arrayList.add(node2.getNodeText());
                }
            }
            for (int j = 0; j < node2.getChildCount(); ++j) {
                Node node3 = (Node)node2.getChildAt(j);
                MailAccountDialogForm mailAccountDialogForm2 = node3.getForm();
                if (mailAccountDialogForm2.getValidationHandler() == null) continue;
                mailAccountDialogForm2.getValidationHandler().validate();
                if (mailAccountDialogForm2.getValidationHandler().isValid()) continue;
                arrayList.add(node2.getNodeText() + " / " + node3.getNodeText());
            }
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), arrayList, (Component)((Object)this));
            return;
        }
        this.submitted = true;
        this.submitTask = new SubmitTask(this.getModifiedAccounts(), this.getRemovedAccountIds(), this.dbMailExtension);
        this.setVisible(false);
    }

    private void doTreeMaximize() {
        Node node = (Node)this.accountTree.getModel().getRoot();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            this.accountTree.expandPath(new TreePath(new Object[]{node, node2}));
        }
    }

    private void doTreeMinimize() {
        Node node = (Node)this.accountTree.getModel().getRoot();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            this.accountTree.collapsePath(new TreePath(new Object[]{node, node2}));
        }
    }

    public Node getCurrentAccountNode() {
        TreePath treePath = this.accountTree.getSelectionPath();
        return treePath != null && treePath.getPathCount() > 1 ? (Node)treePath.getPathComponent(1) : null;
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("setup mail accounts"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"configure.png", (int)32);
    }

    protected String getHeaderTitle() {
        if (this.currentAccount != null && !StringUtils.isBlank((CharSequence)this.currentAccount.name)) {
            return StringUtils.capitalize((String)I18N.tr("mail account")) + " '" + StringUtils.trimToEmpty((String)this.currentAccount.name) + "'";
        }
        return StringUtils.capitalize((String)I18N.tr("setup mail accounts"));
    }

    private DbMailAccount[] getModifiedAccounts() {
        Node node = (Node)this.accountTree.getModel().getRoot();
        ArrayList<DbMailAccount> arrayList = new ArrayList<DbMailAccount>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            int n;
            Node node2 = (Node)node.getChildAt(i);
            if (!node2.mayEditAccount) continue;
            DbMailAccount dbMailAccount = node2.getAccount();
            int n2 = dbMailAccount.calculateHash();
            MailAccountDialogForm mailAccountDialogForm = node2.getForm();
            if (mailAccountDialogForm != null) {
                mailAccountDialogForm.save(dbMailAccount);
            }
            for (n = 0; n < node2.getChildCount(); ++n) {
                Node node3 = (Node)node2.getChildAt(n);
                MailAccountDialogForm mailAccountDialogForm2 = node3.getForm();
                if (mailAccountDialogForm2 == null) continue;
                mailAccountDialogForm2.save(dbMailAccount);
            }
            n = dbMailAccount.calculateHash();
            if (dbMailAccount.id <= 0L) {
                LOGGER.debug("Add mail account (" + dbMailAccount.name + ")");
                arrayList.add(dbMailAccount);
                continue;
            }
            if (n2 == n) continue;
            LOGGER.debug("Update mail account #" + dbMailAccount.id + " (" + dbMailAccount.name + ")");
            arrayList.add(dbMailAccount);
        }
        return arrayList.toArray(new DbMailAccount[0]);
    }

    private Long[] getRemovedAccountIds() {
        return this.removedAccounts.toArray(new Long[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(DbMailAccount[] dbMailAccountArray, Long l) {
        Node node;
        Node node2;
        block7: {
            this.createCounter = 0;
            this.removedAccounts.clear();
            this.accountTree.setEnabled(false);
            node2 = new Node();
            ((DefaultTreeModel)this.accountTree.getModel()).setRoot(node2);
            node = null;
            try {
                TreeSet<DbMailAccount> treeSet = new TreeSet<DbMailAccount>();
                treeSet.addAll(Arrays.asList(dbMailAccountArray));
                for (DbMailAccount dbMailAccount : treeSet) {
                    Node node3 = new Node(dbMailAccount, this, ImmoToolProject.getAppInstance());
                    node2.add(node3);
                    if (l == null || dbMailAccount.id != l) continue;
                    node = node3;
                }
                if (node == null) break block7;
                this.accountTree.setSelectionPath(new TreePath(new Object[]{node2, node}));
            }
            catch (Throwable throwable) {
                for (int i = 0; i < node2.getChildCount(); ++i) {
                    this.accountTree.expandPath(new TreePath(new Object[]{node2, node2.getChildAt(i)}));
                }
                this.accountTree.setEnabled(true);
                this.accountTree.repaint();
                if (node != null) {
                    this.selectNode();
                }
                this.updateTree();
                throw throwable;
            }
        }
        for (int i = 0; i < node2.getChildCount(); ++i) {
            this.accountTree.expandPath(new TreePath(new Object[]{node2, node2.getChildAt(i)}));
        }
        this.accountTree.setEnabled(true);
        this.accountTree.repaint();
        if (node != null) {
            this.selectNode();
        }
        this.updateTree();
    }

    private void selectNode() {
        try {
            if (this.accountTree.getSelectionCount() < 1) {
                this.currentAccount = null;
                this.formPanel.removeAll();
                this.formPanel.revalidate();
                this.formPanel.repaint();
                return;
            }
            Node node = (Node)this.accountTree.getSelectionPath().getLastPathComponent();
            this.currentAccount = node.getAccount();
            if (this.currentAccount == null) {
                return;
            }
            MailAccountDialogForm mailAccountDialogForm = node.getForm();
            this.formPanel.removeAll();
            if (mailAccountDialogForm != null) {
                this.formPanel.add((Component)((Object)mailAccountDialogForm), "Center");
            }
            this.formPanel.revalidate();
            this.formPanel.repaint();
        }
        finally {
            this.updateLocalization();
        }
    }

    public static SubmitTask showDialog(DbMailExtension dbMailExtension, ImmoToolProject immoToolProject, Window window) throws SQLException {
        return MailAccountDialog.showDialog(0L, dbMailExtension, immoToolProject, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubmitTask showDialog(long l, DbMailExtension dbMailExtension, ImmoToolProject immoToolProject, Window window) throws SQLException {
        Object object;
        if (dbMailExtension == null) {
            LOGGER.warn("The mail addon is not properly initialized.");
            return null;
        }
        DbMailAccountHandler dbMailAccountHandler = dbMailExtension.getAccountHandler();
        MailAccountDialog mailAccountDialog = null;
        try {
            mailAccountDialog = window instanceof Dialog ? new MailAccountDialog((Dialog)window) : (window instanceof Frame ? new MailAccountDialog((Frame)window) : new MailAccountDialog((Frame)null));
            mailAccountDialog.dbMailExtension = dbMailExtension;
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                object = dbMailAccountHandler.getAccounts(connection, new DbMailAccount.Type[]{DbMailAccount.Type.REMOTE, DbMailAccount.Type.LOCAL_SHARED}, null);
                dbMailAccountHandler.loadAccountSettings(connection, (DbMailAccount[])object);
                mailAccountDialog.load((DbMailAccount[])object, l);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            mailAccountDialog.setVisible(true);
            object = mailAccountDialog.submitted ? mailAccountDialog.submitTask : null;
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(mailAccountDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)mailAccountDialog));
        return object;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.accountAddBalloonLabel.setText(I18N.tr("Click this button to create a new mail account."));
    }

    private void updateTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.accountTree.getModel().getRoot();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() < 1) {
            this.accountScroller.setVisible(false);
            if (!this.accountAddBalloonTip.isVisible()) {
                this.accountAddBalloonTip.setVisible(true);
            }
        } else {
            this.accountScroller.setVisible(true);
            if (this.accountAddBalloonTip.isVisible()) {
                this.accountAddBalloonTip.setVisible(false);
            }
        }
    }

    private static class NodeRenderer
    extends DefaultXTreeCellRenderer {
        private NodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof Node) {
                Node node = (Node)object;
                Icon icon = node.getNodeIcon();
                if (icon != null) {
                    jLabel.setIcon(icon);
                }
                jLabel.setText(node.isAccountChildNode() ? "<html>" + node.getNodeText() + "</html>" : "<html><b>" + node.getNodeText() + "</b></html>");
            }
            return jLabel;
        }
    }

    public class Node
    extends DefaultMutableTreeNode {
        private final DbMailAccount account;
        private final boolean accountChildNode;
        private final MailAccountDialogForm form;
        private final boolean mayEditAccount;
        private final boolean mayRemoveAccount;

        public Node() {
            this.account = null;
            this.accountChildNode = false;
            this.form = null;
            this.mayEditAccount = false;
            this.mayRemoveAccount = false;
        }

        public Node(DbMailAccount dbMailAccount, MailAccountDialog mailAccountDialog2, ImmoToolProject immoToolProject) {
            this.account = dbMailAccount;
            this.accountChildNode = false;
            this.mayEditAccount = dbMailAccount.id < 1L || dbMailAccount.permission.canWrite(immoToolProject.getUser(), dbMailAccount.ownerUserId, dbMailAccount.ownerGroupId) && MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT);
            boolean bl = this.mayRemoveAccount = dbMailAccount.id < 1L || dbMailAccount.permission.canDelete(immoToolProject.getUser(), dbMailAccount.ownerUserId, dbMailAccount.ownerGroupId) && MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_REMOVE);
            if (dbMailAccount.isRemote()) {
                this.form = new MailAccountSenderTab(mailAccountDialog2);
                this.form.load(dbMailAccount);
                this.form.loadInBackground(immoToolProject);
                this.form.setEnabled(this.mayEditAccount);
                this.add(new Node(dbMailAccount, new MailAccountReaderTab(mailAccountDialog2), immoToolProject, this.mayEditAccount, this.mayRemoveAccount));
                this.add(new Node(dbMailAccount, new MailAccountWriterTab(mailAccountDialog2), immoToolProject, this.mayEditAccount, this.mayRemoveAccount));
                this.add(new Node(dbMailAccount, new MailAccountPropertiesTab(mailAccountDialog2), immoToolProject, this.mayEditAccount, this.mayRemoveAccount));
                if (immoToolProject != null && immoToolProject.isRemoteProject()) {
                    this.add(new Node(dbMailAccount, new MailAccountPermissionTab(mailAccountDialog2), immoToolProject, this.mayEditAccount, this.mayRemoveAccount));
                }
            } else {
                this.form = new MailAccountLocalTab(mailAccountDialog2);
                this.form.load(dbMailAccount);
                this.form.loadInBackground(immoToolProject);
                this.form.setEnabled(this.mayEditAccount);
                if (immoToolProject != null && immoToolProject.isRemoteProject()) {
                    this.add(new Node(dbMailAccount, new MailAccountPermissionTab(mailAccountDialog2), immoToolProject, this.mayEditAccount, this.mayRemoveAccount));
                }
            }
        }

        private Node(DbMailAccount dbMailAccount, MailAccountDialogForm mailAccountDialogForm, ImmoToolProject immoToolProject, boolean bl, boolean bl2) {
            this.account = dbMailAccount;
            this.accountChildNode = true;
            this.mayEditAccount = bl;
            this.mayRemoveAccount = bl2;
            this.form = mailAccountDialogForm;
            this.form.load(dbMailAccount);
            this.form.loadInBackground(immoToolProject);
            this.form.setEnabled(bl);
        }

        public DbMailAccount getAccount() {
            return this.account;
        }

        public MailAccountDialogForm getChildForm(Class clazz) {
            Node node = this.getChildNode(clazz);
            return node != null ? node.getForm() : null;
        }

        public Node getChildNode(Class clazz) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode treeNode = this.getChildAt(i);
                if (!Node.class.isInstance(treeNode) || !clazz.isInstance((Object)((Node)treeNode).getForm())) continue;
                return (Node)treeNode;
            }
            return null;
        }

        public MailAccountDialogForm getForm() {
            return this.form;
        }

        public Icon getNodeIcon() {
            if (this.account == null) {
                return null;
            }
            if (!this.accountChildNode) {
                return this.account.isLocal() ? MailAccountDialog.this.localSharedAccountIconSmall : MailAccountDialog.this.remoteAccountIconSmall;
            }
            return null;
        }

        public String getNodeText() {
            if (this.account == null) {
                return "";
            }
            if (!this.accountChildNode) {
                return this.account.name;
            }
            return this.form != null ? this.form.getTitle() : "???";
        }

        public boolean isAccountChildNode() {
            return this.accountChildNode;
        }
    }

    private class TreeMinimizeAction
    extends AbstractI18nAction {
        public TreeMinimizeAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doTreeMinimize();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("minimize")));
        }
    }

    private class TreeMaximizeAction
    extends AbstractI18nAction {
        public TreeMaximizeAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doTreeMaximize();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("maximize")));
        }
    }

    public static final class SubmitTask
    extends ImmoToolTask<Long[], Void> {
        private final DbMailAccount[] modifiedAccounts;
        private final Long[] removedAccountIds;
        private final DbMailExtension dbMailExtension;

        public SubmitTask(DbMailAccount[] dbMailAccountArray, Long[] longArray, DbMailExtension dbMailExtension) {
            this.modifiedAccounts = (DbMailAccount[])ArrayUtils.clone((Object[])dbMailAccountArray);
            this.removedAccountIds = (Long[])ArrayUtils.clone((Object[])longArray);
            this.dbMailExtension = dbMailExtension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Long[] doInBackground() throws Exception {
            Comparable<DbMailAccount>[] comparableArray;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailAccountHandler dbMailAccountHandler = this.dbMailExtension.getAccountHandler();
            DbMailMessageHandler dbMailMessageHandler = this.dbMailExtension.getMessageHandler();
            Connection connection = null;
            try {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                connection = immoToolProject.getDbConnection();
                if (!ArrayUtils.isEmpty((Object[])this.modifiedAccounts)) {
                    for (Comparable<DbMailAccount> comparable : this.modifiedAccounts) {
                        this.setMessage("Save mail account '" + ((DbMailAccount)comparable).name + "'");
                        boolean bl = ((DbMailAccount)comparable).id < 1L;
                        dbMailAccountHandler.saveAccount(connection, (DbMailAccount)comparable);
                        arrayList.add(((DbMailAccount)comparable).id);
                        if (!bl || !((DbMailAccount)comparable).isLocalShared()) continue;
                        DbMailFolder dbMailFolder = ((DbMailAccount)comparable).createRootFolder();
                        dbMailMessageHandler.saveFolder(connection, dbMailFolder);
                        DbMailFolder dbMailFolder2 = dbMailFolder.createSubFolder("SHARE");
                        dbMailMessageHandler.saveFolder(connection, dbMailFolder2);
                    }
                }
                if (!ArrayUtils.isEmpty((Object[])this.removedAccountIds)) {
                    for (Comparable<DbMailAccount> comparable : this.removedAccountIds) {
                        this.setMessage("Remove mail account #" + comparable);
                    }
                    dbMailAccountHandler.removeAccounts(connection, ArrayUtils.toPrimitive((Long[])this.removedAccountIds));
                    arrayList.addAll(Arrays.asList(this.removedAccountIds));
                }
                comparableArray = arrayList.toArray(new Long[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return comparableArray;
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        public SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        public CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }

    private class AccountMenuAction
    extends AbstractI18nAction {
        public AccountMenuAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_generic.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            MailAccountDialog.this.doAccountMenu(jButton, 0, jButton.getSize().height);
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
        }
    }

    private class AccountRemoveAction
    extends AbstractI18nAction {
        public AccountRemoveAction(boolean bl) {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(bl);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doAccountRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove mail account")));
        }
    }

    private class AccountAddRemoteAction
    extends AbstractI18nAction {
        public AccountAddRemoteAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("account_remote.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doAccountAddRemote();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new mail account")));
        }
    }

    private class AccountAddLocalSharedAction
    extends AbstractI18nAction {
        public AccountAddLocalSharedAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("account_local_shared.png", 16));
            this.setEnabled(MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailAccountDialog.this.doAccountAddLocalShared();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new shared account")));
        }
    }
}

