/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountSenderTab
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountSenderTab.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountSenderTab.class);
    private ValidationHandler validationHandler;
    private JXTitledSeparator formTitle;
    private JLabel nameLabel;
    private JTextField nameField;
    private JCheckBox enabledField;
    private JXTitledSeparator senderTitle;
    private JLabel fromNameLabel;
    private JTextField fromNameField;
    private JLabel fromMailLabel;
    private JTextField fromMailField;
    private JLabel replyToLabel;
    private JTextField replyToField;
    private JXTitledSeparator signatureTitle;
    private DefaultTextArea signatureField;

    public MailAccountSenderTab(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.senderTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.signatureTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.enabledField = new JCheckBox();
        this.fromNameLabel = new JLabel();
        this.fromNameField = new JTextField();
        this.fromNameField.setName("fromNameField");
        this.fromMailLabel = new JLabel();
        this.fromMailField = new JTextField();
        this.fromMailField.setName("fromMailField");
        this.replyToLabel = new JLabel();
        this.replyToField = new JTextField();
        this.replyToField.setName("replyToField");
        this.signatureField = new DefaultTextArea();
        this.signatureField.setName("signatureField");
        this.validationHandler.putRule((JComponent)this.nameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.fromNameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.fromMailField, ValidationHandler.EMAIL);
        this.validationHandler.putRule((JComponent)this.replyToField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && object.toString().trim().length() > 0 ? ValidationHandler.EMAIL.isValid(object) : true;
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.nameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.nameField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.enabledField).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.senderTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.fromNameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.fromNameField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.fromMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.fromMailField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.replyToLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.replyToField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.signatureTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.signatureField.createScrollPane(), "Center");
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    public String getFromMail() {
        return this.fromMailField.getText().trim();
    }

    public String getFromName() {
        return this.fromNameField.getText().trim();
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("sender"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.nameField.setText(dbMailAccount != null ? dbMailAccount.name : "");
        this.enabledField.setSelected(dbMailAccount != null ? dbMailAccount.enabled : true);
        this.fromNameField.setText(dbMailAccount != null ? dbMailAccount.getSenderFromName() : "");
        this.fromMailField.setText(dbMailAccount != null ? dbMailAccount.getSenderFromMail() : "");
        this.replyToField.setText(dbMailAccount != null ? dbMailAccount.getSenderReplyTo() : "");
        this.signatureField.setText(dbMailAccount != null ? dbMailAccount.getSenderSignatureText() : "");
        this.signatureField.setCaretPosition(0);
        this.validationHandler.init();
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.name = this.nameField.getText().trim();
        dbMailAccount.enabled = this.enabledField.isSelected();
        dbMailAccount.setSenderFromMail(this.fromMailField.getText().trim());
        dbMailAccount.setSenderFromName(this.fromNameField.getText().trim());
        dbMailAccount.setSenderReplyTo(this.replyToField.getText().trim());
        dbMailAccount.setSenderSignatureText(this.signatureField.getText().trim());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.nameField.setEnabled(bl);
        this.enabledField.setEnabled(bl);
        this.fromNameField.setEnabled(bl);
        this.fromMailField.setEnabled(bl);
        this.replyToField.setEnabled(bl);
        this.signatureField.setEnabled(bl);
        this.validationHandler.init();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("mail account")));
        this.nameLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.nameField.setToolTipText(I18N.tr("Enter a name for the mail account, that you can easily remember afterwards."));
        this.enabledField.setText(I18N.tr("Enable mail account."));
        this.enabledField.setToolTipText(I18N.tr("Disabled mail accounts are not used within the application."));
        this.senderTitle.setTitle(StringUtils.capitalize((String)I18N.tr("identity")));
        this.fromNameLabel.setText(StringUtils.capitalize((String)I18N.tr("your name")) + ":");
        this.fromNameField.setToolTipText(I18N.tr("This name is used as sender name for outgoing messages."));
        this.fromMailLabel.setText(StringUtils.capitalize((String)I18N.tr("e-mail")) + ":");
        this.fromMailField.setToolTipText(I18N.tr("This e-mail is used as sender address for outgoing messages."));
        this.replyToLabel.setText(StringUtils.capitalize((String)I18N.tr("reply to")) + ":");
        this.replyToField.setToolTipText(I18N.tr("This e-mail is used as reply-to address for outgoing messages."));
        this.signatureTitle.setTitle(StringUtils.capitalize((String)I18N.tr("signature for outgoing mails")));
        this.signatureField.setToolTipText(I18N.tr("The signature is appended to outgoing messages."));
    }
}

