/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.ModifiedHTMLEditorKit;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import net.atlanticbb.tantlinger.shef.HTMLEditorPane;
import net.atlanticbb.tantlinger.ui.text.AbstractEditor;
import net.atlanticbb.tantlinger.ui.text.AbstractSourceEditor;
import net.atlanticbb.tantlinger.ui.text.AbstractWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.DefaultWysiwygEditor;
import net.atlanticbb.tantlinger.ui.text.RSyntaxSourceEditor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.bushe.swing.action.ActionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailEditorPane
extends HTMLEditorPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailEditorPane.class);
    private static final I18n I18N = I18nFactory.getI18n(MailEditorPane.class);
    public static final String HR_QUOTING_BEGIN = "<hr class=\"quote_begin\">";
    public static final String HR_QUOTING_END = "<hr class=\"quote_end\">";
    private PlainTextEditor plainTextEditor;
    private Mode currentMode;

    public MailEditorPane() {
        this(Mode.HTML_ONLY);
    }

    public MailEditorPane(Mode mode) {
        this.build(mode);
    }

    private void build(Mode mode) {
        this.setMode(mode);
        this.updateMode();
    }

    protected AbstractSourceEditor createSourceEditor() {
        return new SourceEditor();
    }

    protected AbstractWysiwygEditor createWysiwygEditor() {
        return new WysiwygEditor();
    }

    public String getHtmlText() {
        return this.isSourceEditorSelected() ? this.getSourceText() : this.getWysiwygText();
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public String getPlainText() {
        return this.plainTextEditor.getText();
    }

    protected void initEditorTabs(AbstractWysiwygEditor abstractWysiwygEditor, AbstractSourceEditor abstractSourceEditor) {
        this.plainTextEditor = new PlainTextEditor();
        this.addEditor(this.plainTextEditor);
        super.initEditorTabs(abstractWysiwygEditor, abstractSourceEditor);
    }

    public void insertText(String string) {
        this.insertText(string, -1);
    }

    public void insertText(String string, int n) {
        AbstractEditor abstractEditor = this.getSelectedEditor();
        if (abstractEditor == null) {
            return;
        }
        if (n < 0) {
            abstractEditor.insertText(string);
        } else {
            abstractEditor.insertText(string, n);
        }
    }

    public boolean isHtmlOnlyMode() {
        return Mode.HTML_ONLY.equals((Object)this.getMode());
    }

    public boolean isTextOnlyMode() {
        return Mode.TEXT_ONLY.equals((Object)this.getMode());
    }

    public void setHtmlText(String string) {
        this.setWysiwygText(string);
        this.setSourceText(string);
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        this.updateMode();
    }

    public void setPlainText(String string) {
        this.plainTextEditor.setText(string);
        this.plainTextEditor.setCaretPosition(0);
    }

    public void setSignature(String string) {
        String string2 = "-- " + System.lineSeparator();
        String string3 = this.getPlainText();
        String string4 = this.getHtmlText();
        string = StringUtils.trimToNull((String)string);
        if (string3.contains(System.lineSeparator() + string2)) {
            string3 = StringUtils.substringBeforeLast((String)string3, (String)(System.lineSeparator() + string2)).trim();
        } else if (string3.startsWith(string2)) {
            string3 = "";
        }
        if (string != null) {
            string3 = string3 + System.lineSeparator();
            string3 = string3 + System.lineSeparator();
            string3 = string3 + string2;
            string3 = string3 + string;
        }
        this.setPlainText(string3);
        if (string4.contains("<p class=\"signature\">")) {
            int n = string4.contains(HR_QUOTING_END) ? string4.lastIndexOf(HR_QUOTING_END) + HR_QUOTING_END.length() : 0;
            int n2 = string4.indexOf("<p class=\"signature\">", n);
            int n3 = string4.indexOf("</p>", n2) + "</p>".length();
            string4 = string4.substring(0, n2) + string4.substring(n3);
        }
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder().append(System.lineSeparator()).append("<p class=\"signature\">").append(System.lineSeparator()).append("<span style=\"color:#505050;\">").append(StringEscapeUtils.escapeXml11((String)string2)).append("<br>");
            for (String string5 : StringUtils.split((String)string, (String)System.lineSeparator())) {
                stringBuilder.append(string5).append("<br>").append(System.lineSeparator());
            }
            stringBuilder.append("</span>").append(System.lineSeparator()).append("</p>");
            int n = string4.toLowerCase().lastIndexOf("</body>");
            string4 = n < 0 ? string4 + stringBuilder.toString() : string4.substring(0, n) + stringBuilder.toString() + string4.substring(n);
        }
        this.setHtmlText(string4);
    }

    private void updateMode() {
        Mode mode = this.getMode();
        if (Mode.HTML_ONLY.equals((Object)mode)) {
            this.setWysiwygEnabled(true);
            this.setSourceEnabled(true);
            this.setEditorEnabled(this.plainTextEditor, false);
        } else if (Mode.TEXT_ONLY.equals((Object)mode)) {
            this.setEditorEnabled(this.plainTextEditor, true);
            this.setWysiwygEnabled(false);
            this.setSourceEnabled(false);
        }
    }

    private static class WysiwygEditor
    extends DefaultWysiwygEditor {
        public WysiwygEditor() {
            super((HTMLEditorKit)new ModifiedHTMLEditorKit());
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("HTML view"));
        }
    }

    private static class SourceEditor
    extends RSyntaxSourceEditor {
        private SourceEditor() {
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("HTML code"));
        }
    }

    private static class PlainTextEditor
    extends AbstractEditor {
        private DefaultTextArea textArea;
        private JScrollPane scroller;

        public PlainTextEditor() {
            this.build();
        }

        private void build() {
            this.textArea = new DefaultTextArea();
            this.scroller = this.textArea.createScrollPane();
        }

        public int getCaretPosition() {
            return this.textArea.getCaretPosition();
        }

        public JComponent getComponent() {
            return this.scroller;
        }

        public Document getDocument() {
            return this.textArea.getDocument();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("text view"));
        }

        public String getText() {
            return this.textArea.getText();
        }

        public void registerEditor(ActionList actionList) {
            actionList.putContextValueForAll((Object)"editor", (Object)this.textArea);
        }

        public void requestFocusInWindow() {
            this.textArea.requestFocusInWindow();
        }

        public void setCaretPosition(int n) {
            this.textArea.setCaretPosition(n);
        }

        public void setDocument(Document document) {
            this.textArea.setDocument(document);
        }

        public void setText(String string) {
            this.textArea.setText(string);
        }
    }

    public static enum Mode implements Translatable
    {
        HTML_ONLY(I18n.marktr((String)"only HTML")),
        TEXT_ONLY(I18n.marktr((String)"only text"));

        private final String i18nKey;

        private Mode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(Mode.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(Mode.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

