/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.mail.db.DbMailHeader;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.mail.extensions.MailAccountSetupExtension;
import com.openindex.openestate.tool.mail.extensions.MailEditorExtension;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import com.openindex.openestate.tool.mail.extensions.MailTableExtension;
import com.openindex.openestate.tool.mail.extensions.MailViewerExtension;
import com.openindex.openestate.tool.mail.utils.ExtendedMimeMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(MailPluginUtils.class);

    private MailPluginUtils() {
    }

    public static String calculateMessageHash(DbMailPart dbMailPart) {
        if (dbMailPart == null || dbMailPart.headers == null) {
            return null;
        }
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        for (DbMailHeader dbMailHeader : dbMailPart.headers) {
            Set set;
            String string = ((String)StringUtils.defaultIfBlank((CharSequence)dbMailHeader.key, (CharSequence)"")).trim().toLowerCase();
            String string2 = ((String)StringUtils.defaultIfBlank((CharSequence)dbMailHeader.value, (CharSequence)"")).trim();
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new TreeSet());
            }
            if ((set = (Set)treeMap.get(string)).contains(string2)) continue;
            set.add(string2);
        }
        return MailPluginUtils.calculateMessageHash(treeMap);
    }

    public static String calculateMessageHash(Message message) throws MessagingException {
        if (message == null) {
            return null;
        }
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        Enumeration enumeration = message.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Set set;
            Header header = (Header)enumeration.nextElement();
            String string = ((String)StringUtils.defaultIfBlank((CharSequence)header.getName(), (CharSequence)"")).trim().toLowerCase();
            String string2 = ((String)StringUtils.defaultIfBlank((CharSequence)header.getValue(), (CharSequence)"")).trim();
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new TreeSet());
            }
            if ((set = (Set)treeMap.get(string)).contains(string2)) continue;
            set.add(string2);
        }
        return MailPluginUtils.calculateMessageHash(treeMap);
    }

    private static String calculateMessageHash(Map<String, Set<String>> map) {
        String[] stringArray = new String[]{"message-id", "received", "from", "to", "subject", "date"};
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (!map.containsKey(string)) continue;
            stringBuilder.append(string);
            for (String string2 : map.get(string)) {
                stringBuilder.append(",").append(string2);
            }
            stringBuilder.append(";");
        }
        return DigestUtils.sha256Hex((String)stringBuilder.toString());
    }

    public static long calculateMessageSize(MimeMessage mimeMessage) throws MessagingException {
        long l = mimeMessage.getSize();
        if (l != -1L) {
            Enumeration enumeration = mimeMessage.getAllHeaderLines();
            if (enumeration.hasMoreElements()) {
                l += 2L;
            }
            while (enumeration.hasMoreElements()) {
                l += (long)(((String)enumeration.nextElement()).length() + 2);
            }
        } else {
            SizeCalculatorOutputStream sizeCalculatorOutputStream = new SizeCalculatorOutputStream();
            try {
                mimeMessage.writeTo((OutputStream)sizeCalculatorOutputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("Can't calculate message size!", (Exception)iOException);
            }
            l = sizeCalculatorOutputStream.getSize();
        }
        return l;
    }

    public static void closeQuietly(Folder folder) {
        MailPluginUtils.closeQuietly(folder, false);
    }

    public static void closeQuietly(Folder folder, boolean bl) {
        if (folder == null) {
            return;
        }
        if (!folder.isOpen()) {
            return;
        }
        try {
            folder.close(bl);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't close mail-folder!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static void closeQuietly(Store store) {
        if (store == null) {
            return;
        }
        if (!store.isConnected()) {
            return;
        }
        try {
            store.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't close mail-store!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static void closeQuietly(Transport transport) {
        if (transport == null) {
            return;
        }
        if (!transport.isConnected()) {
            return;
        }
        try {
            transport.close();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't close mail-transport!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static MimeMessage createMimeMessage(DbMailMessage dbMailMessage, DbMailPart dbMailPart, Session session, boolean bl, Map<Long, File> map) throws MessagingException {
        Object object = !bl ? new MimeMessage(session) : (dbMailMessage == null ? new MimeMessage(session) : new ExtendedMimeMessage(session, dbMailMessage.mimeId));
        for (DbMailHeader dbMailHeader : dbMailPart.headers) {
            if ("Message-ID".equalsIgnoreCase(dbMailHeader.key)) continue;
            object.addHeader(dbMailHeader.key, dbMailHeader.value);
        }
        ContentType contentType = new ContentType(dbMailPart.type);
        if (contentType.match("multipart/*")) {
            object.setContent((Multipart)MailPluginUtils.createMimeMessageMultipart(dbMailPart, contentType, map));
        } else if (contentType.match("text/*") && dbMailPart.text != null) {
            object.setText(dbMailPart.text, "UTF-8", contentType.getSubType());
        } else if (dbMailPart.fileName != null && map.containsKey(dbMailPart.id)) {
            DbMailHeader dbMailHeader;
            dbMailHeader = new FileDataSource(map.get(dbMailPart.id));
            object.setDataHandler(new DataHandler((DataSource)dbMailHeader));
            object.setFileName(dbMailPart.fileName);
        }
        return object;
    }

    private static MimeBodyPart createMimeMessageBodyPart(DbMailPart dbMailPart, ContentType contentType, Map<Long, File> map) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        if (contentType.match("text/*") && dbMailPart.text != null) {
            mimeBodyPart.setText(dbMailPart.text, "UTF-8", contentType.getSubType());
        } else if (dbMailPart.fileName != null && map.containsKey(dbMailPart.id)) {
            FileDataSource fileDataSource = new FileDataSource(map.get(dbMailPart.id));
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
            mimeBodyPart.setFileName(dbMailPart.fileName);
        }
        return mimeBodyPart;
    }

    private static MimeMultipart createMimeMessageMultipart(DbMailPart dbMailPart, ContentType contentType, Map<Long, File> map) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        if (dbMailPart.subParts == null || dbMailPart.subParts.isEmpty()) {
            return mimeMultipart;
        }
        mimeMultipart.setSubType(contentType.getSubType());
        for (DbMailPart dbMailPart2 : dbMailPart.subParts) {
            MimeBodyPart mimeBodyPart;
            ContentType contentType2;
            try {
                contentType2 = new ContentType(dbMailPart2.type);
            }
            catch (MessagingException messagingException) {
                LOGGER.warn("Can't parse content-type from part #" + dbMailPart2.id);
                LOGGER.warn("> " + dbMailPart2.type);
                continue;
            }
            if (contentType2.match("multipart/*")) {
                mimeBodyPart = new MimeBodyPart();
                for (DbMailHeader dbMailHeader : dbMailPart2.headers) {
                    mimeBodyPart.addHeader(dbMailHeader.key, dbMailHeader.value);
                }
                mimeBodyPart.setContent((Multipart)MailPluginUtils.createMimeMessageMultipart(dbMailPart2, contentType2, map));
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            mimeBodyPart = MailPluginUtils.createMimeMessageBodyPart(dbMailPart2, contentType2, map);
            if (mimeBodyPart == null) continue;
            for (DbMailHeader dbMailHeader : dbMailPart2.headers) {
                mimeBodyPart.addHeader(dbMailHeader.key, dbMailHeader.value);
            }
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        return mimeMultipart;
    }

    public static void createRemoteFolder(Folder folder) throws MessagingException {
        try {
            folder.create(3);
        }
        catch (Exception exception) {
            try {
                folder.create(1);
            }
            catch (Exception exception2) {
                try {
                    folder.create(2);
                }
                catch (Exception exception3) {
                    throw new MessagingException("Destination folder '" + folder.getFullName() + "' does not allow messages & folders!", exception3);
                }
            }
        }
        if (!folder.exists()) {
            throw new MessagingException("Can't create folder '" + folder.getFullName() + "'!");
        }
    }

    public static Map<Long, File> downloadAttachments(Connection connection, DbMailMessageHandler dbMailMessageHandler, DbMailPart dbMailPart, boolean bl) {
        HashMap<Long, File> hashMap = new HashMap<Long, File>();
        if (dbMailPart.tempFileContent != null && dbMailPart.tempFileContent.isFile()) {
            hashMap.put(dbMailPart.id, dbMailPart.tempFileContent);
        } else if (dbMailPart.fileName != null) {
            Object object = null;
            try {
                object = File.createTempFile("mail.", ".bin");
                ((File)object).deleteOnExit();
                try (FileOutputStream object2 = new FileOutputStream((File)object);){
                    boolean bl2 = dbMailMessageHandler.downloadPart(connection, dbMailPart.id, object2);
                    if (!bl2) {
                        LOGGER.debug("Message part #" + dbMailPart.id + " was not downloaded!");
                        FileUtils.deleteQuietly((File)object);
                    } else {
                        object2.flush();
                        hashMap.put(dbMailPart.id, (File)object);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't download attachment of part #" + dbMailPart.id);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                FileUtils.deleteQuietly((File)object);
            }
        }
        if (bl && dbMailPart.subParts != null) {
            for (DbMailPart dbMailPart2 : dbMailPart.subParts) {
                hashMap.putAll(MailPluginUtils.downloadAttachments(connection, dbMailMessageHandler, dbMailPart2, bl));
            }
        }
        return hashMap;
    }

    public static DbMailExtension getDbMailExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? MailPluginUtils.getDbMailExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbMailExtension getDbMailExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? MailPluginUtils.getDbMailExtension(abstractDbDriver.getName()) : null;
    }

    public static DbMailExtension getDbMailExtension(String string) {
        for (Object object : MailPluginUtils.getExtensionHandlers("DbMailExtension", DbMailExtension.class, null, null)) {
            DbMailExtension dbMailExtension = (DbMailExtension)object;
            if (!dbMailExtension.isSupportedDriver(string)) continue;
            return dbMailExtension;
        }
        return null;
    }

    public static Collection<DbMailExtension> getDbMailExtensions() {
        ArrayList<DbMailExtension> arrayList = new ArrayList<DbMailExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("DbMailExtension", DbMailExtension.class, null, null)) {
            arrayList.add((DbMailExtension)object);
        }
        return arrayList;
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-Mail", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    public static Collection<MailAccountSetupExtension> getMailAccountSetupExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MailAccountSetupExtension> arrayList = new ArrayList<MailAccountSetupExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("MailAccountSetupExtension", MailAccountSetupExtension.class, immoToolProject, null)) {
            arrayList.add((MailAccountSetupExtension)object);
        }
        return arrayList;
    }

    public static Collection<MailEditorExtension> getMailEditorExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MailEditorExtension> arrayList = new ArrayList<MailEditorExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("MailEditorExtension", MailEditorExtension.class, immoToolProject, null)) {
            arrayList.add((MailEditorExtension)object);
        }
        return arrayList;
    }

    public static Collection<MailHandlerExtension> getMailHandlerExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MailHandlerExtension> arrayList = new ArrayList<MailHandlerExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("MailHandlerExtension", MailHandlerExtension.class, immoToolProject, null)) {
            arrayList.add((MailHandlerExtension)object);
        }
        return arrayList;
    }

    public static Collection<MailTableExtension> getMailTableExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MailTableExtension> arrayList = new ArrayList<MailTableExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("MailTableExtension", MailTableExtension.class, immoToolProject, null)) {
            arrayList.add((MailTableExtension)object);
        }
        return arrayList;
    }

    public static Collection<MailViewerExtension> getMailViewerExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<MailViewerExtension> arrayList = new ArrayList<MailViewerExtension>();
        for (Object object : MailPluginUtils.getExtensionHandlers("MailViewerExtension", MailViewerExtension.class, immoToolProject, null)) {
            arrayList.add((MailViewerExtension)object);
        }
        return arrayList;
    }

    public static Folder getRemoteSubFolder(Folder folder, String[] stringArray) throws MessagingException {
        return folder.getFolder(StringUtils.join((Object[])stringArray, (char)folder.getSeparator()));
    }

    public static String getUniqueMessageId() throws MessagingException {
        return MailPluginUtils.getUniqueMessageId(null);
    }

    public static String getUniqueMessageId(Session session) throws MessagingException {
        return new MimeMessage(session){

            public String generateMessageID() throws MessagingException {
                this.updateMessageID();
                return this.getHeader("Message-ID")[0];
            }
        }.generateMessageID();
    }

    public static Message searchFolder(Folder folder, DbMailMessage dbMailMessage) throws MessagingException {
        return dbMailMessage != null ? MailPluginUtils.searchFolder(folder, dbMailMessage.uid, dbMailMessage.uidValidity, dbMailMessage.mimeId) : null;
    }

    public static Message searchFolder(Folder folder, Long l, Long l2, String string) throws MessagingException {
        if (l != null && l2 != null && folder instanceof UIDFolder) {
            UIDFolder uIDFolder = (UIDFolder)folder;
            if (l2.longValue() != uIDFolder.getUIDValidity()) {
                return null;
            }
            return uIDFolder.getMessageByUID(l.longValue());
        }
        Message[] messageArray = folder.search((SearchTerm)new MessageIDTerm(string));
        return messageArray != null && messageArray.length > 0 ? messageArray[0] : null;
    }

    public static boolean writeMessage(Message message, OutputStream outputStream) {
        try {
            message.writeTo(outputStream);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write mime message!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }

    public static void writeMessageForDebug(Message message) {
        System.out.println("-------------------------------- BEGIN MIME MESSAGE --------------------------------");
        MailPluginUtils.writeMessage(message, System.out);
        System.out.println("--------------------------------- END MIME MESSAGE ---------------------------------");
    }

    private static final class SizeCalculatorOutputStream
    extends OutputStream {
        long size = 0L;

        private SizeCalculatorOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            ++this.size;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.size += (long)n2;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.size += (long)byArray.length;
        }
    }
}

