/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.ImageViewer;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.MailWritePanel;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailAddress;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import com.openindex.openestate.tool.mail.extensions.MailHandlerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import com.openindex.openestate.tool.mail.extensions.MailViewerExtension;
import com.openindex.openestate.tool.mail.utils.MailExportTask;
import com.openindex.openestate.tool.mail.utils.MailFolderDialog;
import com.openindex.openestate.tool.utils.XHTMLViewer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailViewer
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailViewer.class);
    private static final I18n I18N = I18nFactory.getI18n(MailViewer.class);
    private static final String MESSAGE_PANEL = "message";
    private static final String BUSY_PANEL = "busy";
    private static transient File lastAttachmentLocation = null;
    private transient DbMailMessage currentMessage = null;
    private transient long currentAccountId = 0L;
    private transient long currentFolderId = 0L;
    private transient long currentPartId = 0L;
    private final transient MailHandlerExtension mailListener;
    private transient List<MailViewerExtension> extensions;
    private JButton actionButton;
    private JXBusyLabel mainBusyLabel;
    private JTextPane mainViewHeaderField;
    private PartList mainViewPartsList;
    private Map<Long, JComponent> mainViewPartComponents;
    private JPanel mainViewInfoPanel;
    private JPanel mainViewContentPanel;

    public MailViewer() {
        this.build();
        this.mailListener = new MailListener();
        MailPlugin.getMailHandler().addCustomListener(this.mailListener);
    }

    private void build() {
        this.mainViewPartComponents = new HashMap<Long, JComponent>();
        this.extensions = new ArrayList<MailViewerExtension>();
        this.buildButtons();
        this.setLayout(new CardLayout());
        this.add(this.buildMainViewPanel(), MESSAGE_PANEL);
        this.add(this.buildMainBusyPanel(), BUSY_PANEL);
        this.showMainPanel(MESSAGE_PANEL);
    }

    private void buildButtons() {
        this.actionButton = new JButton((Action)((Object)new MessageShowActionsAction()));
    }

    private JPanel buildMainBusyPanel() {
        this.mainBusyLabel = new JXBusyLabel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.mainBusyLabel, "North");
        return jPanel;
    }

    private JPanel buildMainViewPanel() {
        this.mainViewHeaderField = new JTextPane();
        this.mainViewHeaderField.setEditable(false);
        this.mainViewHeaderField.setContentType("text/html");
        this.mainViewHeaderField.setText("<html></html>");
        JScrollPane jScrollPane = new JScrollPane(this.mainViewHeaderField);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 95));
        this.mainViewInfoPanel = new JPanel(new BorderLayout(5, 5));
        this.mainViewInfoPanel.setBackground(new Color(255, 254, 225));
        this.mainViewInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mainViewInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), this.mainViewInfoPanel.getBorder()));
        this.mainViewInfoPanel.setVisible(false);
        this.mainViewPartsList = new PartList();
        this.mainViewPartsList.setSelectionMode(2);
        this.mainViewPartsList.setFixedCellWidth(125);
        this.mainViewPartsList.setCellRenderer(new PartItemRenderer());
        this.mainViewPartsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(mouseEvent)) && mouseEvent.getClickCount() == 1 && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n = MailViewer.this.mainViewPartsList.locationToIndex(mouseEvent.getPoint());
                    int[] nArray = MailViewer.this.mainViewPartsList.getSelectedIndices();
                    if (!ArrayUtils.contains((int[])nArray, (int)n)) {
                        MailViewer.this.mainViewPartsList.setSelectionInterval(n, n);
                    }
                    MailViewer.this.doPartShowActions(MailViewer.this.mainViewPartsList, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.mainViewPartsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() == 525) {
                    if (MailViewer.this.mainViewPartsList.getSelectedIndex() < 0) {
                        return;
                    }
                    Point point = MailViewer.this.mainViewPartsList.indexToLocation(MailViewer.this.mainViewPartsList.getSelectedIndex());
                    MailViewer.this.doPartShowActions(MailViewer.this.mainViewPartsList, point.x, point.y);
                }
            }
        });
        this.mainViewPartsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!MailViewer.this.mainViewPartsList.isEnabled()) {
                    return;
                }
                MailViewer.this.showMessagePart((PartItem)MailViewer.this.mainViewPartsList.getSelectedValue());
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.mainViewPartsList);
        this.mainViewContentPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jScrollPane, "North");
        jPanel.add((Component)this.mainViewInfoPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)jScrollPane2, "East");
        jPanel2.add((Component)this.mainViewContentPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private JComponent createViewer(DbMailPart dbMailPart, ContentType contentType) throws IOException {
        block27: {
            Object object;
            File file;
            block28: {
                ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
                DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
                if (contentType.match("text/html")) {
                    String string = MailViewer.generateMessage(dbMailPart, contentType);
                    if (StringUtils.isBlank((CharSequence)string)) {
                        string = "<html></html>";
                    }
                    XHTMLViewer xHTMLViewer = new XHTMLViewer();
                    xHTMLViewer.registerDefaultListeners();
                    xHTMLViewer.setDocument(XHTMLViewer.parseDocument((String)string));
                    return xHTMLViewer;
                }
                if (contentType.match("text/plain")) {
                    RSyntaxTextArea rSyntaxTextArea = new RSyntaxTextArea();
                    rSyntaxTextArea.setLineWrap(true);
                    rSyntaxTextArea.setWrapStyleWord(true);
                    rSyntaxTextArea.setEditable(false);
                    rSyntaxTextArea.setSyntaxEditingStyle("text/plain");
                    rSyntaxTextArea.setHyperlinksEnabled(true);
                    rSyntaxTextArea.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                            if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
                                ImmoToolUtils.openURL((URL)hyperlinkEvent.getURL());
                            }
                        }
                    });
                    rSyntaxTextArea.setText(MailViewer.generateMessage(dbMailPart, contentType));
                    rSyntaxTextArea.setCaretPosition(0);
                    JScrollPane jScrollPane = new JScrollPane((Component)rSyntaxTextArea);
                    return jScrollPane;
                }
                if (!contentType.match("image/*")) break block27;
                file = new File(immoToolProject.getTempDirectory().getAbsolutePath() + File.separator + "mail" + File.separator + "part" + dbMailPart.id + ".bin");
                if (!file.isFile()) {
                    if (!file.getParentFile().mkdirs()) {
                        LOGGER.warn("Can't create directory '" + file.getParentFile().getAbsolutePath() + "'!");
                    } else {
                        object = null;
                        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                            object = immoToolProject.getDbConnection();
                            dbMailMessageHandler.downloadPart((Connection)object, dbMailPart.id, bufferedOutputStream);
                            ((OutputStream)bufferedOutputStream).flush();
                        }
                        JdbcUtils.closeQuietly((Connection)object);
                    }
                    break block28;
                    catch (Exception exception) {
                        block26: {
                            try {
                                LOGGER.warn("Can't download attached image!");
                                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                                if (file.exists()) break block26;
                                FileUtils.touch((File)file);
                            }
                            catch (Throwable throwable) {
                                JdbcUtils.closeQuietly(object);
                                throw throwable;
                            }
                        }
                        JdbcUtils.closeQuietly((Connection)object);
                    }
                }
            }
            if (!file.isFile() || file.length() < 1L) {
                return null;
            }
            try {
                object = new ImageViewer();
                object.setImage(file);
                return object;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load image viewer!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        LOGGER.warn("Can't find a usable viewer component for '" + contentType + "'!");
        return null;
    }

    private void doAttachmentSave(boolean bl) {
        int n;
        ArrayList arrayList = new ArrayList();
        if (bl) {
            for (n = 0; n < this.mainViewPartsList.getModel().getSize(); ++n) {
                arrayList.add(this.mainViewPartsList.getModel().getElementAt(n));
            }
        } else {
            for (int n2 : this.mainViewPartsList.getSelectedIndices()) {
                arrayList.add(this.mainViewPartsList.getModel().getElementAt(n2));
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        n = arrayList.size() > 1 ? 1 : 0;
        JFileChooser jFileChooser = new JFileChooser();
        if (n != 0) {
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setSelectedFile(lastAttachmentLocation != null ? lastAttachmentLocation : new File(""));
        } else {
            PartItem partItem = (PartItem)arrayList.get(0);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setSelectedFile(lastAttachmentLocation != null ? new File(lastAttachmentLocation.getAbsolutePath() + File.separator + partItem.getFileName()) : new File(partItem.getFileName()));
        }
        int n3 = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame());
        if (n3 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        MailViewer.setLastAttachmentLocation(n != 0 ? file : file.getParentFile());
        ImmoToolUtils.executeTask((ImmoToolTask)new AttachmentSaveTask(arrayList.toArray(new PartItem[0]), file));
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        Object object;
        this.showMainPanel(BUSY_PANEL);
        this.mainBusyLabel.setBusy(true);
        if (this.currentMessage.isDownloaded) {
            this.mainBusyLabel.setText(I18N.tr("Loading message from database."));
        } else {
            this.mainBusyLabel.setText(I18N.tr("Downloading message from mail server."));
        }
        this.mainViewContentPanel.setEnabled(false);
        DbMailPart dbMailPart = null;
        try {
            object = ImmoToolProject.getAppInstance();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            DbMailFolder dbMailFolder = this.getCurrentFolder();
            if (this.currentMessage.addresses == null) {
                dbMailMessageHandler.loadAddresses(connection, this.currentMessage);
            }
            if (!this.currentMessage.isDownloaded) {
                MailPlugin.getMailHandler().loadRemoteMessage((ImmoToolProject)object, connection, this.currentMessage, dbMailFolder);
            }
            if ((dbMailPart = dbMailMessageHandler.getPartOnRoot(connection, this.currentMessage.id)) == null) {
                throw new Exception("Can't find parts for message #" + this.currentMessage.id + "!");
            }
            dbMailMessageHandler.loadPartChildren(connection, dbMailPart, true);
            dbMailMessageHandler.loadPartHeaders(connection, dbMailPart, true);
            if (!this.currentMessage.isSeen) {
                MailPlugin.getMailHandler().markMessageSeen((ImmoToolProject)object, connection, this.currentMessage, dbMailFolder, true);
            }
            for (MailViewerExtension mailViewerExtension : this.extensions) {
                mailViewerExtension.load((ImmoToolProject)object, connection, this.currentMessage, dbMailPart);
            }
            object = dbMailPart;
        }
        catch (Exception exception) {
            try {
                this.mainBusyLabel.setBusy(false);
                this.mainBusyLabel.setText("<html><b>" + I18N.tr("Can't load message!") + "</b><br>" + exception.getLocalizedMessage() + "</<html>");
                throw exception;
            }
            catch (Throwable throwable) {
                DbMailPart dbMailPart2 = dbMailPart;
                SwingUtilities.invokeLater(new Runnable(dbMailPart2){
                    final /* synthetic */ DbMailPart val$loadedMailPart;
                    {
                        this.val$loadedMailPart = dbMailPart;
                    }

                    @Override
                    public void run() {
                        try {
                            if (this.val$loadedMailPart != null) {
                                MailViewer.this.showMessage(this.val$loadedMailPart);
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.error("Can't show message!");
                            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            ImmoToolUtils.showMessageErrorDialog((String)"Can't show message", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                        }
                        finally {
                            MailViewer.this.mainViewContentPanel.setEnabled(true);
                            MailViewer.this.mainBusyLabel.setBusy(false);
                        }
                    }
                });
                throw throwable;
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doMessageArchive(boolean bl) {
        if (this.currentMessage == null || this.currentMessage.isArchived == bl) {
            return;
        }
        ImmoToolUtils.executeTask((ImmoToolTask)new MessageArchiveTask(bl));
    }

    private void doMessageCopy() {
        if (this.currentMessage == null) {
            return;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailFolder dbMailFolder = MailFolderDialog.showDialog(this.currentFolderId, StringUtils.capitalize((String)I18N.tr("copy message")), I18N.tr("In which folder do you want to copy the e-mail?"), mailHandler, (Window)ImmoToolEnvironment.getFrame());
        if (dbMailFolder == null) {
            return;
        }
        if (this.currentFolderId == dbMailFolder.id) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The selected folder already contains the e-mail!"), (Component)((Object)this));
            return;
        }
        mailHandler.copyMessagesInBackground(new long[]{this.currentMessage.id}, dbMailFolder);
    }

    private void doMessageEdit() {
        if (this.currentMessage == null) {
            return;
        }
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.DRAFT, this.currentMessage.id);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMessageExport() {
        if (this.currentMessage == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith(".eml");
            }

            @Override
            public String getDescription() {
                return I18N.tr("e-mails") + " (*.eml)";
            }
        });
        jFileChooser.setSelectedFile(new File("message-" + this.currentMessage.id + ".eml"));
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
        MailExportTask mailExportTask = new MailExportTask(immoToolProject.getDbDriver(), dbMailExtension.getMessageHandler(), this.currentMessage.id, file){

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't export selected mail!", (Throwable)throwable, (Window)this.getParentWindow());
            }
        };
        ImmoToolTaskDialog.showDialog((ImmoToolTask)mailExportTask, (Window)ImmoToolEnvironment.getFrame());
    }

    private void doMessageForward() {
        if (this.currentMessage == null) {
            return;
        }
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.FORWARD, this.currentMessage.id);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMessageMove() {
        if (this.currentMessage == null) {
            return;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailFolder dbMailFolder = MailFolderDialog.showDialog(this.currentFolderId, StringUtils.capitalize((String)I18N.tr("move message")), I18N.tr("In which folder do you want to move the e-mail?"), mailHandler, (Window)ImmoToolEnvironment.getFrame());
        if (dbMailFolder == null) {
            return;
        }
        if (this.currentFolderId == dbMailFolder.id) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The selected folder already contains the e-mail!"), (Component)((Object)this));
            return;
        }
        mailHandler.moveMessagesInBackground(new long[]{this.currentMessage.id}, dbMailFolder);
    }

    private void doMessageRemove() {
        if (this.currentMessage == null || this.currentMessage.id < 1L) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove the current message?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        MailPlugin.getMailHandler().removeMessagesInBackground(new long[]{this.currentMessage.id});
    }

    private void doMessageReply() {
        if (this.currentMessage == null) {
            return;
        }
        MailWritePanel mailWritePanel = MailWritePanel.createTab(MailEditor.ViewMode.REPLY, this.currentMessage.id);
        ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
        mailWritePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    private void doMessageShowActions(Component component, int n, int n2) {
        boolean bl;
        if (this.currentMessage == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.currentMessage.isDraft) {
            jPopupMenu.add((Action)((Object)new MessageEditAction()));
        }
        if (!this.currentMessage.isDraft) {
            jPopupMenu.add((Action)((Object)new MessageReplyAction()));
        }
        if (!this.currentMessage.isDraft) {
            jPopupMenu.add((Action)((Object)new MessageForwardAction()));
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new MessageCopyAction()));
        jPopupMenu.add((Action)((Object)new MessageMoveAction()));
        if (!this.currentMessage.isArchived) {
            jPopupMenu.add((Action)((Object)new MessageArchiveAction(true)));
        }
        if (this.currentMessage.isArchived) {
            MailViewerExtension mailViewerExtension;
            bl = true;
            Object object = this.extensions.iterator();
            while (object.hasNext() && (bl = (mailViewerExtension = object.next()).canUnarchiveMessage())) {
            }
            object = new JMenuItem((Action)((Object)new MessageArchiveAction(false)));
            ((JMenuItem)object).setEnabled(bl);
            jPopupMenu.add((JMenuItem)object);
        }
        bl = false;
        for (MailViewerExtension mailViewerExtension : this.extensions) {
            try {
                Object[] objectArray = mailViewerExtension.createActionMenuItems(this);
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                if (!bl) {
                    jPopupMenu.addSeparator();
                    bl = true;
                }
                for (Object object : objectArray) {
                    jPopupMenu.add((JMenuItem)object);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load message actions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new MessageRemoveAction()));
        jPopupMenu.show(component, n, n2);
    }

    private void doNotificationAccept(long l) {
        if (this.currentMessage == null) {
            return;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        JXBusyLabel jXBusyLabel = new JXBusyLabel();
        jXBusyLabel.setText(I18N.tr("Sending requested return receipt."));
        jXBusyLabel.setBusy(true);
        this.mainViewInfoPanel.removeAll();
        this.mainViewInfoPanel.add((Component)jXBusyLabel, "Center");
        this.mainViewInfoPanel.revalidate();
        this.mainViewInfoPanel.repaint();
        mailHandler.sendNotificationInBackground(this.currentMessage, l);
    }

    private void doNotificationDeny() {
        if (this.currentMessage == null) {
            return;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        JXBusyLabel jXBusyLabel = new JXBusyLabel();
        jXBusyLabel.setText(I18N.tr("Ignoring the requested return receipt."));
        jXBusyLabel.setBusy(true);
        this.mainViewInfoPanel.removeAll();
        this.mainViewInfoPanel.add((Component)jXBusyLabel, "Center");
        this.mainViewInfoPanel.revalidate();
        this.mainViewInfoPanel.repaint();
        mailHandler.setMessageMdnInBackground(this.currentMessage, DbMailMessage.MdnStatus.DENIED);
    }

    private void doNotificationShowAccounts(Component component, int n, int n2) {
        if (this.currentMessage == null) {
            return;
        }
        HashMap<Long, DbMailAccount> hashMap = new HashMap<Long, DbMailAccount>();
        for (long l : MailPlugin.getMailHandler().getRemoteAccountIds()) {
            DbMailAccount dbMailAccount;
            Transport transport = MailPlugin.getMailHandler().getRemoteTransport(l);
            if (transport == null || (dbMailAccount = MailPlugin.getMailHandler().getAccount(l)) == null) continue;
            hashMap.put(l, dbMailAccount);
        }
        if (hashMap.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No mail account for mail transfer was found."), (Component)((Object)this));
            return;
        }
        Object object = new JPopupMenu();
        ImmoToolUtils.createMenuSeparator((String)I18N.tr("Send notification from:"));
        if (this.currentAccountId > 0L && hashMap.containsKey(this.currentAccountId)) {
            DbMailAccount dbMailAccount = (DbMailAccount)hashMap.get(this.currentAccountId);
            ((JPopupMenu)object).add((Action)((Object)new NotificationAcceptAction(dbMailAccount)));
            if (hashMap.size() > 1) {
                ((JPopupMenu)object).addSeparator();
            }
        }
        for (DbMailAccount dbMailAccount : hashMap.values()) {
            if (dbMailAccount.id == this.currentAccountId) continue;
            ((JPopupMenu)object).add((Action)((Object)new NotificationAcceptAction(dbMailAccount)));
        }
        ((JPopupMenu)object).show(component, n, n2);
    }

    private void doPartShowActions(Component component, int n, int n2) {
        PartItem partItem = (PartItem)this.mainViewPartsList.getSelectedValue();
        if (partItem == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new AttachmentSaveAction(false)));
        jPopupMenu.add((Action)((Object)new AttachmentSaveAction(true)));
        boolean bl = false;
        for (MailViewerExtension mailViewerExtension : this.extensions) {
            try {
                Object[] objectArray = mailViewerExtension.createPartMenuItems(partItem, this);
                if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                if (!bl) {
                    jPopupMenu.addSeparator();
                    bl = true;
                }
                for (Object object : objectArray) {
                    jPopupMenu.add((JMenuItem)object);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load attachment actions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    private static String generateHeader(DbMailMessage dbMailMessage) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        String string = "";
        Object[] objectArray = dbMailMessage.getFrom();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            string = string + "<tr valign=\"top\">";
            string = string + "<td width=\"1\" style=\"font-family:sans-serif; font-size:10px; font-weight:bold; text-align:right;\">" + StringUtils.capitalize((String)DbMailAddress.Type.FROM.getTranslation()) + "&nbsp;:</td>";
            string = string + "<td style=\"font-family:sans-serif; font-size:10px;\">" + StringEscapeUtils.escapeXml11((String)DbMailAddress.write((DbMailAddress[])objectArray)) + "</td>";
            string = string + "</tr>";
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = dbMailMessage.getTo()))) {
            string = string + "<tr valign=\"top\">";
            string = string + "<td width=\"1\" style=\"font-family:sans-serif; font-size:10px; font-weight:bold; text-align:right;\">" + StringUtils.capitalize((String)DbMailAddress.Type.TO.getTranslation()) + "&nbsp;:</td>";
            string = string + "<td style=\"font-family:sans-serif; font-size:10px;\">" + StringEscapeUtils.escapeXml11((String)DbMailAddress.write((DbMailAddress[])objectArray)) + "</td>";
            string = string + "</tr>";
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = dbMailMessage.getCc()))) {
            string = string + "<tr valign=\"top\">";
            string = string + "<td width=\"1\" style=\"font-family:sans-serif; font-size:10px; font-weight:bold; text-align:right;\">" + StringUtils.capitalize((String)DbMailAddress.Type.CC.getTranslation()) + "&nbsp;:</td>";
            string = string + "<td style=\"font-family:sans-serif; font-size:10px;\">" + StringEscapeUtils.escapeXml11((String)DbMailAddress.write((DbMailAddress[])objectArray)) + "</td>";
            string = string + "</tr>";
        }
        if (!ArrayUtils.isEmpty((Object[])(objectArray = dbMailMessage.getBcc()))) {
            string = string + "<tr valign=\"top\">";
            string = string + "<td width=\"1\" style=\"font-family:sans-serif; font-size:10px; font-weight:bold; text-align:right;\">" + StringUtils.capitalize((String)DbMailAddress.Type.BCC.getTranslation()) + "&nbsp;:</td>";
            string = string + "<td style=\"font-family:sans-serif; font-size:10px;\">" + StringEscapeUtils.escapeXml11((String)DbMailAddress.write((DbMailAddress[])objectArray)) + "</td>";
            string = string + "</tr>";
        }
        Date date = dbMailMessage.isReceived && dbMailMessage.receivedAt != null ? dbMailMessage.receivedAt : dbMailMessage.sentAt;
        String string2 = date != null ? dateFormat.format(date) : "";
        String string3 = dbMailMessage.subject != null ? StringEscapeUtils.unescapeHtml4((String)dbMailMessage.subject).replace("<", "&lt;").replace(">", "&gt;") : "<i>" + I18N.tr("no subject") + "</i>";
        String string4 = "<table style=\"width:100%;\" border=\"0\"><tr valign=\"top\"><td style=\"font-family:sans-serif; font-size:12px; font-weight:bold;\" colspan=\"2\" >" + string3 + "</td><td width=\"1\" style=\"font-family:sans-serif; font-size:12px; text-align:right; white-space:nowrap;\">" + string2 + "</td></tr></table>";
        if (string.length() > 0) {
            string4 = string4 + "<table style=\"width:100%;\" border=\"0\">" + string + "</table>";
        }
        return "<html style=\"margin:0; padding:0;\">" + string4 + "</html>";
    }

    private static String generateMessage(DbMailPart dbMailPart, ContentType contentType) {
        if (contentType.match("text/html")) {
            String string = dbMailPart.text;
            string = string != null ? StringEscapeUtils.unescapeHtml4((String)string) : "";
            Tidy tidy = ImmoToolUtils.tidy();
            tidy.setWord2000(true);
            tidy.setXHTML(true);
            tidy.setHideComments(true);
            tidy.setHideEndTags(false);
            tidy.setPrintBodyOnly(false);
            tidy.setNumEntities(true);
            tidy.setQuoteAmpersand(true);
            tidy.setForceOutput(true);
            return ImmoToolUtils.tidy((Tidy)tidy, (String)string);
        }
        if (contentType.match("text/plain")) {
            return StringUtils.trimToEmpty((String)dbMailPart.text);
        }
        return null;
    }

    public JButton getActionButton() {
        return this.actionButton;
    }

    public DbMailAccount getCurrentAccount() {
        return this.currentAccountId > 0L ? MailPlugin.getMailHandler().getAccount(this.currentAccountId) : null;
    }

    public long getCurrentAccountId() {
        return this.currentAccountId;
    }

    public DbMailFolder getCurrentFolder() {
        return this.currentFolderId > 0L ? MailPlugin.getMailHandler().getFolder(this.currentFolderId) : null;
    }

    public long getCurrentFolderId() {
        return this.currentFolderId;
    }

    public DbMailMessage getCurrentMessage() {
        return this.currentMessage;
    }

    public long getCurrentMessageLocalId() {
        return this.currentMessage != null ? this.currentMessage.id : 0L;
    }

    public JButton[] getExtensionButtons() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.currentMessage != null) {
            for (MailViewerExtension mailViewerExtension : this.extensions) {
                try {
                    Object[] objectArray = mailViewerExtension.createActionButtons(this);
                    if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
                    arrayList.addAll(Arrays.asList(objectArray));
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load message actions!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return arrayList.toArray(new JButton[0]);
    }

    private Icon getMessagePartIcon(PartItem partItem, int n) {
        for (MailViewerExtension mailViewerExtension : this.extensions) {
            try {
                Icon icon = mailViewerExtension.getPartIcon(partItem, n);
                if (icon == null) continue;
                return icon;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load attachment icon!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return ImmoToolUtils.getFileIcon((ContentType)partItem.getContentType(), (String)partItem.getFileName(), (int)n);
    }

    public void loadInBackground(AbstractDbDriver abstractDbDriver) {
        if (this.getCurrentMessageLocalId() > 0L) {
            this.showMainPanel(BUSY_PANEL);
            this.mainBusyLabel.setBusy(true);
            this.mainBusyLabel.setText("");
            this.mainViewContentPanel.setEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new LoadInBackgroundTask(abstractDbDriver));
        }
    }

    private static synchronized void setLastAttachmentLocation(File file) {
        lastAttachmentLocation = file;
    }

    public void setMessage(DbMailMessage dbMailMessage) {
        if (!this.mainViewContentPanel.isEnabled()) {
            return;
        }
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbMailFolder dbMailFolder = mailHandler.getFolder(dbMailMessage.folderId);
        DbMailAccount dbMailAccount = mailHandler.getAccount(dbMailFolder.accountId);
        this.currentMessage = dbMailMessage;
        this.currentFolderId = dbMailFolder.id;
        this.currentAccountId = dbMailAccount.id;
        this.currentPartId = 0L;
        this.mainViewPartComponents.clear();
        this.extensions.clear();
        try {
            for (MailViewerExtension mailViewerExtension : MailPluginUtils.getMailViewerExtensions()) {
                try {
                    this.extensions.add(mailViewerExtension);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load mail-viewer-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load mail-viewer-extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.mainViewHeaderField.setText("");
        this.mainViewContentPanel.setEnabled(false);
        this.mainViewContentPanel.removeAll();
        this.mainViewPartsList.clearSelection();
        ((DefaultListModel)this.mainViewPartsList.getModel()).removeAllElements();
        this.updateMessage();
        this.showMainPanel(BUSY_PANEL);
        this.mainBusyLabel.setBusy(false);
        this.mainBusyLabel.setText(I18N.tr("Message is not loaded yet."));
    }

    private void showMainPanel(String string) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show((Container)((Object)this), string);
    }

    private void showMessage(DbMailPart dbMailPart) throws MessagingException {
        PartItem partItem;
        ContentType contentType;
        DbMailPart[] dbMailPartArray;
        this.mainViewContentPanel.removeAll();
        this.mainViewPartsList.setEnabled(false);
        this.mainViewPartsList.clearSelection();
        DefaultListModel defaultListModel = (DefaultListModel)this.mainViewPartsList.getModel();
        defaultListModel.removeAllElements();
        this.mainViewHeaderField.setText(MailViewer.generateHeader(this.currentMessage));
        this.mainViewHeaderField.setCaretPosition(0);
        for (DbMailPart dbMailPart2 : dbMailPartArray = dbMailPart != null ? dbMailPart.getSingleParts() : new DbMailPart[]{}) {
            if (!StringUtils.isEmpty((CharSequence)dbMailPart2.disposition)) continue;
            contentType = new ContentType(dbMailPart2.type);
            partItem = null;
            String string = I18N.tr(MESSAGE_PANEL);
            if (contentType.match("text/plain")) {
                partItem = new PartItem(dbMailPart2, contentType, string + ".txt");
            } else if (contentType.match("text/html")) {
                partItem = new PartItem(dbMailPart2, contentType, string + ".html");
            }
            if (partItem == null) continue;
            partItem.icon = this.getMessagePartIcon(partItem, 32);
            defaultListModel.addElement(partItem);
        }
        for (DbMailPart dbMailPart2 : dbMailPartArray) {
            contentType = new ContentType(dbMailPart2.type);
            if (StringUtils.isEmpty((CharSequence)dbMailPart2.disposition) && (contentType.match("text/html") || contentType.match("text/plain")) || contentType.match("multipart/*")) continue;
            partItem = new PartItem(dbMailPart2, contentType, null);
            partItem.icon = this.getMessagePartIcon(partItem, 32);
            defaultListModel.addElement(partItem);
        }
        this.updateMessage();
        this.mainViewPartsList.setEnabled(true);
        if (this.mainViewPartsList.getModel().getSize() > 0) {
            this.mainViewPartsList.setSelectedIndex(0);
        }
        this.showMainPanel(MESSAGE_PANEL);
    }

    private void showMessagePart(PartItem partItem) {
        this.showMessagePart(partItem != null ? partItem.getPart() : null, partItem != null ? partItem.getContentType() : null);
    }

    private void showMessagePart(DbMailPart dbMailPart, ContentType contentType) {
        if (dbMailPart == null) {
            return;
        }
        if (dbMailPart.id == this.currentPartId) {
            return;
        }
        JComponent jComponent = null;
        if (this.mainViewPartComponents.containsKey(dbMailPart.id)) {
            jComponent = this.mainViewPartComponents.get(dbMailPart.id);
        } else {
            try {
                jComponent = this.createViewer(dbMailPart, contentType);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load viewer!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            this.mainViewPartComponents.put(dbMailPart.id, jComponent);
        }
        if (jComponent != null) {
            this.mainViewContentPanel.removeAll();
            this.mainViewContentPanel.add((Component)jComponent, "Center");
            this.mainViewContentPanel.revalidate();
            this.mainViewContentPanel.repaint();
            this.currentPartId = dbMailPart.id;
            this.mainViewPartsList.revalidate();
            this.mainViewPartsList.repaint();
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        if (this.currentMessage != null) {
            this.updateMdnInfo();
        }
        try {
            this.mainViewHeaderField.setText(this.currentMessage != null ? MailViewer.generateHeader(this.currentMessage) : "");
            this.mainViewHeaderField.setCaretPosition(0);
        }
        catch (Exception exception) {
            LOGGER.error("Can't update header field!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void updateMdnInfo() {
        if (this.currentMessage.isDownloaded && this.currentMessage.isReceived && DbMailMessage.MdnStatus.REQUESTED.equals((Object)this.currentMessage.mdnStatus)) {
            Object[] objectArray = null;
            try {
                objectArray = InternetAddress.parse((String)this.currentMessage.from);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read mail author!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            String string = !ArrayUtils.isEmpty((Object[])objectArray) ? objectArray[0].getPersonal() : null;
            String string2 = StringUtils.isBlank((CharSequence)string) ? I18N.tr("The sender of this message asks for a return receipt.") : I18N.tr("{0} asks for a return receipt.", (Object)('\"' + StringEscapeUtils.escapeXml11((String)string) + '\"'));
            JLabel jLabel = new JLabel("<html><b>" + string2 + "</b></html>");
            jLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)32));
            jLabel.setIconTextGap(5);
            JButton jButton = new JButton((Action)((Object)new NotificationShowAccountsAction()));
            JButton jButton2 = new JButton((Action)((Object)new NotificationDenyAction()));
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.setOpaque(false);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this.mainViewInfoPanel.removeAll();
            this.mainViewInfoPanel.add((Component)jLabel, "Center");
            this.mainViewInfoPanel.add((Component)jPanel, "East");
            this.mainViewInfoPanel.revalidate();
            this.mainViewInfoPanel.repaint();
            this.mainViewInfoPanel.setVisible(true);
        } else {
            this.mainViewInfoPanel.removeAll();
            this.mainViewInfoPanel.setVisible(false);
        }
    }

    public void updateMessage() {
        this.updateMdnInfo();
    }

    private class NotificationShowAccountsAction
    extends AbstractI18nAction {
        private NotificationShowAccountsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            MailViewer.this.doNotificationShowAccounts(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("send confirmation")));
            this.setShortDescription(I18N.tr("Send the requested return receipt to the message sender."));
        }
    }

    private class NotificationDenyAction
    extends AbstractI18nAction {
        private NotificationDenyAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doNotificationDeny();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("ignore")));
            this.setShortDescription(I18N.tr("Don't send a return receipt to the message sender."));
        }
    }

    private class NotificationAcceptAction
    extends AbstractI18nAction {
        private final DbMailAccount account;

        private NotificationAcceptAction(DbMailAccount dbMailAccount) {
            this.account = dbMailAccount;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doNotificationAccept(this.account.id);
        }

        protected void updateLocalization() {
            this.setName(I18N.tr("send via {0}", (Object)this.account.writeSender()));
        }
    }

    private class MessageShowActionsAction
    extends AbstractI18nAction {
        private MessageShowActionsAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_generic.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            MailViewer.this.doMessageShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected message."));
        }
    }

    private class MessageReplyAction
    extends AbstractI18nAction {
        private MessageReplyAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_reply.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageReply();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("reply")));
            this.setShortDescription(I18N.tr("Compose a reply to the selected message."));
        }
    }

    private class MessageRemoveAction
    extends AbstractI18nAction {
        private MessageRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove selected message."));
        }
    }

    private class MessageMoveAction
    extends AbstractI18nAction {
        private MessageMoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageMove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("move")));
            this.setShortDescription(I18N.tr("Move e-mail to another folder."));
        }
    }

    private class MessageForwardAction
    extends AbstractI18nAction {
        private MessageForwardAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_forward.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageForward();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("forward")));
            this.setShortDescription(I18N.tr("Forward the message."));
        }
    }

    private class MessageExportAction
    extends AbstractI18nAction {
        private MessageExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageExport();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("export")));
            this.setShortDescription(I18N.tr("Save selected message as file to harddisk."));
        }
    }

    private class MessageEditAction
    extends AbstractI18nAction {
        private MessageEditAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("draft.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageEdit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("edit")));
            this.setShortDescription(I18N.tr("Edit the current e-mail."));
        }
    }

    private class MessageCopyAction
    extends AbstractI18nAction {
        private MessageCopyAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_copy.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageCopy();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("copy")));
            this.setShortDescription(I18N.tr("Create a copy of the e-mail."));
        }
    }

    private class MessageArchiveTask
    extends ImmoToolTask<Boolean, Void> {
        private final boolean archive;

        private MessageArchiveTask(boolean bl) {
            this.archive = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                mailHandler.markMessageArchived(immoToolProject, connection, MailViewer.this.currentMessage, null, this.archive);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't update messages!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private class MessageArchiveAction
    extends AbstractI18nAction {
        private final boolean archive;

        private MessageArchiveAction(boolean bl) {
            this.archive = bl;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"db.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doMessageArchive(this.archive);
        }

        protected void updateLocalization() {
            if (this.archive) {
                this.setName(StringUtils.capitalize((String)I18N.tr("store into archive")));
                this.setShortDescription(I18N.tr("Store selected message permanently into the archive."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("remove from archive")));
                this.setShortDescription(I18N.tr("Remove selected message from the archive."));
            }
        }
    }

    private static class AttachmentSaveTask
    extends ImmoToolTask<Boolean, Void> {
        private final PartItem[] items;
        private final File destination;
        private final boolean multipleAttachments;

        private AttachmentSaveTask(PartItem[] partItemArray, File file) {
            this.items = partItemArray;
            this.destination = file;
            this.multipleAttachments = ArrayUtils.getLength((Object)partItemArray) > 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbMailExtension dbMailExtension = MailPlugin.getDbMailExtension();
            Connection connection = null;
            try {
                for (PartItem partItem : this.items) {
                    Object object;
                    Object object2;
                    File file = this.multipleAttachments ? new File(this.destination.getAbsolutePath() + File.separator + partItem.getFileName()) : this.destination;
                    long l = partItem.getFileSize();
                    if (l > 0L) {
                        if (connection == null) {
                            connection = immoToolProject.getDbConnection();
                        }
                        object2 = new BufferedOutputStream(new FileOutputStream(file));
                        object = null;
                        try {
                            dbMailExtension.getMessageHandler().downloadPart(connection, partItem.getId(), (OutputStream)object2);
                            ((OutputStream)object2).flush();
                            continue;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        ((OutputStream)object2).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    ((OutputStream)object2).close();
                                }
                            }
                        }
                    }
                    object2 = partItem.getText();
                    if (StringUtils.isBlank((CharSequence)object2)) continue;
                    object = new FileWriterWithEncoding(file, "UTF-8");
                    Throwable throwable = null;
                    try {
                        ((Writer)object).write((String)object2);
                        ((Writer)object).flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((Writer)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Writer)object).close();
                            }
                        }
                    }
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly(connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save attachments!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            String string = this.multipleAttachments ? "<html>" + ArrayUtils.getLength((Object)this.items) + " Anh\u00e4nge wurden gespeichert nach<br>" + this.destination.getAbsolutePath() + "</html>" : "<html>Ein Anhang wurde gespeichert nach<br>" + this.destination.getAbsolutePath() + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string, (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private class AttachmentSaveAction
    extends AbstractI18nAction {
        private final boolean saveAll;

        private AttachmentSaveAction(boolean bl) {
            this.saveAll = bl;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailViewer.this.doAttachmentSave(this.saveAll);
        }

        protected void updateLocalization() {
            if (this.saveAll) {
                this.setName(StringUtils.capitalize((String)I18N.tr("save all attachments")));
                this.setShortDescription(I18N.tr("Save all attachments to harddisk."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("save attachment")));
                this.setShortDescription(I18N.tr("Save selected attachments to harddisk."));
            }
        }
    }

    private static class PartList
    extends JList<PartItem> {
        private final NumberFormat numberFormat = NumberFormat.getInstance();

        private PartList() {
            super(new DefaultListModel());
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n < 0) {
                return super.getToolTipText(mouseEvent);
            }
            PartItem partItem = (PartItem)this.getModel().getElementAt(n);
            if (partItem == null) {
                return super.getToolTipText(mouseEvent);
            }
            long l = partItem.getFileSize();
            String string = partItem.getFileName();
            String string2 = partItem.getType();
            String string3 = partItem.getDescription();
            String string4 = "<b>" + StringEscapeUtils.escapeXml11((String)string) + "</b>";
            if (!StringUtils.isBlank((CharSequence)string2)) {
                string4 = string4 + "<br>" + string2.split(";")[0].trim();
            }
            if (!StringUtils.isBlank((CharSequence)string3)) {
                string4 = string4 + "<br>" + StringEscapeUtils.escapeXml11((String)string3.trim());
            }
            if (l > 0L) {
                string4 = string4 + "<br>" + ImmoToolUtils.getHumanReadableByteCount((long)l, (NumberFormat)this.numberFormat);
            }
            return "<html><div style=\"padding:3px;\">" + string4 + "</div></html>";
        }
    }

    private class PartItemRenderer
    extends DefaultListCellRenderer<PartItem> {
        private final Font plainFont;
        private final Font boldFont;

        private PartItemRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.plainFont = this.getFont();
            this.boldFont = this.plainFont.deriveFont(1);
        }

        public Component getRenderedComponent(JList<? extends PartItem> jList, PartItem partItem, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getRenderedComponent(jList, (Object)partItem, n, bl, bl2);
            if (partItem != null) {
                jLabel.setText(partItem.getFileName());
                jLabel.setIcon(partItem.getIcon());
                jLabel.setFont(partItem.getId() == MailViewer.this.currentPartId ? this.boldFont : this.plainFont);
            } else {
                jLabel.setText("");
                jLabel.setIcon(null);
                jLabel.setFont(this.plainFont);
            }
            return this;
        }
    }

    public static class PartItem {
        private final DbMailPart part;
        private final ContentType contentType;
        private final String fixedName;
        private Icon icon;

        private PartItem(DbMailPart dbMailPart, ContentType contentType, String string) {
            this.part = dbMailPart;
            this.contentType = contentType;
            this.fixedName = string;
            this.icon = null;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public String getDescription() {
            return this.part.description;
        }

        public String getFileName() {
            String string = !StringUtils.isBlank((CharSequence)this.fixedName) ? this.fixedName : this.part.fileName;
            return !StringUtils.isBlank((CharSequence)string) ? string.trim() : "part_" + this.part.id + ".bin";
        }

        public long getFileSize() {
            return this.part.fileSize;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public long getId() {
            return this.part.id;
        }

        public DbMailPart getPart() {
            return this.part;
        }

        public String getText() {
            return this.part.text;
        }

        public String getType() {
            return this.part.type;
        }
    }

    private class MailListener
    extends MailHandlerAdapter {
        private MailListener() {
        }

        @Override
        public void messageWasMoved(DbMailMessage dbMailMessage, long l, long l2) {
            if (!MailViewer.this.isEnabled() || MailViewer.this.currentMessage == null || dbMailMessage == null || ((MailViewer)MailViewer.this).currentMessage.id != dbMailMessage.id) {
                return;
            }
            DbMailFolder dbMailFolder = MailPlugin.getMailHandler().getFolder(dbMailMessage.folderId);
            MailViewer.this.currentFolderId = dbMailMessage.folderId;
            MailViewer.this.currentAccountId = dbMailFolder.accountId;
        }

        @Override
        public void messageWasUpdated(DbMailMessage dbMailMessage) {
            if (!MailViewer.this.isEnabled() || MailViewer.this.currentMessage == null || dbMailMessage == null || ((MailViewer)MailViewer.this).currentMessage.id != dbMailMessage.id) {
                return;
            }
            MailViewer.this.setMessage(dbMailMessage);
            MailViewer.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    private class LoadInBackgroundTask
    extends ImmoToolTask<Boolean, Void> {
        private final AbstractDbDriver dbDriver;

        private LoadInBackgroundTask(AbstractDbDriver abstractDbDriver) {
            this.dbDriver = abstractDbDriver;
        }

        protected Boolean doInBackground() throws Exception {
            if (MailViewer.this.getCurrentMessageLocalId() < 1L) {
                return false;
            }
            Connection connection = null;
            try {
                connection = this.dbDriver.getConnection();
                MailViewer.this.doLoadInBackground(connection);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail viewer!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }
    }
}

