/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailAccountPermissionTab
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAccountPermissionTab.class);
    private static final I18n I18N = I18nFactory.getI18n(MailAccountPermissionTab.class);
    private ImmoToolPermissionPanel form;

    public MailAccountPermissionTab(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.form = new ImmoToolPermissionPanel(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.form, "Center");
        this.revalidate();
        this.repaint();
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    @Override
    public String getTitle() {
        return this.form.getTitle();
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.form.getValidationHandler();
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            this.form.setPermission(0L, 0L, null);
        } else {
            this.form.setPermission(dbMailAccount.ownerUserId, dbMailAccount.ownerGroupId, dbMailAccount.permission);
        }
    }

    @Override
    public void loadInBackground(ImmoToolProject immoToolProject) {
        ImmoToolUtils.executeTask((ImmoToolTask)this.form.loadInBackground(immoToolProject));
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        DbGroup dbGroup;
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.permission = this.form.getSelectedPermission();
        DbUser dbUser = this.form.getSelectedOwner();
        if (dbUser != null) {
            dbMailAccount.ownerUserId = dbUser.id;
        }
        if ((dbGroup = this.form.getSelectedGroup()) != null) {
            dbMailAccount.ownerGroupId = dbGroup.id;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.form.setEnabled(bl);
    }
}

