/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailWritePanel
extends AbstractMainTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailWritePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(MailWritePanel.class);
    private boolean mailWasSent = false;
    private long currentMessageId = 0L;
    private MailEditor.ViewMode currentViewMode = null;
    private MailEditor mailEditor;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction mailSendAction;
    private JButton attachmentButton;
    private JButton saveButton;
    private JButton optionsButton;
    private boolean loaded = false;
    private final Map<MailEditor.RecipientType, List<MailEditor.Address>> recipientsBeforeLoaded = new EnumMap<MailEditor.RecipientType, List<MailEditor.Address>>(MailEditor.RecipientType.class);

    private MailWritePanel() {
    }

    public void addRecipient(MailEditor.RecipientType recipientType, MailEditor.Address address) {
        if (!this.loaded) {
            if (!this.recipientsBeforeLoaded.containsKey((Object)recipientType)) {
                this.recipientsBeforeLoaded.put(recipientType, new ArrayList());
            }
            this.recipientsBeforeLoaded.get((Object)recipientType).add(address);
        } else {
            this.mailEditor.addRecipient(recipientType, address);
        }
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.mailSendAction = new MailSendAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.attachmentButton = this.mailEditor.getAttachmentButton();
        this.saveButton = this.mailEditor.getSaveButton();
        this.optionsButton = this.mailEditor.getOptionsButton();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.mailSendAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.saveButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.attachmentButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.optionsButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildMainComponent() {
        return this.mailEditor;
    }

    public boolean canClose() {
        if (this.mailWasSent) {
            return true;
        }
        long l = this.mailEditor.getCurrentMessageHash();
        long l2 = this.mailEditor.getSavedMessageHash();
        if (l2 == l) {
            return true;
        }
        Boolean bl = ImmoToolUtils.showQuestionWithCancelDialog((String)("<html>" + I18N.tr("The e-mail was not sent so far!") + "<br>" + I18N.tr("Do you want to save the e-mail as draft before close?") + "</html>"), (Component)((Object)this));
        if (bl == null) {
            return false;
        }
        if (Boolean.TRUE.equals(bl)) {
            this.mailEditor.doSaveAsDraft();
        }
        return true;
    }

    public static MailWritePanel createTab() {
        return MailWritePanel.createTab(null, 0L);
    }

    public static MailWritePanel createTab(MailEditor.ViewMode viewMode, long l) {
        MailWritePanel mailWritePanel = new MailWritePanel();
        mailWritePanel.currentViewMode = viewMode != null ? viewMode : MailEditor.ViewMode.NEW;
        mailWritePanel.currentMessageId = l > 0L ? l : 0L;
        return mailWritePanel;
    }

    public void doClose(boolean bl) {
        if (!bl && !this.canClose()) {
            return;
        }
        if (this.mailEditor != null) {
            this.mailEditor.cleanup();
        }
        super.doClose(bl);
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        switch (this.currentViewMode) {
            case DRAFT: {
                this.mailEditor.loadAsDraft(connection, this.currentMessageId);
                break;
            }
            case FORWARD: {
                this.mailEditor.loadAsForward(connection, this.currentMessageId);
                break;
            }
            case REPLY: {
                this.mailEditor.loadAsReply(connection, this.currentMessageId);
                break;
            }
            case TEMPLATE: {
                this.mailEditor.loadAsTemplate(connection, this.currentMessageId);
                break;
            }
            default: {
                this.mailEditor.loadAsNew(connection, this.currentMessageId);
            }
        }
        if (!this.recipientsBeforeLoaded.isEmpty()) {
            for (Map.Entry<MailEditor.RecipientType, List<MailEditor.Address>> entry : this.recipientsBeforeLoaded.entrySet()) {
                MailEditor.RecipientType recipientType = entry.getKey();
                List<MailEditor.Address> list = entry.getValue();
                for (MailEditor.Address address : list) {
                    this.mailEditor.addRecipient(recipientType, address);
                }
            }
            this.mailEditor.removeEmptyRecipients();
            this.recipientsBeforeLoaded.clear();
        }
        this.loaded = true;
    }

    public void doRefresh() {
    }

    private void doMailSend() {
        boolean bl;
        if (!this.mailEditor.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)((Object)this));
            return;
        }
        Map<MailEditor.RecipientType, List<MailEditor.Address>> map = this.mailEditor.getEmailRecipients();
        boolean bl2 = bl = map.isEmpty() || !map.containsKey((Object)MailEditor.RecipientType.TO) && !map.containsKey((Object)MailEditor.RecipientType.CC) && !map.containsKey((Object)MailEditor.RecipientType.BCC);
        if (bl) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No recipient was provided for the e-mail!"), (Component)((Object)this));
            return;
        }
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new MailSendTask(map), (Window)ImmoToolEnvironment.getFrame());
    }

    protected Icon getHeaderIcon() {
        return MailPlugin.getResourceIcon("mail_new.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)(this.currentViewMode != null ? this.currentViewMode.getTranslation() : MailEditor.ViewMode.NEW.getTranslation()));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)(this.currentViewMode != null ? this.currentViewMode.getTranslation() : MailEditor.ViewMode.NEW.getTranslation()));
    }

    protected void init() {
        super.init();
        this.mailEditor = new MailEditor(true);
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    private class MailSendTask
    extends ImmoToolTask<Boolean, Void> {
        final Map<MailEditor.RecipientType, List<MailEditor.Address>> recipients;

        public MailSendTask(Map<MailEditor.RecipientType, List<MailEditor.Address>> map) {
            super(I18N.tr("Sending e-mail."));
            this.recipients = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            MailHandler mailHandler = MailPlugin.getMailHandler();
            DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
            MailEditor mailEditor = MailWritePanel.this.mailEditor;
            DbMailAccount dbMailAccount = mailEditor.getSelectedAccount();
            long l = mailEditor.getReferencedMessageId();
            Connection connection = null;
            try {
                DbMailFolder dbMailFolder;
                Serializable serializable;
                connection = immoToolProject.getDbConnection();
                Email email = mailEditor.getEmail(dbMailAccount, this.recipients);
                DbMailMessage dbMailMessage = mailHandler.sendMessage(immoToolProject, connection, email, dbMailAccount.id, true);
                if (l > 0L && (mailEditor.isReplyMode() || mailEditor.isForwardMode()) && (serializable = dbMailMessageHandler.getMessage(connection, l)) != null && (dbMailFolder = mailHandler.getFolder(((DbMailMessage)serializable).folderId)) != null) {
                    if (mailEditor.isReplyMode()) {
                        mailHandler.markMessageAnswered(immoToolProject, connection, (DbMailMessage)serializable, dbMailFolder, true);
                    } else if (mailEditor.isForwardMode()) {
                        mailHandler.markMessageForwarded(immoToolProject, connection, (DbMailMessage)serializable, dbMailFolder, true);
                    }
                }
                if (dbMailMessage != null) {
                    mailEditor.saveAdditionally(connection, dbMailMessage, this.recipients, MailEditor.SaveMode.OUTBOX);
                }
                serializable = true;
                return serializable;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't send email!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            MailWritePanel.this.mailWasSent = true;
            MailWritePanel.this.doClose(true);
        }
    }

    private class MailSendAction
    extends AbstractI18nAction {
        public MailSendAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon("mail_send.png", 16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MailWritePanel.this.doMailSend();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("send")));
            this.setShortDescription(I18N.tr("Send the current e-mail message."));
        }
    }
}

