/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.tool.mail.MailEditorPane;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPriority;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.mail.io.AbstractMailWriter;
import com.openindex.openestate.tool.mail.io.ImapReader;
import com.openindex.openestate.tool.mail.io.Pop3Reader;
import com.openindex.openestate.tool.mail.io.SmtpWriter;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbMailAccount
implements Comparable<DbMailAccount>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailAccount.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailAccount.class);
    private static final String CUSTOM = "custom";
    private static final String READER = "reader";
    private static final String WRITER = "writer";
    private static final String SENDER_FROM_NAME = "sender.fromName";
    private static final String SENDER_FROM_MAIL = "sender.fromMail";
    private static final String SENDER_REPLY_TO = "sender.replyTo";
    private static final String SENDER_SIGNATURE_HTML = "sender.signature.html";
    private static final String SENDER_SIGNATURE_TEXT = "sender.signature.text";
    private static final String EDITOR_MDN = "editor.mdn";
    private static final String EDITOR_MODE = "editor.mode";
    private static final String EDITOR_PRIORITY = "editor.priority";
    public long id = 0L;
    public String name = null;
    public String notes = null;
    public boolean enabled = true;
    public boolean autoRetrieval = false;
    public long autoRetrievalInterval = 0L;
    public Date autoRetrievalAt = null;
    public Type type = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public Map<String, String> settings = null;

    public Map<String, String> buildCustomPropertyMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.getCustomPropertyKeys()) {
            hashMap.put(string, this.getCustomProperty(string));
        }
        return hashMap;
    }

    public AbstractMailReader buildReader() {
        AbstractMailReader abstractMailReader;
        if (this.settings == null) {
            return null;
        }
        AbstractMailReader.Type type = this.getReaderType();
        if (AbstractMailReader.Type.IMAP.equals((Object)type)) {
            abstractMailReader = new ImapReader();
        } else if (AbstractMailReader.Type.POP3.equals((Object)type)) {
            abstractMailReader = new Pop3Reader();
        } else {
            return null;
        }
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!string.startsWith("reader.")) continue;
            abstractMailReader.put(string.substring("reader.".length()), string2);
        }
        return abstractMailReader;
    }

    public Session buildReaderSession() {
        AbstractMailReader abstractMailReader = this.buildReader();
        return abstractMailReader != null ? abstractMailReader.createSession(this.buildCustomPropertyMap()) : null;
    }

    public AbstractMailWriter buildWriter() {
        if (this.settings == null) {
            return null;
        }
        AbstractMailWriter.Type type = this.getWriterType();
        if (!AbstractMailWriter.Type.SMTP.equals((Object)type)) {
            return null;
        }
        SmtpWriter smtpWriter = new SmtpWriter();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!string.startsWith("writer.")) continue;
            smtpWriter.put(string.substring("writer.".length()), string2);
        }
        return smtpWriter;
    }

    public Session buildWriterSession() {
        AbstractMailWriter abstractMailWriter = this.buildWriter();
        return abstractMailWriter != null ? abstractMailWriter.createSession(this.buildCustomPropertyMap()) : null;
    }

    public int calculateHash() {
        int n = DbMailAccount.class.getName().hashCode();
        n += Long.valueOf(this.id).hashCode();
        n += Boolean.valueOf(this.enabled).hashCode();
        if (this.name != null) {
            n += this.name.hashCode();
        }
        if (this.notes != null) {
            n += this.notes.hashCode();
        }
        if (this.type != null) {
            n += this.type.hashCode();
        }
        n += Boolean.valueOf(this.autoRetrieval).hashCode();
        n += Long.valueOf(this.autoRetrievalInterval).hashCode();
        n += Long.valueOf(this.ownerUserId).hashCode();
        n += Long.valueOf(this.ownerGroupId).hashCode();
        if (this.permission != null) {
            n += Integer.valueOf(this.permission.getValue()).hashCode();
        }
        if (this.settings != null) {
            for (Map.Entry<String, String> entry : this.settings.entrySet()) {
                n += entry.getKey().hashCode();
                n += entry.getValue().hashCode();
            }
        }
        return n;
    }

    public void clearCustomProperties() {
        if (this.settings == null) {
            return;
        }
        for (String string : this.getCustomPropertyKeys()) {
            this.setCustomProperty(string, null);
        }
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            return -1;
        }
        if (this.type != dbMailAccount.type) {
            return this.type.compareTo(dbMailAccount.type);
        }
        if (this.name != null && dbMailAccount.name != null && !this.name.equalsIgnoreCase(dbMailAccount.name)) {
            return this.name.toLowerCase().compareTo(dbMailAccount.name.toLowerCase());
        }
        if (this.id != dbMailAccount.id) {
            return Long.valueOf(this.id).compareTo(dbMailAccount.id);
        }
        return Integer.valueOf(this.calculateHash()).compareTo(dbMailAccount.calculateHash());
    }

    public final DbMailFolder createRootFolder() {
        return DbMailFolder.createRootFolder(this.id);
    }

    public String get(String string) {
        return this.settings != null && this.settings.containsKey(string) ? this.settings.get(string) : null;
    }

    public String getCustomProperty(String string) {
        return this.get("custom." + string);
    }

    public String[] getCustomPropertyKeys() {
        if (this.settings == null) {
            return new String[0];
        }
        String string = "custom.";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.settings.keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2.substring(string.length()));
        }
        return arrayList.toArray(new String[0]);
    }

    public MailEditorPane.Mode getEditorMode() {
        try {
            String string = this.get(EDITOR_MODE);
            if ("TEXT_AND_HTML".equalsIgnoreCase(string)) {
                return MailEditorPane.Mode.HTML_ONLY;
            }
            if (!StringUtils.isBlank((CharSequence)string)) {
                return MailEditorPane.Mode.valueOf(string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read editor mode of account #" + this.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return MailEditorPane.Mode.TEXT_ONLY;
    }

    public MailPriority getEditorPriority() {
        try {
            String string = this.get(EDITOR_PRIORITY);
            if (!StringUtils.isBlank((CharSequence)string)) {
                return MailPriority.valueOf(string);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read editor priority of account #" + this.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return null;
    }

    public String getReaderSetting(String string) {
        return this.getReaderSetting(string, null);
    }

    public String getReaderSetting(String string, String string2) {
        String string3 = this.get("reader." + string);
        return string3 != null ? string3 : string2;
    }

    public AbstractMailReader.Type getReaderType() {
        String string = this.get(READER);
        return string != null ? AbstractMailReader.Type.valueOf(string) : null;
    }

    public InternetAddress getSenderFromAddress() {
        String string = this.getSenderFromMail();
        String string2 = this.getSenderFromName();
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        try {
            InternetAddress internetAddress = new InternetAddress(string.trim());
            if (!StringUtils.isBlank((CharSequence)string2)) {
                internetAddress.setPersonal(string2.trim());
            }
            return internetAddress;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create from address!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getSenderFromMail() {
        return this.get(SENDER_FROM_MAIL);
    }

    public String getSenderFromName() {
        return this.get(SENDER_FROM_NAME);
    }

    public String getSenderReplyTo() {
        return this.get(SENDER_REPLY_TO);
    }

    public InternetAddress getSenderReplyToAddress() {
        String string = this.getSenderReplyTo();
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        try {
            InternetAddress internetAddress = new InternetAddress(string.trim());
            return internetAddress;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create reply-to address!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public String getSenderSignatureHtml() {
        return this.get(SENDER_SIGNATURE_HTML);
    }

    public String getSenderSignatureText() {
        return this.get(SENDER_SIGNATURE_TEXT);
    }

    public String getWriterSetting(String string) {
        return this.getWriterSetting(string, null);
    }

    public String getWriterSetting(String string, String string2) {
        String string3 = this.get("writer." + string);
        return string3 != null ? string3 : string2;
    }

    public AbstractMailWriter.Type getWriterType() {
        String string = this.get(WRITER);
        return string != null ? AbstractMailWriter.Type.valueOf(string) : null;
    }

    public boolean isLocal() {
        return this.isLocalPrivate() || this.isLocalShared();
    }

    public boolean isLocalPrivate() {
        return Type.LOCAL_PRIVATE.equals((Object)this.type);
    }

    public boolean isLocalShared() {
        return Type.LOCAL_SHARED.equals((Object)this.type);
    }

    public boolean isEditorMdn() {
        String string = this.get(EDITOR_MDN);
        return !StringUtils.isBlank((CharSequence)string) ? Boolean.valueOf(string) : false;
    }

    public boolean isReaderDebug() {
        String string = this.get("reader.debug");
        return !StringUtils.isBlank((CharSequence)string) ? Boolean.valueOf(string) : false;
    }

    public boolean isRemote() {
        return Type.REMOTE.equals((Object)this.type);
    }

    public boolean isWriterDebug() {
        String string = this.get("writer.debug");
        return !StringUtils.isBlank((CharSequence)string) ? Boolean.valueOf(string) : false;
    }

    public void load(Properties properties) {
        this.settings = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ("name".equalsIgnoreCase(string)) {
                this.name = properties.getProperty(string);
                continue;
            }
            if ("notes".equalsIgnoreCase(string)) {
                this.notes = properties.getProperty(string);
                continue;
            }
            if ("enabled".equalsIgnoreCase(string)) {
                this.enabled = Boolean.TRUE.toString().equalsIgnoreCase(properties.getProperty(string));
                continue;
            }
            if ("type".equalsIgnoreCase(string)) {
                this.type = Type.valueOf(properties.getProperty(string));
                continue;
            }
            if ("local".equalsIgnoreCase(string)) {
                boolean bl = Boolean.TRUE.toString().equalsIgnoreCase(properties.getProperty(string));
                this.type = !bl ? Type.REMOTE : Type.LOCAL_PRIVATE;
                continue;
            }
            this.settings.put(string, properties.getProperty(string));
        }
    }

    public void save(Properties properties) {
        if (this.name != null) {
            properties.setProperty("name", this.name);
        }
        if (this.notes != null) {
            properties.setProperty("notes", this.notes);
        }
        properties.setProperty("enabled", String.valueOf(this.enabled));
        properties.setProperty("type", this.type != null ? this.type.name() : Type.REMOTE.name());
        if (this.settings != null) {
            for (Map.Entry<String, String> entry : this.settings.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public void set(String string, String string2) {
        String string3;
        if (this.settings == null) {
            return;
        }
        String string4 = string3 = string2 != null && string2.trim().length() > 0 ? string2.trim() : null;
        if (string3 == null) {
            this.settings.remove(string);
        } else {
            this.settings.put(string, string3);
        }
    }

    public void setCustomProperty(String string, String string2) {
        this.set("custom." + string, string2);
    }

    public void setEditorMdn(boolean bl) {
        this.set(EDITOR_MDN, String.valueOf(bl));
    }

    public void setEditorMode(MailEditorPane.Mode mode) {
        this.set(EDITOR_MODE, mode != null ? mode.name() : null);
    }

    public void setEditorPriority(MailPriority mailPriority) {
        this.set(EDITOR_PRIORITY, mailPriority != null ? mailPriority.name() : null);
    }

    public void setReader(AbstractMailReader abstractMailReader) {
        if (this.settings == null) {
            return;
        }
        this.settings.remove(READER);
        String[] stringArray = this.settings.keySet().toArray(new String[0]);
        for (String string : stringArray) {
            if (!string.startsWith("reader.")) continue;
            this.settings.remove(string);
        }
        if (abstractMailReader != null) {
            this.settings.put(READER, abstractMailReader.getType().name());
            for (Map.Entry entry : abstractMailReader.entrySet()) {
                this.settings.put("reader." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setReaderDebug(boolean bl) {
        this.set("reader.debug", this.getReaderType() != null ? String.valueOf(bl) : null);
    }

    public void setSenderFromMail(String string) {
        this.set(SENDER_FROM_MAIL, string);
    }

    public void setSenderFromName(String string) {
        this.set(SENDER_FROM_NAME, string);
    }

    public void setSenderReplyTo(String string) {
        this.set(SENDER_REPLY_TO, string);
    }

    public void setSenderSignatureHtml(String string) {
        this.set(SENDER_SIGNATURE_HTML, string);
    }

    public void setSenderSignatureText(String string) {
        this.set(SENDER_SIGNATURE_TEXT, string);
    }

    public void setWriter(AbstractMailWriter abstractMailWriter) {
        if (this.settings == null) {
            return;
        }
        this.settings.remove(WRITER);
        String[] stringArray = this.settings.keySet().toArray(new String[0]);
        for (String string : stringArray) {
            if (!string.startsWith("writer.")) continue;
            this.settings.remove(string);
        }
        if (abstractMailWriter != null) {
            this.settings.put(WRITER, abstractMailWriter.getType().name());
            for (Map.Entry entry : abstractMailWriter.entrySet()) {
                this.settings.put("writer." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setWriterDebug(boolean bl) {
        this.set("writer.debug", this.getWriterType() != null ? String.valueOf(bl) : null);
    }

    public String writeName() {
        return this.isLocalPrivate() ? DbMailAccount.writeNameOfLocalPrivateAccount() : this.name;
    }

    public static String writeNameOfLocalPrivateAccount() {
        return StringUtils.capitalize((String)I18N.tr("my e-mails"));
    }

    public String writeSender() {
        try {
            return new InternetAddress(this.getSenderFromMail(), StringUtils.trimToNull((String)this.getSenderFromName())).toUnicodeString();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't create internet address for mail account #" + this.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public static enum Type {
        REMOTE,
        LOCAL_PRIVATE,
        LOCAL_SHARED;


        public Icon getIcon() {
            return this.getIcon(32, false);
        }

        public Icon getIcon(boolean bl) {
            return this.getIcon(32, bl);
        }

        private Icon getIcon(int n, boolean bl) {
            Image image = MailPlugin.getResourceImage("account_" + this.name().toLowerCase() + ".png", n);
            return new ImageIcon(bl ? GrayFilter.createDisabledImage(image) : image);
        }

        public Icon getSmallIcon() {
            return this.getIcon(16, false);
        }

        public Icon getSmallIcon(boolean bl) {
            return this.getIcon(16, bl);
        }
    }
}

