/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.mail.MailPlugin;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbMailFolder
implements Comparable<DbMailFolder>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMailFolder.class);
    private static final I18n I18N = I18nFactory.getI18n(DbMailFolder.class);
    public long id = 0L;
    public long accountId = 0L;
    public long parentFolderId = 0L;
    public String name = null;
    public boolean holdsMessages = false;
    public boolean holdsFolders = false;
    public boolean isAutoRetrieval = false;
    public SpecialType specialType = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public DbMailFolder parentFolder = null;
    public List<DbMailFolder> subFolders = null;

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(DbMailFolder dbMailFolder) {
        if (dbMailFolder == null) {
            return -1;
        }
        if (this.specialType != null && dbMailFolder.specialType == null) {
            return -1;
        }
        if (this.specialType == null && dbMailFolder.specialType != null) {
            return 1;
        }
        if (this.specialType != null && dbMailFolder.specialType != null && this.specialType != dbMailFolder.specialType) {
            return this.specialType.compareTo(dbMailFolder.specialType);
        }
        if (this.name != null && dbMailFolder.name != null && !this.name.equalsIgnoreCase(dbMailFolder.name)) {
            return this.name.toLowerCase().compareTo(dbMailFolder.name.toLowerCase());
        }
        if (this.id != dbMailFolder.id) {
            return Long.valueOf(this.id).compareTo(dbMailFolder.id);
        }
        return Integer.valueOf(ImmoToolUtils.hashCode((Object)this)).compareTo(ImmoToolUtils.hashCode((Object)dbMailFolder));
    }

    public static DbMailFolder createRootFolder(long l) {
        DbMailFolder dbMailFolder = DbMailFolder.createSubFolder(null, 0L, l);
        dbMailFolder.holdsFolders = true;
        dbMailFolder.holdsMessages = false;
        return dbMailFolder;
    }

    public final DbMailFolder createSubFolder(String string) {
        if (this.id < 1L) {
            throw new IllegalStateException("Can't create child folder for unsaved parent folder!");
        }
        DbMailFolder dbMailFolder = DbMailFolder.createSubFolder(string, this.id, this.accountId);
        dbMailFolder.holdsFolders = true;
        dbMailFolder.holdsMessages = true;
        return dbMailFolder;
    }

    public static DbMailFolder createSubFolder(String string, long l, long l2) {
        DbMailFolder dbMailFolder = new DbMailFolder();
        dbMailFolder.name = string;
        dbMailFolder.parentFolderId = l;
        dbMailFolder.accountId = l2;
        return dbMailFolder;
    }

    public List<DbMailFolder> getAllSubFolders() {
        ArrayList<DbMailFolder> arrayList = new ArrayList<DbMailFolder>();
        if (this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                arrayList.add(dbMailFolder);
                arrayList.addAll(dbMailFolder.getAllSubFolders());
            }
        }
        return arrayList;
    }

    public List<DbMailFolder> getParents() {
        ArrayList<DbMailFolder> arrayList = new ArrayList<DbMailFolder>();
        if (this.parentFolder != null) {
            arrayList.addAll(this.parentFolder.getParents());
            arrayList.add(this.parentFolder);
        }
        return arrayList;
    }

    public String[] getPath() {
        List<String> list = this.getPathElements();
        return list.toArray(new String[0]);
    }

    private List<String> getPathElements() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.parentFolder != null) {
            arrayList.addAll(this.parentFolder.getPathElements());
        }
        if (this.name != null) {
            arrayList.add(this.name);
        }
        return arrayList;
    }

    public DbMailFolder getSubFolder(long l) {
        if (l > 0L && this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                if (dbMailFolder.id != l) continue;
                return dbMailFolder;
            }
        }
        return null;
    }

    public DbMailFolder getSubFolder(String string) {
        if (!StringUtils.isBlank((CharSequence)string) && this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                if (!string.equals(dbMailFolder.name)) continue;
                return dbMailFolder;
            }
        }
        return null;
    }

    public boolean hasSubFolder(long l) {
        if (l > 0L && this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                if (dbMailFolder.id != l) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSubFolder(String string) {
        if (!StringUtils.isBlank((CharSequence)string) && this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                if (!string.equals(dbMailFolder.name)) continue;
                return true;
            }
        }
        return false;
    }

    public DbMailFolder lookupFolder(long l) {
        if (this.id == l) {
            return this;
        }
        if (this.subFolders != null && !this.subFolders.isEmpty()) {
            for (DbMailFolder dbMailFolder : this.subFolders) {
                DbMailFolder dbMailFolder2 = dbMailFolder.lookupFolder(l);
                if (dbMailFolder2 == null) continue;
                return dbMailFolder2;
            }
        }
        return null;
    }

    public static enum SpecialType implements Translatable
    {
        INBOX(I18n.marktr((String)"inbox"), null),
        OUTBOX(I18n.marktr((String)"outbox"), new String[]{"sent"}),
        DRAFTS(I18n.marktr((String)"drafts"), new String[]{"draft"}),
        TEMPLATES(I18n.marktr((String)"templates"), new String[]{"template"}),
        SPAM(I18n.marktr((String)"spam"), null),
        TRASH(I18n.marktr((String)"trash"), new String[]{"junk"});

        private final String i18nKey;
        private final String[] aliases;

        private SpecialType(String string2, String[] stringArray) {
            this.i18nKey = string2;
            this.aliases = stringArray;
        }

        public Icon getIcon() {
            return this.getIcon(32, false);
        }

        public Icon getIcon(boolean bl) {
            return this.getIcon(32, bl);
        }

        private Icon getIcon(int n, boolean bl) {
            Image image = MailPlugin.getResourceImage("folder_" + this.name().toLowerCase() + ".png", n);
            return new ImageIcon(bl ? GrayFilter.createDisabledImage(image) : image);
        }

        public Icon getSmallIcon() {
            return this.getIcon(16, false);
        }

        public Icon getSmallIcon(boolean bl) {
            return this.getIcon(16, bl);
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DbMailFolder.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbMailFolder.class, (String)this.i18nKey, (Locale)locale);
        }

        public static SpecialType guessFromFolderName(String string) {
            for (SpecialType specialType : SpecialType.values()) {
                if (specialType.name().equalsIgnoreCase(string)) {
                    return specialType;
                }
                if (ArrayUtils.isEmpty((Object[])specialType.aliases)) continue;
                for (String string2 : specialType.aliases) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return specialType;
                }
            }
            return null;
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

