/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.io;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.EnumRenderer;
import com.openindex.openestate.tool.gui.PortNrField;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.mail.MailAccountDialog;
import com.openindex.openestate.tool.mail.MailAccountDialogForm;
import com.openindex.openestate.tool.mail.MailAccountPropertiesTab;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.mail.io.Pop3Reader;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Pop3Panel
extends MailAccountDialogForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pop3Panel.class);
    private static final I18n I18N = I18nFactory.getI18n(Pop3Panel.class);
    private Pop3Reader currentReader = null;
    private ValidationHandler validationHandler;
    private JXTitledSeparator formTitle;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private PortNrField portField;
    private JLabel authMethodLabel;
    private JComboBox<Pop3Reader.AuthMethod> authMethodField;
    private JLabel authUserLabel;
    private JTextField authUserField;
    private JLabel authPassLabel;
    private JPasswordField authPassField;
    private JLabel cryptMethodLabel;
    private JComboBox<Pop3Reader.CryptMethod> cryptMethodField;
    private JCheckBox removeDownloadedMessagesField;
    private JXTitledSeparator testTitle;
    private JXBusyLabel testBusyLabel;
    private TestAction testAction;

    public Pop3Panel(MailAccountDialog mailAccountDialog) {
        super(mailAccountDialog);
        this.build();
    }

    private void build() {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.testTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.hostLabel = new JLabel();
        this.hostField = new JTextField();
        this.portLabel = new JLabel();
        this.portField = new PortNrField();
        this.authUserLabel = new JLabel();
        this.authUserField = new JTextField();
        this.authPassLabel = new JLabel();
        this.authPassField = new JPasswordField();
        this.authMethodLabel = new JLabel();
        this.authMethodField = new JComboBox();
        this.authMethodField.setRenderer((ListCellRenderer<Pop3Reader.AuthMethod>)new DefaultListCellRenderer((Renderer)new EnumRenderer()));
        this.authMethodField.addItem(null);
        for (Pop3Reader.AuthMethod enum_ : Pop3Reader.AuthMethod.values()) {
            this.authMethodField.addItem(enum_);
        }
        this.authMethodField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Pop3Panel.this.authMethodField.isEnabled()) {
                    return;
                }
                Pop3Panel.this.updateAuthFields();
            }
        });
        this.cryptMethodLabel = new JLabel();
        this.cryptMethodField = new JComboBox();
        this.cryptMethodField.setRenderer((ListCellRenderer<Pop3Reader.CryptMethod>)new DefaultListCellRenderer((Renderer)new EnumRenderer()));
        this.cryptMethodField.addItem(null);
        for (Enum enum_ : Pop3Reader.CryptMethod.values()) {
            this.cryptMethodField.addItem((Pop3Reader.CryptMethod)enum_);
        }
        this.removeDownloadedMessagesField = new JCheckBox();
        this.testAction = new TestAction();
        this.testBusyLabel = new JXBusyLabel();
        this.testBusyLabel.setVisible(false);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.validationHandler.putRule((JComponent)this.hostField, ValidationHandler.HOSTNAME);
        this.validationHandler.putRule((JComponent)this.portField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.authMethodField, ValidationHandler.NOT_NULL);
        this.validationHandler.putRule((JComponent)this.authUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.authPassField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.cryptMethodField, ValidationHandler.NOT_NULL);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.hostLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.hostField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.portField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.authMethodLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.authMethodField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.authUserLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.authUserField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.authPassLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.authPassField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.cryptMethodLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.cryptMethodField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.removeDownloadedMessagesField).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.testTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.testAction))).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.testBusyLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        this.setBorder(Paddings.EMPTY);
        this.updateLocalization();
        this.load(null);
        this.loadDefaults();
    }

    private Pop3Reader createPop3Reader() {
        Pop3Reader pop3Reader = new Pop3Reader();
        pop3Reader.setHost(this.hostField.getText().trim());
        pop3Reader.setPort(this.portField.getPortNr());
        pop3Reader.setAuthMethod((Pop3Reader.AuthMethod)((Object)this.authMethodField.getSelectedItem()));
        pop3Reader.setAuthUser(this.authUserField.getText().trim());
        pop3Reader.setAuthPass(this.authPassField.getPassword());
        pop3Reader.setCryptMethod((Pop3Reader.CryptMethod)((Object)this.cryptMethodField.getSelectedItem()));
        pop3Reader.setRemoveDownloadedMessages(this.removeDownloadedMessagesField.isSelected());
        return pop3Reader;
    }

    private void doTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            String string = "<html><b>" + I18N.tr("Can't test connection to the mail server!") + "</b><br>" + I18N.tr("The provided settings are incorrect.") + "</html>";
            ImmoToolUtils.showMessageErrorDialog((String)string, (Component)((Object)this.getDialog()));
            return;
        }
        this.testAction.setEnabled(false);
        this.testBusyLabel.setBusy(true);
        this.testBusyLabel.setText(I18N.tr("Connecting to mail server."));
        this.testBusyLabel.setVisible(true);
        ImmoToolUtils.executeTask((ImmoToolTask)new TestTask());
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("receiving"));
    }

    @Override
    public ValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    @Override
    public void load(DbMailAccount dbMailAccount) {
        this.authMethodField.setEnabled(false);
        this.currentReader = dbMailAccount != null && AbstractMailReader.Type.POP3.equals((Object)dbMailAccount.getReaderType()) ? (Pop3Reader)dbMailAccount.buildReader() : new Pop3Reader();
        this.hostField.setText(this.currentReader.getHost());
        this.portField.setPortNr(this.currentReader.getPort());
        this.authMethodField.setSelectedItem((Object)this.currentReader.getAuthMethod());
        this.authUserField.setText(this.currentReader.getAuthUser());
        this.authPassField.setText(this.currentReader.getAuthPass() != null ? String.valueOf(this.currentReader.getAuthPass()) : "");
        this.cryptMethodField.setSelectedItem((Object)this.currentReader.getCryptMethod());
        this.removeDownloadedMessagesField.setSelected(this.currentReader.isRemoveDownloadedMessages());
        this.authMethodField.setEnabled(this.isEnabled());
        this.updateAuthFields();
        this.validationHandler.init();
    }

    @Override
    public void loadDefaults() {
        super.loadDefaults();
        this.portField.setPortNr(110);
    }

    @Override
    public void save(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            throw new NullPointerException("No account provided!");
        }
        dbMailAccount.setReader(this.createPop3Reader());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hostField.setEnabled(bl);
        this.portField.setEnabled(bl);
        this.cryptMethodField.setEnabled(bl);
        this.removeDownloadedMessagesField.setEnabled(bl);
        this.testAction.setEnabled(bl);
        this.updateAuthFields(bl);
    }

    private void updateAuthFields() {
        this.updateAuthFields(this.isEnabled());
    }

    private void updateAuthFields(boolean bl) {
        Pop3Reader.AuthMethod authMethod = (Pop3Reader.AuthMethod)((Object)this.authMethodField.getSelectedItem());
        this.authMethodField.setEnabled(bl);
        this.authUserField.setEnabled(bl && authMethod != null && !Pop3Reader.AuthMethod.ANONYMOUS.equals((Object)authMethod));
        this.authPassField.setEnabled(bl && authMethod != null && !Pop3Reader.AuthMethod.ANONYMOUS.equals((Object)authMethod));
        this.validationHandler.validate((JComponent)this.authUserField);
        this.validationHandler.validate((JComponent)this.authPassField);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("mail receiving via POP3")));
        this.hostLabel.setText(StringUtils.capitalize((String)I18N.tr("hostname")) + ":");
        this.hostField.setToolTipText(I18N.tr("Enter the hostname / IP-address of the mail server."));
        this.portLabel.setText(StringUtils.capitalize((String)I18N.tr("port nr")) + ":");
        this.portField.setToolTipText(I18N.tr("Enter the port-nr of the mail server."));
        this.authMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("authentication")) + ":");
        this.authMethodField.setToolTipText(I18N.tr("Use this field to specify, how authentication is handled by the mail server."));
        this.authUserLabel.setText(StringUtils.capitalize((String)I18N.tr("username")) + ":");
        this.authUserField.setToolTipText(I18N.tr("Enter the username for authentication at the mail server."));
        this.authPassLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
        this.authPassField.setToolTipText(I18N.tr("Enter the password for authentication at the mail server."));
        this.cryptMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("encryption")) + ":");
        this.cryptMethodField.setToolTipText(I18N.tr("Use this field to specify, how encryption is handled by the mail server."));
        this.removeDownloadedMessagesField.setText(I18N.tr("Remove downloaded messages."));
        this.removeDownloadedMessagesField.setToolTipText(I18N.tr("Enable this option to remove downloaded messages from the mail server."));
        this.testTitle.setTitle(StringUtils.capitalize((String)I18N.tr("test POP3 connection")));
    }

    private class TestTask
    extends ImmoToolTask<Boolean, Void> {
        private TestTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            MailAccountPropertiesTab mailAccountPropertiesTab;
            MailAccountDialog.Node node;
            MailAccountDialog mailAccountDialog = Pop3Panel.this.getDialog();
            this.setMessage("Create reader");
            Pop3Reader pop3Reader = Pop3Panel.this.createPop3Reader();
            if (pop3Reader == null) {
                throw new NullPointerException("Can't create reader!");
            }
            this.setMessage("Create session");
            Session session = null;
            if (mailAccountDialog == null) {
                LOGGER.warn("Can't find mail account dialog.");
            } else {
                node = mailAccountDialog.getCurrentAccountNode();
                mailAccountPropertiesTab = (MailAccountPropertiesTab)node.getChildForm(MailAccountPropertiesTab.class);
                if (mailAccountPropertiesTab == null) {
                    LOGGER.warn("Can't find mail account properties.");
                } else {
                    session = pop3Reader.createSession(mailAccountPropertiesTab.getProperties());
                }
            }
            if (session == null) {
                LOGGER.warn("Create session without extended properties.");
                session = pop3Reader.createSession();
            }
            if (session == null) {
                throw new NullPointerException("Can't create session!");
            }
            this.setMessage("Create store");
            node = pop3Reader.createStore(session);
            try {
                this.setMessage("Lookup folders");
                mailAccountPropertiesTab = node.getDefaultFolder();
                for (Folder folder : mailAccountPropertiesTab.listSubscribed()) {
                    try {
                        int n = folder.getMessageCount();
                        this.setMessage(n + " messages in folder " + folder.getFullName());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't count messages in folder");
                        LOGGER.warn("> " + exception.getLocalizedMessage());
                        this.setMessage("Can't count messages in folder " + folder.getFullName());
                    }
                }
            }
            finally {
                MailPluginUtils.closeQuietly((Store)node);
            }
            return true;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            String string = null;
            if (throwable instanceof MessagingException && throwable.getCause() != null) {
                Throwable throwable2 = throwable.getCause();
                string = throwable2 instanceof UnknownHostException ? I18N.tr("No mail server found at the provided address!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : (throwable2 instanceof ConnectException ? I18N.tr("Can't establish a connection to the mail server!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : (throwable2 instanceof AuthenticationFailedException ? I18N.tr("Can't login to the mail server!") + "<br>" + StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage()) : StringEscapeUtils.escapeXml11((String)throwable2.getLocalizedMessage())));
            }
            if (StringUtils.isBlank(string)) {
                string = StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage());
            }
            Pop3Panel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test failed!") + "</b><br>" + string + "</html>");
        }

        protected void finished() {
            super.finished();
            Pop3Panel.this.testAction.setEnabled(true);
            Pop3Panel.this.testBusyLabel.setBusy(false);
        }

        protected void setMessage(String string) {
            super.setMessage(string);
            Pop3Panel.this.testBusyLabel.setText(string);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            Pop3Panel.this.testBusyLabel.setText("<html><b>" + I18N.tr("The connection test was finished successfully.") + "</b></html>");
        }
    }

    private class TestAction
    extends AbstractI18nAction {
        private TestAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Pop3Panel.this.doTest();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Establish a test connection to check the server settings."));
        }
    }
}

