/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.io;

import com.openindex.openestate.tool.core.LoggingOutputStream;
import com.openindex.openestate.tool.core.ssl.ExtendedSSLSocketFactory;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.IDN;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.commons.mail.DefaultAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Pop3Reader
extends AbstractMailReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pop3Reader.class);
    private static final I18n I18N = I18nFactory.getI18n(Pop3Reader.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"mail.pop3");
    private static final String POP3_HOST = "pop3.host";
    private static final String POP3_PORT = "pop3.port";
    private static final String POP3_AUTH_METHOD = "pop3.auth.method";
    private static final String POP3_AUTH_USER = "pop3.auth.user";
    private static final String POP3_AUTH_PASS = "pop3.auth.pass";
    private static final String POP3_CRYPT_METHOD = "pop3.crypt.method";
    private static final String POP3_DOWNLOAD_CLEAR = "pop3.download.clear";

    public Pop3Reader() {
        this.put(POP3_HOST, "localhost");
        this.put(POP3_PORT, "110");
        this.put(POP3_AUTH_METHOD, AuthMethod.ANONYMOUS.name());
        this.put(POP3_CRYPT_METHOD, CryptMethod.NO_ENCRYPTION.name());
    }

    @Override
    public Session createSession(Map<String, String> map) {
        Object object;
        Object object2;
        DefaultAuthenticator defaultAuthenticator = null;
        AuthMethod authMethod = this.getAuthMethod();
        CryptMethod cryptMethod = this.getCryptMethod();
        String string = CryptMethod.POP3S.equals((Object)cryptMethod) ? "pop3s" : "pop3";
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "false");
        properties.setProperty("mail.store.protocol", string);
        properties.setProperty("mail." + string + ".host", IDN.toASCII(this.getHost()));
        properties.setProperty("mail." + string + ".port", String.valueOf(this.getPort()));
        properties.setProperty("mail." + string + ".connectiontimeout", "10000");
        properties.setProperty("mail." + string + ".timeout", "10000");
        if (authMethod != null && !AuthMethod.ANONYMOUS.equals((Object)authMethod)) {
            object2 = this.getAuthUser();
            object = this.getAuthPass();
            defaultAuthenticator = new DefaultAuthenticator((String)(object2 != null ? object2 : ""), object != null ? String.valueOf((char[])object) : "");
            if (AuthMethod.APOP.equals((Object)authMethod)) {
                properties.setProperty("mail." + string + ".apop.enable", "true");
            }
        }
        if (CryptMethod.POP3S.equals((Object)cryptMethod)) {
            try {
                properties.put("mail." + string + ".socketFactory", new ExtendedSSLSocketFactory());
                properties.setProperty("mail." + string + ".socketFactory.fallback", "false");
                properties.setProperty("mail." + string + ".socketFactory.port", String.valueOf(this.getPort()));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't create SSL socket factory!");
                LOGGER.warn("> " + exception.getLocalizedMessage());
            }
        } else if (CryptMethod.STARTTLS.equals((Object)cryptMethod)) {
            properties.setProperty("mail." + string + ".starttls.enable", "true");
            properties.setProperty("mail." + string + ".starttls.required", "true");
            try {
                properties.put("mail." + string + ".ssl.socketFactory", new ExtendedSSLSocketFactory());
                properties.setProperty("mail." + string + ".ssl.socketFactory.fallback", "false");
                properties.setProperty("mail." + string + ".ssl.socketFactory.port", String.valueOf(this.getPort()));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't create SSL socket factory!");
                LOGGER.warn("> " + exception.getLocalizedMessage());
            }
        }
        if (map != null && !map.isEmpty()) {
            object2 = map.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                properties.setProperty((String)object.getKey(), (String)object.getValue());
            }
        }
        object2 = Session.getInstance((Properties)properties, defaultAuthenticator);
        if (this.isDebug() || Boolean.TRUE.equals(Boolean.valueOf(properties.getProperty("mail.debug")))) {
            object = "[";
            object = (String)object + "POP3] ";
            try {
                object2.setDebugOut(new PrintStream((OutputStream)new LoggingOutputStream(DEBUG_LOGGER, LoggingOutputStream.Priority.INFO, (String)object), true, "UTF-8"));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't register IMAP debug stream!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            object2.setDebug(true);
        }
        return object2;
    }

    public AuthMethod getAuthMethod() {
        return this.containsKey(POP3_AUTH_METHOD) ? AuthMethod.valueOf((String)this.get(POP3_AUTH_METHOD)) : null;
    }

    public char[] getAuthPass() {
        return this.containsKey(POP3_AUTH_PASS) ? ((String)this.get(POP3_AUTH_PASS)).toCharArray() : null;
    }

    public String getAuthUser() {
        return (String)this.get(POP3_AUTH_USER);
    }

    public CryptMethod getCryptMethod() {
        return this.containsKey(POP3_CRYPT_METHOD) ? CryptMethod.valueOf((String)this.get(POP3_CRYPT_METHOD)) : null;
    }

    public String getHost() {
        return (String)this.get(POP3_HOST);
    }

    public int getPort() {
        return this.containsKey(POP3_PORT) ? Integer.parseInt((String)this.get(POP3_PORT)) : 0;
    }

    @Override
    public final AbstractMailReader.Type getType() {
        return AbstractMailReader.Type.POP3;
    }

    public boolean isRemoveDownloadedMessages() {
        return this.containsKey(POP3_DOWNLOAD_CLEAR) ? Boolean.valueOf((String)this.get(POP3_DOWNLOAD_CLEAR)) : false;
    }

    public static boolean isRemoveDownloadedMessages(DbMailAccount dbMailAccount) {
        return Boolean.valueOf(dbMailAccount.getReaderSetting(POP3_DOWNLOAD_CLEAR, "false"));
    }

    @Override
    protected Store openStore(Session session) throws MessagingException {
        AuthMethod authMethod = this.getAuthMethod();
        CryptMethod cryptMethod = this.getCryptMethod();
        Store store = null;
        try {
            store = session.getStore(CryptMethod.POP3S.equals((Object)cryptMethod) ? "pop3s" : "pop3");
            switch (authMethod) {
                case ANONYMOUS: {
                    store.connect();
                    break;
                }
                case LOGIN: 
                case APOP: {
                    store.connect(this.getAuthUser(), String.valueOf(this.getAuthPass()));
                }
            }
            return store;
        }
        catch (MessagingException messagingException) {
            MailPluginUtils.closeQuietly(store);
            throw messagingException;
        }
    }

    public void setAuthMethod(AuthMethod authMethod) {
        if (authMethod == null) {
            this.remove(POP3_AUTH_METHOD);
        } else {
            this.put(POP3_AUTH_METHOD, authMethod.name());
        }
    }

    public void setAuthPass(char[] cArray) {
        if (cArray == null) {
            this.remove(POP3_AUTH_PASS);
        } else {
            this.put(POP3_AUTH_PASS, String.valueOf(cArray));
        }
    }

    public void setAuthUser(String string) {
        if (string == null) {
            this.remove(POP3_AUTH_USER);
        } else {
            this.put(POP3_AUTH_USER, string);
        }
    }

    public void setCryptMethod(CryptMethod cryptMethod) {
        if (cryptMethod == null) {
            this.remove(POP3_CRYPT_METHOD);
        } else {
            this.put(POP3_CRYPT_METHOD, cryptMethod.name());
        }
    }

    public void setHost(String string) {
        if (string == null) {
            this.remove(POP3_HOST);
        } else {
            this.put(POP3_HOST, string);
        }
    }

    public void setPort(int n) {
        if (n < 1) {
            this.remove(POP3_PORT);
        } else {
            this.put(POP3_PORT, String.valueOf(n));
        }
    }

    public void setRemoveDownloadedMessages(boolean bl) {
        this.put(POP3_DOWNLOAD_CLEAR, String.valueOf(bl));
    }

    public static enum CryptMethod {
        NO_ENCRYPTION,
        STARTTLS,
        POP3S;

    }

    public static enum AuthMethod {
        ANONYMOUS,
        LOGIN,
        APOP;

    }
}

