/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExtendedMimeMessage
extends MimeMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedMimeMessage.class);
    private static final I18n I18N = I18nFactory.getI18n(ExtendedMimeMessage.class);
    private String fixedMessageId;

    public ExtendedMimeMessage(Session session, String string) {
        super(session);
        this.fixedMessageId = string;
    }

    public ExtendedMimeMessage(Session session, String string, boolean bl) {
        super(session);
        this.fixedMessageId = string;
        if (bl) {
            this.flags = new Flags();
        }
    }

    public ExtendedMimeMessage(MimeMessage mimeMessage, String string) throws MessagingException {
        super(mimeMessage);
        this.fixedMessageId = string;
    }

    public ExtendedMimeMessage(MimeMessage mimeMessage, String string, boolean bl) throws MessagingException {
        super(mimeMessage);
        this.fixedMessageId = string;
        if (bl) {
            this.flags = new Flags();
        }
    }

    public String getFixedMessageId() {
        return this.fixedMessageId;
    }

    public void setFlags(Flags flags) {
        this.flags = flags != null ? flags : new Flags();
    }

    public void setFixedMessageId(String string) {
        this.fixedMessageId = string;
    }

    protected void updateMessageID() throws MessagingException {
        if (StringUtils.isBlank((CharSequence)this.fixedMessageId)) {
            super.updateMessageID();
        } else {
            this.setHeader("Message-ID", this.fixedMessageId.trim());
        }
    }
}

