/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailImportTask
extends ImmoToolTask<Integer, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailImportTask.class);
    private static final I18n I18N = I18nFactory.getI18n(MailImportTask.class);
    protected Connection dbConnection;
    protected AbstractDbDriver dbDriver;
    protected DbMailMessageHandler messageHandler;
    protected DbMailFolder destFolder;
    protected DbMailAccount destAccount;
    protected List<File> messages;

    public MailImportTask(AbstractDbDriver abstractDbDriver, DbMailMessageHandler dbMailMessageHandler, DbMailFolder dbMailFolder, DbMailAccount dbMailAccount) {
        super("Import mail");
        this.dbConnection = null;
        this.dbDriver = abstractDbDriver;
        this.messageHandler = dbMailMessageHandler;
        this.destFolder = dbMailFolder;
        this.destAccount = dbMailAccount;
        this.messages = new ArrayList<File>();
    }

    public MailImportTask(Connection connection, DbMailMessageHandler dbMailMessageHandler, DbMailFolder dbMailFolder, DbMailAccount dbMailAccount) {
        super("Import mail");
        this.dbConnection = connection;
        this.dbDriver = null;
        this.messageHandler = dbMailMessageHandler;
        this.destFolder = dbMailFolder;
        this.destAccount = dbMailAccount;
        this.messages = new ArrayList<File>();
    }

    public void addMessage(File file) {
        this.messages.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground() throws Exception {
        if (this.destFolder == null) {
            throw new Exception("Unknown folder!");
        }
        Connection connection = this.dbConnection;
        Session session = null;
        Store store = null;
        Folder folder = null;
        Folder folder2 = null;
        int n = 0;
        try {
            AbstractMailReader.Type type;
            if (this.destFolder.parentFolderId > 0L && this.destFolder.parentFolder == null) {
                if (connection == null) {
                    connection = this.dbDriver.getConnection();
                }
                this.messageHandler.loadFolderParents(connection, this.destFolder, true);
            }
            Object[] objectArray = this.destFolder.getPath();
            AbstractMailReader.Type type2 = type = this.destAccount != null && this.destAccount.isRemote() ? this.destAccount.getReaderType() : null;
            if (AbstractMailReader.Type.IMAP.equals((Object)type)) {
                this.setMessage("Connect to remote mailbox '" + this.destAccount.name + "'...");
                session = this.destAccount.buildReaderSession();
                store = session.getStore();
                store.connect();
                folder = store.getDefaultFolder();
                this.setMessage("Lookup folder: " + StringUtils.join((Object[])objectArray, (String)"/"));
                folder2 = folder.getFolder(StringUtils.join((Object[])objectArray, (char)folder.getSeparator()));
                if (!folder2.exists()) {
                    throw new MessagingException("Destination folder does not exist!");
                }
                folder2.open(2);
            }
            for (File file : this.messages) {
                ArrayList<File> arrayList = null;
                try {
                    MimeMessage mimeMessage;
                    if (connection == null) {
                        connection = this.dbDriver.getConnection();
                    }
                    this.setMessage("Parse: " + file.getAbsolutePath());
                    Throwable throwable = null;
                    try (Iterator iterator = new FileInputStream(file);){
                        mimeMessage = new MimeMessage(session, (InputStream)((Object)iterator));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    if (session != null && store != null && folder2 != null) {
                        this.setMessage("Append message remotely: " + mimeMessage.getMessageID());
                        folder2.appendMessages(new Message[]{mimeMessage});
                        mimeMessage.saveChanges();
                        this.wasSavedRemotely(mimeMessage);
                    }
                    this.setMessage("Append message locally: " + mimeMessage.getMessageID());
                    iterator = DbMailMessage.createMessage(mimeMessage, folder2);
                    ((DbMailMessage)((Object)iterator)).folderId = this.destFolder.id;
                    DbMailPart dbMailPart = DbMailPart.createPart(mimeMessage);
                    arrayList = new ArrayList<File>(Arrays.asList(dbMailPart.getTempFiles()));
                    this.messageHandler.saveMessage(connection, (DbMailMessage)((Object)iterator));
                    dbMailPart.setMessageId(((DbMailMessage)((Object)iterator)).id);
                    this.messageHandler.savePart(connection, dbMailPart, true);
                    this.wasSavedLocally(connection, (DbMailMessage)((Object)iterator), dbMailPart);
                    ++n;
                }
                finally {
                    if (arrayList == null) continue;
                    for (File file2 : arrayList) {
                        FileUtils.deleteQuietly((File)file2);
                    }
                }
            }
        }
        finally {
            if (this.dbConnection == null) {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            MailPluginUtils.closeQuietly(folder2);
            MailPluginUtils.closeQuietly(folder);
            MailPluginUtils.closeQuietly(store);
        }
        return n;
    }

    protected void wasSavedLocally(Connection connection, DbMailMessage dbMailMessage, DbMailPart dbMailPart) {
    }

    protected void wasSavedRemotely(MimeMessage mimeMessage) {
    }
}

