/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.gui.DefaultMenu;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPermission;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.extensions.MailHandlerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import com.openindex.openestate.tool.mail.io.AbstractMailReader;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailFrameSidebarExtension.class);
    public static final DataFlavor MAIL_FOLDER_ID_FLAVOR = new DataFlavor(DbMailFolder.class, "mail folder ids");
    public static final DataFlavor MAIL_MESSAGE_ID_FLAVOR = new DataFlavor(DbMailMessage.class, "mail message ids");
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_LOOKUP = 2;
    public static final int MENU_COMPOSE = 3;
    public static final int MENU_SELECTION = 4;
    public static final int MENU_ELSE = 5;
    public static final int MENU_ELSE_BEGIN = 6;
    public static final int MENU_ELSE_IMPORT_MESSAGE = 7;
    public static final int MENU_ELSE_IMPORT_ACCOUNT = 8;
    public static final int MENU_ELSE_END = 9;
    public static final int MENU_END = 10;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;
    private MailHandlerExtension mailListener = new MailListener();

    private static void addAccountNode(DbMailFolder dbMailFolder, TreeNode treeNode) {
        if (dbMailFolder == null) {
            return;
        }
        TreeNode treeNode2 = new TreeNode(1, dbMailFolder.accountId, dbMailFolder.id);
        treeNode.add((MutableTreeNode)((Object)treeNode2));
        if (dbMailFolder.subFolders != null && !dbMailFolder.subFolders.isEmpty()) {
            TreeSet<DbMailFolder> treeSet = new TreeSet<DbMailFolder>();
            treeSet.addAll(dbMailFolder.subFolders);
            for (DbMailFolder dbMailFolder2 : treeSet) {
                MailFrameSidebarExtension.addFolderNode(dbMailFolder2, treeNode2, true);
            }
        }
    }

    private static void addFolderNode(DbMailFolder dbMailFolder, TreeNode treeNode, boolean bl) {
        if (dbMailFolder == null) {
            return;
        }
        TreeNode treeNode2 = new TreeNode(2, dbMailFolder.accountId, dbMailFolder.id);
        if (bl) {
            treeNode.add((MutableTreeNode)((Object)treeNode2));
        } else {
            int n = -1;
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbMailFolder dbMailFolder2 = ((TreeNode)((Object)treeNode.getChildAt(i))).getFolder();
                if (dbMailFolder.compareTo(dbMailFolder2) >= 0) continue;
                n = i;
                break;
            }
            if (n < 0) {
                treeNode.add((MutableTreeNode)((Object)treeNode2));
            } else {
                treeNode.insert((MutableTreeNode)((Object)treeNode2), n);
            }
        }
        if (dbMailFolder.subFolders != null && !dbMailFolder.subFolders.isEmpty()) {
            TreeSet<DbMailFolder> treeSet = new TreeSet<DbMailFolder>();
            treeSet.addAll(dbMailFolder.subFolders);
            for (DbMailFolder dbMailFolder2 : treeSet) {
                MailFrameSidebarExtension.addFolderNode(dbMailFolder2, treeNode2, true);
            }
        }
    }

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        JMenuItem jMenuItem;
        Object object;
        Object object2;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbMailAccount dbMailAccount = treeNode != null ? treeNode.getAccount() : null;
        long l = dbMailAccount != null ? dbMailAccount.id : 0L;
        final DbMailFolder dbMailFolder = treeNode != null ? treeNode.getFolder() : null;
        long l2 = dbMailFolder != null ? dbMailFolder.id : 0L;
        Collection collection = MailFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, MailFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.SidebarRefreshAction())));
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.MessageLookupAction(l))));
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.MessageWriteAction())));
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (dbMailFolder != null) {
            object2 = StringUtils.capitalize((String)I18N.tr("folder"));
            if (!StringUtils.isEmpty((CharSequence)dbMailFolder.name)) {
                object2 = (String)object2 + " " + dbMailFolder.name;
            }
            object2 = StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)StringEscapeUtils.unescapeHtml4((String)object2), (int)30));
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)("<html>" + (String)object2 + "</html>")));
            if (dbMailFolder.holdsMessages) {
                jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.FolderViewAction(l2, true, true))));
            }
            if (dbMailFolder.holdsFolders) {
                jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.FolderAddAction(l2))));
            }
            if (dbMailFolder.parentFolderId > 0L) {
                jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.FolderRenameAction(l2))));
            }
            boolean bl = dbMailFolder.parentFolderId == 0L;
            boolean bl2 = bl = bl || dbMailFolder.specialType != null;
            if (!bl) {
                jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.FolderRemoveAction(l2))));
            }
            object = new DefaultMenu(){

                protected void updateLocalization() {
                    this.setText(I18N.tr("folder options"));
                }
            };
            if (!dbMailAccount.isLocalPrivate() && dbMailFolder.parentFolder != null && dbMailFolder.parentFolder.parentFolderId < 1L && dbMailFolder.holdsMessages) {
                jMenuItem = new JMenu(StringUtils.capitalize((String)I18N.tr("special folder")));
                ButtonGroup buttonGroup = new ButtonGroup();
                for (final DbMailFolder.SpecialType specialType : DbMailFolder.SpecialType.values()) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(StringUtils.capitalize((String)specialType.getTranslation()));
                    jRadioButtonMenuItem.setIcon(specialType.getSmallIcon());
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MailPlugin.getMailHandler().setFolderSpecialTypeInBackground(dbMailFolder, specialType);
                        }
                    });
                    buttonGroup.add(jRadioButtonMenuItem);
                    ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
                    if (!specialType.equals((Object)dbMailFolder.specialType)) continue;
                    jRadioButtonMenuItem.setSelected(true);
                }
                ((JMenu)jMenuItem).addSeparator();
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(I18N.tr("no special folder"));
                jRadioButtonMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MailPlugin.getMailHandler().setFolderSpecialTypeInBackground(dbMailFolder, null);
                    }
                });
                buttonGroup.add(jRadioButtonMenuItem);
                ((JMenu)jMenuItem).add(jRadioButtonMenuItem);
                if (dbMailFolder.specialType == null) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                object.add(jMenuItem);
            }
            if (dbMailFolder.parentFolderId > 0L && dbMailFolder.holdsMessages) {
                jMenuItem = new JCheckBoxMenuItem(StringUtils.capitalize((String)I18N.tr("automatic retrieval")));
                jMenuItem.setSelected(dbMailFolder.isAutoRetrieval);
                jMenuItem.setEnabled(!DbMailFolder.SpecialType.INBOX.equals((Object)dbMailFolder.specialType));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MailPlugin.getMailHandler().setFolderAutoRetrievalInBackground(dbMailFolder, !dbMailFolder.isAutoRetrieval);
                    }
                });
                object.add(jMenuItem);
            }
            if (object.getItemCount() > 0) {
                jPopupMenu.add((JMenuItem)object);
            }
        }
        if (dbMailAccount != null) {
            String string;
            object2 = StringUtils.trimToNull((String)dbMailAccount.writeName());
            String string2 = string = object2 != null ? StringUtils.capitalize((String)I18N.tr("mail account")) + " " + (String)object2 : StringUtils.capitalize((String)I18N.tr("mail account")) + " #" + dbMailAccount.id;
            if (string.length() > 30) {
                string = string.substring(0, 30);
            }
            string = StringEscapeUtils.escapeXml11((String)StringEscapeUtils.unescapeHtml4((String)string));
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)("<html>" + string + "</html>")));
            if (MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT)) {
                boolean bl = false;
                if (dbMailAccount.permission != null) {
                    bl = dbMailAccount.permission.canWrite(immoToolProject.getUser(), dbMailAccount.ownerUserId, dbMailAccount.ownerGroupId);
                }
                jMenuItem = new JMenuItem((Action)((Object)new MailPlugin.AccountSetupAction(l)));
                jMenuItem.setText(StringUtils.capitalize((String)I18N.tr("edit e-mail account")));
                jMenuItem.setEnabled(bl);
                jPopupMenu.add(jMenuItem);
            }
            if (MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EXPORT)) {
                object = new JMenuItem((Action)((Object)new MailPlugin.AccountExportAction(l)));
                ((AbstractButton)object).setText(StringUtils.capitalize((String)I18N.tr("export e-mail account")));
                jPopupMenu.add((JMenuItem)object);
            }
        }
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.addSeparator();
        if (dbMailAccount == null && dbMailFolder == null && MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT)) {
            jPopupMenu.add(new JMenuItem((Action)((Object)new MailPlugin.AccountSetupAction())));
        }
        object2 = new JMenu();
        ((AbstractButton)object2).setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
        ((JComponent)object2).setToolTipText(I18N.tr("Further actions in the e-mail addon."));
        MailFrameSidebarExtension.loadMenu((JMenu)object2, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        ((JMenu)object2).add(new JMenuItem((Action)((Object)new MailPlugin.MessageImportAction(l2))));
        MailFrameSidebarExtension.loadMenu((JMenu)object2, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        if (MailPlugin.isUserAllowedTo(MailPermission.ACCOUNTS_EDIT)) {
            ((JMenu)object2).add(new JMenuItem((Action)((Object)new MailPlugin.AccountImportAction())));
        }
        MailFrameSidebarExtension.loadMenu((JMenu)object2, (int)8, (SidebarTreeNode)treeNode, (Collection)collection);
        MailFrameSidebarExtension.loadMenu((JMenu)object2, (int)9, (SidebarTreeNode)treeNode, (Collection)collection);
        if (((JMenu)object2).getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)object2);
        }
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        MailFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)10, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.getSelectionModel().setSelectionMode(1);
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode())));
        tree.setDragEnabled(true);
        tree.setDropMode(DropMode.ON);
        tree.setTransferHandler(new TreeTransferHandler());
        tree.setScrollsOnExpand(true);
        return tree;
    }

    private static TreeModel createTreeModel() {
        TreeNode treeNode = new TreeNode();
        MailHandler mailHandler = MailPlugin.getMailHandler();
        if (mailHandler != null) {
            TreeSet<DbMailAccount> treeSet = new TreeSet<DbMailAccount>();
            treeSet.addAll(Arrays.asList(mailHandler.getRemoteAccounts()));
            treeSet.addAll(Arrays.asList(mailHandler.getLocalSharedAccounts()));
            treeSet.add(mailHandler.getLocalPrivateAccount());
            for (DbMailAccount dbMailAccount : treeSet) {
                Object object;
                if (dbMailAccount.isRemote() && !AbstractMailReader.Type.IMAP.equals(object = dbMailAccount.getReaderType())) continue;
                object = mailHandler.getRootFolder(dbMailAccount.id);
                if (object != null) {
                    MailFrameSidebarExtension.addAccountNode((DbMailFolder)object, treeNode);
                    continue;
                }
                LOGGER.warn("Mail account #" + dbMailAccount.id + " does not have a root folder yet!");
            }
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode));
    }

    private static void expandAccountNodes(Tree tree) {
        if (tree == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
        TreeNode treeNode = (TreeNode)defaultTreeModel.getRoot();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
            tree.expandPath(new TreePath(new Object[]{treeNode, treeNode2}));
        }
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return MailPlugin.getResourceIcon("mail_generic.png", 32);
    }

    public JPopupMenu getMenu() {
        return MailFrameSidebarExtension.createActionMenu(null);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("e-mails"));
    }

    public String getTooltipText() {
        return I18N.tr("Manage mail accounts.");
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            MailFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
            MailPlugin.getMailHandler().addCustomListener(this.mailListener);
        } else {
            LOGGER.warn("An invalid mail tree was registered!");
            MailFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        MailFrameSidebarExtension.setCurrentSidebar(null, null);
        MailHandler mailHandler = MailPlugin.getMailHandler();
        if (mailHandler != null) {
            mailHandler.removeCustomListener(this.mailListener);
        }
    }

    private static class TreeTransferHandler
    extends TransferHandler {
        private TreeTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            TreePath treePath;
            if (currentSidebarTree == null) {
                return false;
            }
            if (!transferSupport.isDataFlavorSupported(MAIL_FOLDER_ID_FLAVOR) && !transferSupport.isDataFlavorSupported(MAIL_MESSAGE_ID_FLAVOR)) {
                return false;
            }
            TreePath treePath2 = treePath = transferSupport.isDrop() ? ((JTree.DropLocation)transferSupport.getDropLocation()).getPath() : currentSidebarTree.getSelectionPath();
            if (treePath == null) {
                return false;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode == null) {
                return false;
            }
            for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
                if (!treeNode.isDataFlavorSupported(dataFlavor)) continue;
                if (MAIL_FOLDER_ID_FLAVOR.equals(dataFlavor)) {
                    try {
                        DbMailFolder dbMailFolder = treeNode.getFolder();
                        if (dbMailFolder != null) {
                            Long[] longArray = (Long[])transferSupport.getTransferable().getTransferData(dataFlavor);
                            List<DbMailFolder> list = dbMailFolder.getParents();
                            if (!list.isEmpty()) {
                                for (Long l : longArray) {
                                    if (l == dbMailFolder.id) {
                                        return false;
                                    }
                                    for (DbMailFolder dbMailFolder2 : list) {
                                        if (dbMailFolder2.id != l) continue;
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't check target folder node!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof Tree) {
                TreePath treePath = ((Tree)((Object)jComponent)).getSelectionPath();
                return treePath != null ? (TreeNode)treePath.getLastPathComponent() : null;
            }
            return null;
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            TreePath treePath;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            MailHandler mailHandler = MailPlugin.getMailHandler();
            TreePath treePath2 = treePath = transferSupport.isDrop() ? ((JTree.DropLocation)transferSupport.getDropLocation()).getPath() : currentSidebarTree.getSelectionPath();
            if (treePath == null) {
                return false;
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            Long l = treeNode.folderId;
            if (transferSupport.isDataFlavorSupported(MAIL_FOLDER_ID_FLAVOR)) {
                try {
                    Object[] objectArray = (Long[])transferSupport.getTransferable().getTransferData(MAIL_FOLDER_ID_FLAVOR);
                    if (ArrayUtils.isEmpty((Object[])objectArray)) {
                        return false;
                    }
                    for (Object object : objectArray) {
                        DbMailFolder dbMailFolder = mailHandler.getFolder((Long)object);
                        DbMailFolder dbMailFolder2 = mailHandler.getFolder(l);
                        MailPlugin.getMailHandler().moveFolderInBackground(dbMailFolder, dbMailFolder2);
                    }
                    return true;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't find folder to move!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            } else if (transferSupport.isDataFlavorSupported(MAIL_MESSAGE_ID_FLAVOR)) {
                try {
                    Object[] objectArray = (Long[])transferSupport.getTransferable().getTransferData(MAIL_MESSAGE_ID_FLAVOR);
                    if (ArrayUtils.isEmpty((Object[])objectArray)) {
                        return false;
                    }
                    DbMailFolder dbMailFolder = mailHandler.getFolder(l);
                    MailPlugin.getMailHandler().moveMessagesInBackground(ArrayUtils.toPrimitive((Long[])objectArray), dbMailFolder);
                    return true;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't find message to move!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            return false;
        }
    }

    public static class TreeNode
    extends SidebarTreeNode
    implements Transferable {
        public static final int TYPE_ROOT = 0;
        public static final int TYPE_ACCOUNT = 1;
        public static final int TYPE_FOLDER = 2;
        private int type = 0;
        private long accountId = 0L;
        private DbMailAccount.Type accountType = null;
        private long folderId = 0L;
        private DbMailFolder.SpecialType folderSpecialType = null;
        private String text = null;

        private TreeNode() {
        }

        private TreeNode(int n, long l, long l2) {
            this.type = n;
            this.accountId = l;
            this.folderId = l2;
            this.build();
        }

        private void build() {
            if (this.type == 1) {
                DbMailAccount dbMailAccount = this.getAccount();
                this.accountType = dbMailAccount != null ? dbMailAccount.type : null;
                this.text = dbMailAccount != null && !StringUtils.isBlank((CharSequence)dbMailAccount.name) ? StringEscapeUtils.escapeXml11((String)dbMailAccount.name.trim()) : "???";
                this.folderSpecialType = null;
            } else if (this.type == 2) {
                DbMailFolder dbMailFolder = this.getFolder();
                DbMailFolder.SpecialType specialType = this.folderSpecialType = dbMailFolder != null ? dbMailFolder.specialType : null;
                this.text = this.folderSpecialType != null ? null : (dbMailFolder != null && !StringUtils.isBlank((CharSequence)dbMailFolder.name) ? StringEscapeUtils.escapeXml11((String)dbMailFolder.name.trim()) : "???");
                this.accountType = null;
            } else {
                this.text = null;
                this.accountType = null;
                this.folderSpecialType = null;
            }
        }

        public void doShow(boolean bl) {
            switch (this.getType()) {
                case 2: {
                    if (this.folderId <= 0L) break;
                    new MailPlugin.FolderViewAction(this.folderId, true, bl).actionPerformed(null);
                    break;
                }
            }
        }

        public DbMailAccount getAccount() {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            try {
                return this.accountId > 0L && mailHandler != null ? mailHandler.getAccount(this.accountId) : null;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load account #" + this.accountId + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return null;
            }
        }

        public DbMailFolder getFolder() {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            try {
                return this.folderId > 0L && mailHandler != null ? mailHandler.getFolder(this.folderId) : null;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load folder #" + this.folderId + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                return null;
            }
        }

        public JPopupMenu getMenu() {
            return MailFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            switch (this.type) {
                case 1: {
                    return this.accountType != null ? this.accountType.getSmallIcon() : null;
                }
                case 2: {
                    return this.folderSpecialType != null ? this.folderSpecialType.getSmallIcon() : MailPlugin.getResourceIcon("folder.png", 16);
                }
            }
            return null;
        }

        public String getNodeText() {
            MailHandler mailHandler = MailPlugin.getMailHandler();
            switch (this.type) {
                case 1: {
                    if (DbMailAccount.Type.LOCAL_PRIVATE.equals((Object)this.accountType)) {
                        return this.title(DbMailAccount.writeNameOfLocalPrivateAccount());
                    }
                    return this.title(!StringUtils.isBlank((CharSequence)this.text) ? this.text : I18N.tr("mail account") + " #" + this.accountId);
                }
                case 2: {
                    int n;
                    String string;
                    String string2 = string = this.folderSpecialType != null ? StringEscapeUtils.escapeXml11((String)StringUtils.capitalize((String)this.folderSpecialType.getTranslation())) : StringUtils.trimToNull((String)StringUtils.capitalize((String)this.text));
                    if (StringUtils.isBlank((CharSequence)string)) {
                        return "???";
                    }
                    try {
                        n = this.folderId > 0L && mailHandler != null ? mailHandler.getUnseenMessageCount(this.folderId) : 0;
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load unseen message counter for folder #" + this.folderId + "!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        n = 0;
                    }
                    return n > 0 ? "<strong>" + string + " (" + n + ")</strong>" : string;
                }
            }
            return null;
        }

        public String getNodeTooltip() {
            switch (this.type) {
                case 1: {
                    if (DbMailAccount.Type.LOCAL_PRIVATE.equals((Object)this.accountType)) {
                        return I18N.tr("This account contains your downloaded personal e-mails.");
                    }
                    if (DbMailAccount.Type.LOCAL_SHARED.equals((Object)this.accountType)) {
                        return I18N.tr("This account contains downloaded e-mails, that may be shared with other users.");
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (MAIL_FOLDER_ID_FLAVOR.equals(dataFlavor)) {
                Long[] longArray;
                if (this.type == 2) {
                    Long[] longArray2 = new Long[1];
                    longArray = longArray2;
                    longArray2[0] = this.folderId;
                } else {
                    longArray = null;
                }
                return longArray;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray;
            if (this.type == 2) {
                DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
                dataFlavorArray = dataFlavorArray2;
                dataFlavorArray2[0] = MAIL_FOLDER_ID_FLAVOR;
            } else {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public int getType() {
            return this.type;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (this.type != 1 && this.type != 2) {
                return false;
            }
            DbMailFolder dbMailFolder = this.getFolder();
            if (MAIL_FOLDER_ID_FLAVOR.equals(dataFlavor)) {
                return dbMailFolder != null && dbMailFolder.holdsFolders;
            }
            if (MAIL_MESSAGE_ID_FLAVOR.equals(dataFlavor)) {
                return dbMailFolder != null && dbMailFolder.holdsMessages;
            }
            return false;
        }

        public void update() {
            this.build();
        }
    }

    public static class Tree
    extends SidebarTree {
        private Tree() {
        }

        public void addFolder(DbMailFolder dbMailFolder) {
            if (dbMailFolder == null) {
                throw new IllegalArgumentException("No folder was provided!");
            }
            if (dbMailFolder.id < 1L) {
                throw new IllegalArgumentException("An unsaved folder was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getRootNode();
            if (treeNode == null) {
                return;
            }
            TreeNode treeNode2 = this.lookupAccountNode(dbMailFolder.accountId);
            if (treeNode2 == null) {
                LOGGER.warn("Can't find account #" + dbMailFolder.accountId + " within mail tree!");
            } else {
                TreeNode treeNode3 = this.lookupFolderNode(treeNode2, dbMailFolder.parentFolderId);
                if (treeNode3 == null) {
                    LOGGER.warn("Can't find parent folder #" + dbMailFolder.parentFolderId + " for account #" + dbMailFolder.accountId + " within mail tree!");
                } else {
                    defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)new TreeNode(2, dbMailFolder.accountId, dbMailFolder.id)), (MutableTreeNode)((Object)treeNode3), treeNode3.getChildCount());
                }
            }
        }

        public TreeNode getRootNode() {
            return (TreeNode)this.getModel().getRoot();
        }

        private TreeNode lookupAccountNode(long l) {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbMailAccount dbMailAccount;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 1 || (dbMailAccount = treeNode2.getAccount()) == null || dbMailAccount.id != l) continue;
                return treeNode2;
            }
            return null;
        }

        private TreeNode lookupFolderNode(long l) {
            return this.lookupFolderNode(this.getRootNode(), l);
        }

        private TreeNode lookupFolderNode(TreeNode treeNode, long l) {
            if (treeNode == null) {
                return null;
            }
            DbMailFolder dbMailFolder = treeNode.getFolder();
            if (dbMailFolder != null && dbMailFolder.id == l) {
                return treeNode;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                TreeNode treeNode3 = this.lookupFolderNode(treeNode2, l);
                if (treeNode3 == null) continue;
                return treeNode3;
            }
            return null;
        }

        public boolean removeFolder(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid folder-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getRootNode();
            if (treeNode == null) {
                return false;
            }
            TreeNode treeNode2 = this.lookupFolderNode(treeNode, l);
            if (treeNode2 != null) {
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }
    }

    private static class MailListener
    extends MailHandlerAdapter {
        private MailListener() {
        }

        @Override
        public void accountsWereLoaded() {
            if (currentSidebarTree == null) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    currentSidebarTree.setModel(MailFrameSidebarExtension.createTreeModel());
                    MailFrameSidebarExtension.expandAccountNodes(currentSidebarTree);
                    currentSidebarTree.repaint();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        @Override
        public void accountsWereUnloaded() {
            if (currentSidebarTree == null) {
                return;
            }
            TreeNode treeNode = new TreeNode();
            currentSidebarTree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode)));
            currentSidebarTree.expandPath(new TreePath(treeNode));
        }

        @Override
        public void folderWasAdded(final DbMailFolder dbMailFolder) {
            if (currentSidebarTree == null || dbMailFolder == null) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TreeNode treeNode = currentSidebarTree.lookupFolderNode(dbMailFolder.parentFolderId);
                        if (treeNode != null) {
                            MailFrameSidebarExtension.addFolderNode(dbMailFolder, treeNode, false);
                            ((DefaultTreeModel)currentSidebarTree.getModel()).nodeStructureChanged((javax.swing.tree.TreeNode)((Object)treeNode));
                            currentSidebarTree.expandPath(new TreePath(treeNode.getPath()));
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't add folder into tree!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void folderWasMoved(final DbMailFolder dbMailFolder, long l, final long l2) {
            if (currentSidebarTree == null || dbMailFolder == null || l < 1L || l2 < 1L) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        currentSidebarTree.removeFolder(dbMailFolder.id);
                        TreeNode treeNode = currentSidebarTree.lookupFolderNode(l2);
                        if (treeNode != null) {
                            MailFrameSidebarExtension.addFolderNode(dbMailFolder, treeNode, false);
                            ((DefaultTreeModel)currentSidebarTree.getModel()).nodeStructureChanged((javax.swing.tree.TreeNode)((Object)treeNode));
                            currentSidebarTree.expandPath(new TreePath(treeNode.getPath()));
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update tree!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void folderWasRemoved(final long l) {
            if (currentSidebarTree == null || l < 1L) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        currentSidebarTree.removeFolder(l);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't add folder into tree!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void folderWasUpdated(DbMailFolder dbMailFolder) {
            if (currentSidebarTree == null || dbMailFolder == null) {
                return;
            }
            this.updateFolderNode(dbMailFolder.id);
        }

        @Override
        public void messageMarkedSeen(DbMailMessage dbMailMessage) {
            if (currentSidebarTree == null || dbMailMessage == null) {
                return;
            }
            this.updateFolderNode(dbMailMessage.folderId);
        }

        @Override
        public void messageWasMoved(DbMailMessage dbMailMessage, final long l, final long l2) {
            if (currentSidebarTree == null || dbMailMessage == null || l < 1L || l2 < 1L) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TreeNode treeNode;
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)currentSidebarTree.getModel();
                        TreeNode treeNode2 = currentSidebarTree.lookupFolderNode(l);
                        if (treeNode2 != null) {
                            treeNode2.update();
                            defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                        }
                        if ((treeNode = currentSidebarTree.lookupFolderNode(l2)) != null) {
                            treeNode.update();
                            defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode));
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update folder in tree!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        @Override
        public void messageWasAdded(DbMailMessage dbMailMessage) {
            if (currentSidebarTree == null || dbMailMessage == null || dbMailMessage.isSeen) {
                return;
            }
            this.updateFolderNode(dbMailMessage.folderId);
        }

        @Override
        public void messageWasFound(DbMailMessage dbMailMessage) {
            if (currentSidebarTree == null || dbMailMessage == null || dbMailMessage.isSeen) {
                return;
            }
            this.updateFolderNode(dbMailMessage.folderId);
        }

        @Override
        public void messageWasRemoved(long l, long l2) {
            if (currentSidebarTree == null || l2 < 1L) {
                return;
            }
            this.updateFolderNode(l2);
        }

        @Override
        public void messageWasUpdated(DbMailMessage dbMailMessage) {
            if (currentSidebarTree == null || dbMailMessage == null || dbMailMessage.isSeen) {
                return;
            }
            this.updateFolderNode(dbMailMessage.folderId);
        }

        private void updateFolderNode(final long l) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        TreeNode treeNode = currentSidebarTree.lookupFolderNode(l);
                        treeNode.update();
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)currentSidebarTree.getModel();
                        defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode));
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update folder in tree!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

