/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.extensions.ProjectAdapter;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.extensions.DbMailExtension;
import java.awt.Window;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailProjectExtension
extends ProjectAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailProjectExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailProjectExtension.class);

    public void clean(ImmoToolProject immoToolProject) throws ImmoToolException {
        super.clean(immoToolProject);
    }

    public void close(ImmoToolProject immoToolProject) throws ImmoToolException {
        MailPlugin.stopAutoRetrievalTimer();
        MailPlugin.unloadSettings();
        MailPlugin.setDbMailExtension(null);
        MailPlugin.setMailHandler(null);
        super.close(immoToolProject);
    }

    public void open(ImmoToolProject immoToolProject) throws ImmoToolException {
        this.open(immoToolProject, null);
    }

    public void open(ImmoToolProject immoToolProject, MailHandler mailHandler) throws ImmoToolException {
        DbMailExtension dbMailExtension = MailPluginUtils.getDbMailExtension(immoToolProject);
        if (dbMailExtension == null) {
            throw new ImmoToolException("Can't find a usable DbMailExtension!");
        }
        MailPlugin.setDbMailExtension(dbMailExtension);
        try {
            MailPlugin.loadSettings(immoToolProject);
        }
        catch (SQLException sQLException) {
            throw new ImmoToolException("Can't load mail settings!", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new ImmoToolException("Can't load mail settings!", (Throwable)iOException);
        }
        MailPlugin.setMailHandler(mailHandler != null ? mailHandler : new MailHandler());
    }

    public void openFinished(final ImmoToolProject immoToolProject) throws ImmoToolException {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<Boolean, Void>("Load mail accounts"){

            protected Boolean doInBackground() throws Exception {
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    MailPlugin.getMailHandler().loadAccounts(immoToolProject, connection);
                    MailPlugin.getMailHandler().loadRemoteAccounts(immoToolProject, connection);
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't load mail accounts!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
            }

            protected void finished() {
                super.finished();
                MailPlugin.createAutoRetrievalTimer();
                MailPlugin.startAutoRetrievalTimer(10000);
            }
        });
    }
}

