/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.extensions.MailHandlerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailHandlerExtension;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class MailViewPanel
extends AbstractMainTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(MailViewPanel.class);
    private Action closeHandler;
    private final transient MailHandlerExtension mailListener = new MailListener();
    private MailViewer mailViewer;
    private JPanel buttonBar;
    private AbstractI18nAction closeAction;
    private JButton actionButton;
    private JButton[] extensionButtons;

    private MailViewPanel() {
        MailPlugin.getMailHandler().addCustomListener(this.mailListener);
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.closeAction = this.createDefaultCloseAction();
        this.actionButton = this.mailViewer.getActionButton();
        this.buttonBar = new ButtonBarBuilder().addRelatedGap().addFixed((JComponent)this.actionButton).addRelatedGap().addFixed((JComponent)new JButton((Action)this.closeAction)).getPanel();
        buttonBarBuilder.addFixed((JComponent)this.buttonBar);
    }

    protected JComponent buildMainComponent() {
        return this.mailViewer;
    }

    public static MailViewPanel createTab() {
        return new MailViewPanel();
    }

    public static MailViewPanel createTab(DbMailMessage dbMailMessage) {
        MailViewPanel mailViewPanel = new MailViewPanel();
        mailViewPanel.setMessage(dbMailMessage);
        return mailViewPanel;
    }

    public void doClose(boolean bl) {
        if (this.closeHandler != null) {
            this.closeHandler.actionPerformed(new ActionEvent((Object)this, 0, "doClose"));
        } else {
            ImmoToolAppUtils.removeTab((Component)((Object)this));
        }
    }

    protected void doLoadInBackground(Connection connection) throws Exception {
        this.mailViewer.doLoadInBackground(connection);
    }

    public void doRefresh() {
        if (this.isLoadedInBackground()) {
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    public DbMailAccount getCurrentAccount() {
        return this.mailViewer != null ? this.mailViewer.getCurrentAccount() : null;
    }

    public long getCurrentAccountId() {
        return this.mailViewer != null ? this.mailViewer.getCurrentAccountId() : 0L;
    }

    public DbMailFolder getCurrentFolder() {
        return this.mailViewer != null ? this.mailViewer.getCurrentFolder() : null;
    }

    public long getCurrentFolderId() {
        return this.mailViewer != null ? this.mailViewer.getCurrentFolderId() : 0L;
    }

    public DbMailMessage getCurrentMessage() {
        return this.mailViewer != null ? this.mailViewer.getCurrentMessage() : null;
    }

    public long getCurrentMessageLocalId() {
        return this.mailViewer != null ? this.mailViewer.getCurrentMessageLocalId() : 0L;
    }

    protected Icon getHeaderIcon() {
        return MailPlugin.getResourceIcon("mail_generic.png", 32);
    }

    protected String getHeaderTitle() {
        DbMailAccount dbMailAccount = this.getCurrentAccount();
        DbMailFolder dbMailFolder = this.getCurrentFolder();
        String string = StringUtils.capitalize((String)I18N.tr("e-mail"));
        if (dbMailAccount != null) {
            string = string + " | " + dbMailAccount.writeName();
        }
        if (dbMailFolder != null) {
            string = string + " | " + dbMailFolder.name;
        }
        return string;
    }

    public String getTabTitle() {
        String string = StringUtils.capitalize((String)I18N.tr("e-mail"));
        long l = this.getCurrentMessageLocalId();
        if (l > 0L) {
            string = string + " #" + l;
        }
        return string;
    }

    protected void init() {
        super.init();
        this.mailViewer = new MailViewer();
        this.extensionButtons = null;
    }

    protected boolean isLoadedInBackground() {
        return this.getCurrentMessageLocalId() > 0L;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        boolean bl2 = this.getCurrentMessageLocalId() > 0L;
        this.actionButton.setEnabled(bl && bl2);
        this.closeAction.setEnabled(bl);
        if (!ArrayUtils.isEmpty((Object[])this.extensionButtons)) {
            for (JButton jButton : this.extensionButtons) {
                jButton.setEnabled(bl && bl2);
            }
        }
    }

    public void setCloseHandler(Action action) {
        this.closeHandler = action;
    }

    public void setMessage(DbMailMessage dbMailMessage) {
        this.mailViewer.setMessage(dbMailMessage);
    }

    private void updateHeaderButtons() {
        this.extensionButtons = this.mailViewer.getExtensionButtons();
        this.buttonBar.removeAll();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttonBar);
        if (!ArrayUtils.isEmpty((Object[])this.extensionButtons)) {
            for (JButton jButton : this.extensionButtons) {
                buttonBarBuilder.addRelatedGap();
                buttonBarBuilder.addFixed((JComponent)jButton);
            }
        }
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)this.actionButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
        this.buttonBar.revalidate();
        this.buttonBar.repaint();
    }

    private class MailViewer
    extends com.openindex.openestate.tool.mail.MailViewer {
        private MailViewer() {
        }

        @Override
        protected void doLoadInBackground(Connection connection) throws Exception {
            super.doLoadInBackground(connection);
        }

        @Override
        public void updateMessage() {
            super.updateMessage();
            MailViewPanel.this.updateHeaderButtons();
            MailViewPanel.this.setButtonsEnabled(true);
        }
    }

    private class MailListener
    extends MailHandlerAdapter {
        private MailListener() {
        }

        @Override
        public void messageWasRemoved(long l, long l2) {
            long l3 = MailViewPanel.this.getCurrentMessageLocalId();
            if (!MailViewPanel.this.isEnabled() || l3 < 1L || l < 1L || l3 != l) {
                return;
            }
            MailViewPanel.this.doClose(true);
        }
    }
}

