/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccountHandler;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.db.DbMailUpdateListener;
import com.openindex.openestate.tool.mail.db.hsql.HSqlDbMailAccountHandler;
import com.openindex.openestate.tool.mail.db.hsql.HSqlDbMailMessageHandler;
import com.openindex.openestate.tool.mail.extensions.DbMailAdapter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbMailExtension
extends DbMailAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbMailExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbMailExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/mail/db/hsql/resources/";
    private final DbMailAccountHandler ACCOUNT_HANDLER = new HSqlDbMailAccountHandler();
    private final DbMailMessageHandler MESSAGE_HANDLER = new HSqlDbMailMessageHandler();

    @Override
    public final DbMailAccountHandler getAccountHandler() {
        return this.ACCOUNT_HANDLER;
    }

    @Override
    public final DbMailMessageHandler getMessageHandler() {
        return this.MESSAGE_HANDLER;
    }

    @Override
    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_mails_accounts", "remove_immotool_mails_accounts_settings", "save_immotool_mails_accounts", "save_immotool_mails_accounts_settings", "remove_immotool_mails_addresses", "remove_immotool_mails_folders", "remove_immotool_mails_headers", "remove_immotool_mails_messages", "remove_immotool_mails_parts", "save_immotool_mails_addresses", "save_immotool_mails_folders", "save_immotool_mails_headers", "save_immotool_mails_messages", "save_immotool_mails_parts", "set_immotool_mails_messages_seen"};
    }

    @Override
    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_mails_accounts", "view_immotool_mails_accounts_settings", "view_immotool_mails_addresses", "view_immotool_mails_folders", "view_immotool_mails_headers", "view_immotool_mails_messages", "view_immotool_mails_parts", "view_immotool_mails_parts_content"};
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbMailExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new MailUpdateHandler(string, new DbMailUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbMailExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbMailExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbMailExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbMailExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_mails_accounts");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_mails_accounts");
    }

    private static final class MailUpdateHandler
    extends HSqlDbUpdateHandler {
        public MailUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-Mail", DbUpdateHandlerImpl.Type.PLUGIN, MailPlugin.getInstance().getApiVersion(), string, HSqlDbMailExtension.RESOURCE_PATH, MailPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 9L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_mails_accounts");
            }
            if (l < 9L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_mails_accounts");
            }
        }
    }
}

