/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.io;

import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailPluginUtils;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.sun.mail.imap.IMAPFolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImapIdleStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImapIdleStore.class);
    private static final I18n I18N = I18nFactory.getI18n(ImapIdleStore.class);
    private final long accountId;
    private final Session session;
    private final IdleListener listener;
    private Store store;
    private final List<Long> folderIds;
    private final Map<Long, IdleFolder> idleFolders;

    public ImapIdleStore(Session session, long l, IdleListener idleListener) {
        this.session = session;
        this.accountId = l;
        this.listener = idleListener;
        this.store = null;
        this.folderIds = new ArrayList<Long>();
        this.idleFolders = new HashMap<Long, IdleFolder>();
    }

    public synchronized void addFolder(long l) throws MessagingException {
        if (this.folderIds.contains(l)) {
            return;
        }
        this.folderIds.add(l);
        if (this.isConnected()) {
            if (this.idleFolders.containsKey(l)) {
                return;
            }
            this.connectFolder(l, this.store.getDefaultFolder());
        }
    }

    public synchronized void connect() throws MessagingException {
        if (this.folderIds.isEmpty()) {
            return;
        }
        if (this.store == null) {
            this.store = this.session.getStore();
            this.store.addStoreListener(new StoreListener(){

                public void notification(StoreEvent storeEvent) {
                    if (1 == storeEvent.getMessageType()) {
                        LOGGER.warn("[IMAP-IDLE #" + ImapIdleStore.this.accountId + "]: " + storeEvent.getMessage());
                    } else {
                        LOGGER.debug("[IMAP-IDLE #" + ImapIdleStore.this.accountId + "]: " + storeEvent.getMessage());
                    }
                }
            });
        }
        if (!this.store.isConnected()) {
            this.store.connect();
        }
        Folder folder = this.store.getDefaultFolder();
        for (Long l : this.folderIds) {
            this.connectFolder(l, folder);
        }
    }

    private synchronized void connectFolder(final long l, Folder folder) {
        try {
            DbMailFolder dbMailFolder = MailPlugin.getMailHandler().getFolder(l);
            Folder folder2 = dbMailFolder.parentFolderId > 0L ? MailPluginUtils.getRemoteSubFolder(folder, dbMailFolder.getPath()) : folder;
            folder2.addMessageChangedListener(new MessageChangedListener(){

                public void messageChanged(MessageChangedEvent messageChangedEvent) {
                    try {
                        if (2 == messageChangedEvent.getMessageChangeType()) {
                            ImapIdleStore.this.listener.messageHeadersChanged(messageChangedEvent.getMessage(), l, ImapIdleStore.this.accountId);
                        } else if (1 == messageChangedEvent.getMessageChangeType()) {
                            Message message = messageChangedEvent.getMessage();
                            Flags flags = message.getFlags();
                            if (flags.contains(Flags.Flag.DELETED)) {
                                ImapIdleStore.this.listener.messagesRemoved(new Message[]{message}, l, ImapIdleStore.this.accountId);
                            } else {
                                ImapIdleStore.this.listener.messageFlagsChanged(message, l, ImapIdleStore.this.accountId);
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't handle changed message!");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            });
            folder2.addMessageCountListener(new MessageCountListener(){

                public void messagesAdded(MessageCountEvent messageCountEvent) {
                    try {
                        Object[] objectArray = messageCountEvent.getMessages();
                        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                            ImapIdleStore.this.listener.messagesAdded(messageCountEvent.getMessages(), l, ImapIdleStore.this.accountId);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't handle added messages!");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }

                public void messagesRemoved(MessageCountEvent messageCountEvent) {
                    try {
                        Object[] objectArray = messageCountEvent.getMessages();
                        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                            ImapIdleStore.this.listener.messagesRemoved(messageCountEvent.getMessages(), l, ImapIdleStore.this.accountId);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Can't handle removed messages!");
                        LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            });
            IdleFolder idleFolder = new IdleFolder((IMAPFolder)folder2, dbMailFolder.id, this.accountId, this.listener);
            this.idleFolders.put(l, idleFolder);
            idleFolder.start();
        }
        catch (Exception exception) {
            LOGGER.error("IDLE connection failed!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public boolean containsFolder(long l) {
        return this.folderIds.contains(l);
    }

    public synchronized void disconnect() {
        for (IdleFolder idleFolder : this.idleFolders.values()) {
            idleFolder.stop();
        }
        this.idleFolders.clear();
        MailPluginUtils.closeQuietly(this.store);
    }

    public synchronized boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public void removeFolder(long l) {
        if (!this.folderIds.contains(l)) {
            return;
        }
        this.folderIds.remove(l);
        if (this.isConnected()) {
            if (!this.idleFolders.containsKey(l)) {
                return;
            }
            this.idleFolders.get(l).stop();
            this.idleFolders.remove(l);
        }
    }

    public static interface IdleListener {
        public void idleNotSupported(long var1, long var3);

        public void messageFlagsChanged(Message var1, long var2, long var4);

        public void messageHeadersChanged(Message var1, long var2, long var4);

        public void messagesAdded(Message[] var1, long var2, long var4);

        public void messagesRemoved(Message[] var1, long var2, long var4);
    }

    private static class IdleFolder {
        private final IMAPFolder remoteFolder;
        private final long localFolderId;
        private final long accountId;
        private final IdleListener listener;
        private Thread idleThread;
        private boolean stopped;

        private IdleFolder(IMAPFolder iMAPFolder, long l, long l2, IdleListener idleListener) {
            this.remoteFolder = iMAPFolder;
            this.localFolderId = l;
            this.accountId = l2;
            this.listener = idleListener;
            this.idleThread = null;
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public synchronized void start() {
            this.stopped = false;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!IdleFolder.this.stopped) {
                            if (!IdleFolder.this.remoteFolder.getStore().isConnected()) {
                                LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Connect to store");
                                IdleFolder.this.remoteFolder.getStore().connect();
                            }
                            if (!IdleFolder.this.remoteFolder.isOpen()) {
                                LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Connect to folder '" + IdleFolder.this.remoteFolder.getFullName() + "'");
                                IdleFolder.this.remoteFolder.open(1);
                            }
                            try {
                                LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Idle folder '" + IdleFolder.this.remoteFolder.getFullName() + "'");
                                IdleFolder.this.remoteFolder.idle(false);
                            }
                            catch (FolderClosedException folderClosedException) {
                                LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Disconnected from folder");
                            }
                            catch (StoreClosedException storeClosedException) {
                                LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Disconnected from store");
                            }
                            catch (MessagingException messagingException) {
                                LOGGER.warn("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Idle is not supported");
                                LOGGER.warn("> " + messagingException.getLocalizedMessage(), (Throwable)messagingException);
                                IdleFolder.this.listener.idleNotSupported(IdleFolder.this.localFolderId, IdleFolder.this.accountId);
                                IdleFolder.this.stopped = true;
                            }
                        }
                        LOGGER.info("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] Stopped");
                    }
                    catch (Exception exception) {
                        LOGGER.warn("[IMAP-IDLE #" + IdleFolder.this.accountId + " #" + IdleFolder.this.localFolderId + "] General error");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        IdleFolder.this.stopped = true;
                    }
                }
            };
            this.idleThread = new Thread(runnable, "IMAP-IDLE #" + this.accountId + " #" + this.localFolderId);
            this.idleThread.setDaemon(true);
            this.idleThread.start();
        }

        public synchronized void stop() {
            if (this.idleThread == null) {
                return;
            }
            this.idleThread = null;
            this.stopped = true;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    MailPluginUtils.closeQuietly((Folder)IdleFolder.this.remoteFolder);
                }
            });
            thread.start();
        }
    }
}

