/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.mail.utils;

import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.utils.MailFolderMenuListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MailFolderMenu
extends JMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailFolderMenu.class);
    private static final I18n I18N = I18nFactory.getI18n(MailFolderMenu.class);
    private DbMailFolder folder;
    private List<MailFolderMenuListener> mailFolderMenuListeners;

    public MailFolderMenu(DbMailFolder dbMailFolder) {
        this(dbMailFolder, new ArrayList<MailFolderMenuListener>());
    }

    private MailFolderMenu(DbMailFolder dbMailFolder, List<MailFolderMenuListener> list) {
        this.folder = dbMailFolder;
        this.mailFolderMenuListeners = list;
        if (dbMailFolder != null) {
            this.setText(dbMailFolder.name);
        }
    }

    public void addMailFolderMenuListener(MailFolderMenuListener mailFolderMenuListener) {
        if (!this.mailFolderMenuListeners.contains(mailFolderMenuListener)) {
            this.mailFolderMenuListeners.add(mailFolderMenuListener);
        }
    }

    public DbMailFolder getFolder() {
        return this.folder;
    }

    public void load() throws MessagingException {
        JMenuItem jMenuItem = new JMenuItem("Diesen Ordner w\u00e4hlen");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (MailFolderMenuListener mailFolderMenuListener : MailFolderMenu.this.mailFolderMenuListeners) {
                    mailFolderMenuListener.folderSelected(MailFolderMenu.this.getFolder());
                }
            }
        });
        this.add(jMenuItem);
        if (this.folder.subFolders.isEmpty()) {
            return;
        }
        this.addSeparator();
        for (DbMailFolder dbMailFolder : this.folder.subFolders) {
            MailFolderMenu mailFolderMenu = new MailFolderMenu(dbMailFolder, this.mailFolderMenuListeners);
            mailFolderMenu.load();
            this.add(mailFolderMenu);
        }
    }

    public void removeMailFolderMenuListener(MailFolderMenuListener mailFolderMenuListener) {
        if (this.mailFolderMenuListeners.contains(mailFolderMenuListener)) {
            this.mailFolderMenuListeners.remove(mailFolderMenuListener);
        }
    }
}

