-- -----------------------------------------------------
-- Mail-Addon for OpenEstate-ImmoTool
-- update 4 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'account_type' to 'immotool_mails_accounts'
-- Add field 'account_auto_retrieval' to 'immotool_mails_accounts'
-- Add field 'account_auto_retrieval_interval' to 'immotool_mails_accounts'
-- Add field 'account_auto_retrieval_at' to 'immotool_mails_accounts'
-- Remove field 'account_local' from 'immotool_mails_accounts'
-- Rebuild 'view_immotool_mails_accounts'
-- Rebuild 'save_immotool_mails_accounts'
-- Add field 'folder_holds_messages' to 'immotool_mails_folders'
-- Add field 'folder_holds_folders' to 'immotool_mails_folders'
-- Add field 'folder_auto_retrieval' to 'immotool_mails_folders'
-- Add field 'folder_special_type' to 'immotool_mails_folders'
-- Rebuild 'view_immotool_mails_folders'
-- Rebuild 'save_immotool_mails_folders'
-- Add field 'message_uid_validity' to 'immotool_mails_messages'
-- Add field 'message_mdn_status' to 'immotool_mails_messages'
-- Add field 'message_is_archived' to 'immotool_mails_messages'
-- Update field 'message_size' to 'immotool_mails_messages'
-- Update field 'message_uid' to 'immotool_mails_messages'
-- Update field 'message_mime_id' to 'immotool_mails_messages'
-- Rebuild 'view_immotool_mails_messages'
-- Rebuild 'save_immotool_mails_messages'
-- Add procedure 'set_immotool_mails_messages_answered'
-- Add procedure 'set_immotool_mails_messages_archived'
-- Add procedure 'set_immotool_mails_messages_forwarded'
-- Add procedure 'set_immotool_mails_messages_mdn'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'account_type' to 'immotool_mails_accounts'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_accounts
  ADD COLUMN account_type VARCHAR(50) DEFAULT NULL NULL
  BEFORE account_notes;

UPDATE immotool_mails_accounts
  SET account_type = 'REMOTE'
  WHERE account_local = FALSE;

UPDATE immotool_mails_accounts
  SET account_type = 'LOCAL_PRIVATE'
  WHERE account_local = TRUE;

ALTER TABLE immotool_mails_accounts
  ALTER COLUMN account_type SET DEFAULT NULL;

ALTER TABLE immotool_mails_accounts
  ALTER COLUMN account_type SET NOT NULL;

-- -----------------------------------------------------
-- Add field 'account_auto_retrieval' to 'immotool_mails_accounts'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_accounts
  ADD COLUMN account_auto_retrieval BOOLEAN DEFAULT false NOT NULL
  BEFORE access_owner_id;

-- -----------------------------------------------------
-- Add field 'account_auto_retrieval_interval' to 'immotool_mails_accounts'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_accounts
  ADD COLUMN account_auto_retrieval_interval BIGINT DEFAULT 0 NOT NULL
  BEFORE access_owner_id;

-- -----------------------------------------------------
-- Add field 'account_auto_retrieval_at' to 'immotool_mails_accounts'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_accounts
  ADD COLUMN account_auto_retrieval_at TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL
  BEFORE access_owner_id;

-- -----------------------------------------------------
-- Remove field 'account_local' from 'immotool_mails_accounts'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_mails_accounts;

ALTER VIEW view_immotool_mails_accounts AS
  SELECT account_id FROM immotool_mails_accounts;

ALTER TABLE immotool_mails_accounts
  DROP COLUMN account_local;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_mails_accounts'
-- -----------------------------------------------------
ALTER VIEW view_immotool_mails_accounts AS
  SELECT * FROM immotool_mails_accounts
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

-- -----------------------------------------------------
-- Rebuild 'save_immotool_mails_accounts'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_mails_accounts(
    INOUT val_account_id BIGINT,
    val_account_name VARCHAR(100),
    val_account_type VARCHAR(50),
    val_account_notes LONGVARCHAR,
    val_account_enabled BOOLEAN,
    val_account_auto_retrieval BOOLEAN,
    val_account_auto_retrieval_interval BIGINT,
    val_account_auto_retrieval_at TIMESTAMP WITH TIME ZONE,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_mails_accounts
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neues Mailkonto erzeugen
    IF val_account_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Mailkonto speichern
      INSERT INTO immotool_mails_accounts (
        account_name,
        account_type,
        account_notes,
        account_enabled,
        account_auto_retrieval,
        account_auto_retrieval_interval,
        account_auto_retrieval_at,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_account_name,
        val_account_type,
        val_account_notes,
        val_account_enabled,
        val_account_auto_retrieval,
        val_account_auto_retrieval_interval,
        val_account_auto_retrieval_at,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_account_id = IDENTITY();

    -- Bestehendes Mailkonto bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_mails_accounts
        WHERE account_id = val_account_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Mailkonto bearbeiten
      UPDATE immotool_mails_accounts
        SET
          account_name = val_account_name,
          account_type = val_account_type,
          account_notes = val_account_notes,
          account_enabled = val_account_enabled,
          account_auto_retrieval = val_account_auto_retrieval,
          account_auto_retrieval_interval = val_account_auto_retrieval_interval,
          account_auto_retrieval_at = val_account_auto_retrieval_at,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          account_id = val_account_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_mails_accounts
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add field 'folder_holds_messages' to 'immotool_mails_folders'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_folders
  ADD COLUMN folder_holds_messages BOOLEAN DEFAULT FALSE NOT NULL
  BEFORE created_at;

-- -----------------------------------------------------
-- Add field 'folder_holds_folders' to 'immotool_mails_folders'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_folders
  ADD COLUMN folder_holds_folders BOOLEAN DEFAULT FALSE NOT NULL
  BEFORE created_at;

-- -----------------------------------------------------
-- Add field 'folder_auto_retrieval' to 'immotool_mails_folders'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_folders
  ADD COLUMN folder_auto_retrieval BOOLEAN DEFAULT FALSE NOT NULL
  BEFORE created_at;

-- -----------------------------------------------------
-- Add field 'folder_special_type' to 'immotool_mails_folders'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_folders
  ADD COLUMN folder_special_type VARCHAR(50) DEFAULT NULL NULL
  BEFORE created_at;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_mails_folders'
-- -----------------------------------------------------
ALTER VIEW view_immotool_mails_folders AS
  SELECT * FROM immotool_mails_folders
  WHERE account_id IN (SELECT account_id FROM view_immotool_mails_accounts);

-- -----------------------------------------------------
-- Rebuild 'save_immotool_mails_folders'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_mails_folders;
\.
CREATE PROCEDURE save_immotool_mails_folders(
    INOUT val_folder_id BIGINT,
    val_account_id BIGINT,
    val_folder_parent_id BIGINT,
    val_folder_name VARCHAR(255),
    val_folder_holds_messages BOOLEAN,
    val_folder_holds_folders BOOLEAN,
    val_folder_auto_retrieval BOOLEAN,
    val_folder_special_type VARCHAR(50)
  )
  SPECIFIC save_immotool_mails_folders
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_account_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Ordner erzeugen
    IF val_folder_id < 1 THEN
      -- Ordner speichern
      INSERT INTO immotool_mails_folders (
        account_id,
        folder_parent_id,
        folder_name,
        folder_holds_messages,
        folder_holds_folders,
        folder_auto_retrieval,
        folder_special_type )
      VALUES (
        val_account_id,
        val_folder_parent_id,
        val_folder_name,
        val_folder_holds_messages,
        val_folder_holds_folders,
        val_folder_auto_retrieval,
        val_folder_special_type );

      -- ID zurückliefern
      SET val_folder_id = IDENTITY();

    -- Bestehenden Ordner bearbeiten
    ELSE
      -- Ordner bearbeiten
      UPDATE immotool_mails_folders
        SET
          account_id = val_account_id,
          folder_parent_id = val_folder_parent_id,
          folder_name = val_folder_name,
          folder_holds_messages = val_folder_holds_messages,
          folder_holds_folders = val_folder_holds_folders,
          folder_auto_retrieval = val_folder_auto_retrieval,
          folder_special_type = val_folder_special_type,
          modified_at = NOW()
        WHERE
          folder_id = val_folder_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_mails_folders
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add field 'message_uid_validity' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ADD COLUMN message_uid_validity BIGINT DEFAULT NULL NULL
  BEFORE message_mime_id;

-- -----------------------------------------------------
-- Add field 'message_mdn_status' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ADD COLUMN message_mdn_status VARCHAR(25) DEFAULT NULL NULL
  BEFORE message_sent_at;

-- -----------------------------------------------------
-- Add field 'message_is_archived' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ADD COLUMN message_is_archived BOOLEAN DEFAULT false NOT NULL
  BEFORE message_is_downloaded;

-- -----------------------------------------------------
-- Update field 'message_size' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ALTER COLUMN message_size SET DEFAULT 0;

-- -----------------------------------------------------
-- Update field 'message_uid' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ALTER COLUMN message_uid SET DEFAULT NULL;
ALTER TABLE immotool_mails_messages
  ALTER COLUMN message_uid SET NULL;

-- -----------------------------------------------------
-- Update field 'message_mime_id' to 'immotool_mails_messages'
-- -----------------------------------------------------
ALTER TABLE immotool_mails_messages
  ALTER COLUMN message_mime_id SET DEFAULT NULL;
ALTER TABLE immotool_mails_messages
  ALTER COLUMN message_mime_id SET NULL;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_mails_messages'
-- -----------------------------------------------------
ALTER VIEW view_immotool_mails_messages AS
  SELECT * FROM immotool_mails_messages
  WHERE folder_id IN (SELECT folder_id FROM view_immotool_mails_folders);

-- -----------------------------------------------------
-- Rebuild 'save_immotool_mails_messages'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_mails_messages;
\.
CREATE PROCEDURE save_immotool_mails_messages(
    INOUT val_message_id BIGINT,
    val_folder_id BIGINT,
    val_message_subject VARCHAR(255),
    val_message_from VARCHAR(255),
    val_message_to VARCHAR(255),
    val_message_size BIGINT,
    val_message_uid BIGINT,
    val_message_uid_validity BIGINT,
    val_message_mime_id VARCHAR(255),
    val_message_in_reply_to VARCHAR(255),
    val_message_is_answered BOOLEAN,
    val_message_is_archived BOOLEAN,
    val_message_is_downloaded BOOLEAN,
    val_message_is_draft BOOLEAN,
    val_message_is_flagged BOOLEAN,
    val_message_is_forwarded BOOLEAN,
    val_message_is_seen BOOLEAN,
    val_message_has_attachments BOOLEAN,
    val_message_mdn_status VARCHAR(25),
    val_message_sent_at TIMESTAMP WITH TIME ZONE,
    val_message_received_at TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_folder_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id = val_folder_id;
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neue Mail erzeugen
    IF val_message_id < 1 THEN
      -- Mail speichern
      INSERT INTO immotool_mails_messages (
        folder_id,
        message_subject,
        message_from,
        message_to,
        message_size,
        message_uid,
        message_uid_validity,
        message_mime_id,
        message_in_reply_to,
        message_is_answered,
        message_is_archived,
        message_is_downloaded,
        message_is_draft,
        message_is_flagged,
        message_is_forwarded,
        message_is_seen,
        message_has_attachments,
        message_mdn_status,
        message_sent_at,
        message_received_at )
      VALUES (
        val_folder_id,
        val_message_subject,
        val_message_from,
        val_message_to,
        val_message_size,
        val_message_uid,
        val_message_uid_validity,
        val_message_mime_id,
        val_message_in_reply_to,
        val_message_is_answered,
        val_message_is_archived,
        val_message_is_downloaded,
        val_message_is_draft,
        val_message_is_flagged,
        val_message_is_forwarded,
        val_message_is_seen,
        val_message_has_attachments,
        val_message_mdn_status,
        val_message_sent_at,
        val_message_received_at );

      -- ID zurückliefern
      SET val_message_id = IDENTITY();

    -- Bestehende Mail bearbeiten
    ELSE
      -- Mail bearbeiten
      UPDATE immotool_mails_messages
        SET
          folder_id = val_folder_id,
          message_subject = val_message_subject,
          message_from = val_message_from,
          message_to = val_message_to,
          message_size = val_message_size,
          message_uid = val_message_uid,
          message_uid_validity = val_message_uid_validity,
          message_mime_id = val_message_mime_id,
          message_in_reply_to = val_message_in_reply_to,
          message_is_answered = val_message_is_answered,
          message_is_archived = val_message_is_archived,
          message_is_downloaded = val_message_is_downloaded,
          message_is_draft = val_message_is_draft,
          message_is_flagged = val_message_is_flagged,
          message_is_forwarded = val_message_is_forwarded,
          message_is_seen = val_message_is_seen,
          message_has_attachments = val_message_has_attachments,
          message_mdn_status = val_message_mdn_status,
          message_sent_at = val_message_sent_at,
          message_received_at = val_message_received_at,
          modified_at = NOW()
        WHERE
          message_id = val_message_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_immotool_mails_messages
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add procedure 'set_immotool_mails_messages_answered'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS set_immotool_mails_messages_answered;
\.
CREATE PROCEDURE set_immotool_mails_messages_answered(
    val_message_id BIGINT,
    val_message_is_answered BOOLEAN
  )
  SPECIFIC set_immotool_mails_messages_answered
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id IN (SELECT folder_id FROM immotool_mails_messages WHERE message_id = val_message_id);
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_answered = val_message_is_answered,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE set_immotool_mails_messages_answered
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add procedure 'Procedure set_immotool_mails_messages_archived'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS set_immotool_mails_messages_archived;
\.
CREATE PROCEDURE set_immotool_mails_messages_archived(
    val_message_id BIGINT,
    val_message_is_archived BOOLEAN
  )
  SPECIFIC set_immotool_mails_messages_archived
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id IN (SELECT folder_id FROM immotool_mails_messages WHERE message_id = val_message_id);
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_archived = val_message_is_archived,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE set_immotool_mails_messages_archived
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add procedure 'set_immotool_mails_messages_forwarded'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS set_immotool_mails_messages_forwarded;
\.
CREATE PROCEDURE set_immotool_mails_messages_forwarded(
    val_message_id BIGINT,
    val_message_is_forwarded BOOLEAN
  )
  SPECIFIC set_immotool_mails_messages_forwarded
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id IN (SELECT folder_id FROM immotool_mails_messages WHERE message_id = val_message_id);
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_is_forwarded = val_message_is_forwarded,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE set_immotool_mails_messages_forwarded
  TO "IMMOTOOL";

-- -----------------------------------------------------
-- Add procedure 'set_immotool_mails_messages_mdn'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS set_immotool_mails_messages_mdn;
\.
CREATE PROCEDURE set_immotool_mails_messages_mdn(
    val_message_id BIGINT,
    val_message_mdn_status VARCHAR(25)
  )
  SPECIFIC set_immotool_mails_messages_mdn
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE val_account_id BIGINT;
    DECLARE allowed BOOLEAN;

    IF val_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SELECT account_id
      INTO val_account_id
      FROM immotool_mails_folders
      WHERE folder_id IN (SELECT folder_id FROM immotool_mails_messages WHERE message_id = val_message_id);
    SET allowed = can_write_immotool_mails_accounts( val_account_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Mail bearbeiten
    UPDATE immotool_mails_messages
      SET
        message_mdn_status = val_message_mdn_status,
        modified_at = NOW()
      WHERE
        message_id = val_message_id;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE set_immotool_mails_messages_mdn
  TO "IMMOTOOL";