/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultAddressPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryAddressPanel
extends DefaultAddressPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryAddressPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryAddressPanel.class);
    private String currentEntryLastName = null;
    private String currentEntryTitle = null;
    private Gender currentEntryGender = null;
    private JLabel letterAddressLabel;
    private JComboBox<LetterAddress> letterAddressBox;

    public ContactsEntryAddressPanel() {
        super((AddressImpl)new CompanyAddressImpl());
    }

    public ContactsEntryAddressPanel(int n) {
        super((AddressImpl)new CompanyAddressImpl(), n);
    }

    public ContactsEntryAddressPanel(int n, int n2) {
        super((AddressImpl)new CompanyAddressImpl(), n, n2);
    }

    protected void init() {
        this.registerValidation(this.addressCountryField);
        this.registerValidation((JComponent)this.companyWebsiteField);
        this.registerValidation(this.companyMailField);
        this.registerValidation(this.personMailField);
        this.registerValidation(this.personFirstNameField, new ValidationRule(){

            public boolean isValid(Object object) {
                String string = ContactsEntryAddressPanel.this.companyNameField.getText().trim();
                String string2 = ContactsEntryAddressPanel.this.personLastNameField.getText().trim();
                return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
            }
        });
        this.registerValidation(this.personLastNameField, new ValidationRule(){

            public boolean isValid(Object object) {
                String string = ContactsEntryAddressPanel.this.companyNameField.getText().trim();
                String string2 = ContactsEntryAddressPanel.this.personFirstNameField.getText().trim();
                return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
            }
        });
        this.registerValidation(this.companyNameField, new ValidationRule(){

            public boolean isValid(Object object) {
                String string = ContactsEntryAddressPanel.this.personFirstNameField.getText().trim();
                String string2 = ContactsEntryAddressPanel.this.personLastNameField.getText().trim();
                return string.length() > 0 || string2.length() > 0 || ValidationHandler.NOT_BLANK.isValid(object);
            }
        });
        this.personLastNameField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!ContactsEntryAddressPanel.this.personLastNameField.isEnabled()) {
                    return;
                }
                ContactsEntryAddressPanel.this.updateCurrentLastName(ContactsEntryAddressPanel.this.personLastNameField.getText());
            }
        });
        this.personTitleField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (!ContactsEntryAddressPanel.this.personTitleField.isEnabled()) {
                    return;
                }
                ContactsEntryAddressPanel.this.updateCurrentTitle(ContactsEntryAddressPanel.this.personTitleField.getText());
            }
        });
        this.personGenderField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContactsEntryAddressPanel.this.personGenderField.isEnabled()) {
                    return;
                }
                ContactsEntryAddressPanel.this.updateCurrentGender((Gender)ContactsEntryAddressPanel.this.personGenderField.getSelectedItem());
            }
        });
    }

    public void load(DbContactsEntry dbContactsEntry) {
        this.currentEntryGender = dbContactsEntry != null && dbContactsEntry.address != null ? dbContactsEntry.address.getPersonGender() : null;
        this.currentEntryLastName = dbContactsEntry != null && dbContactsEntry.address != null ? dbContactsEntry.address.getPersonLastName() : "";
        this.currentEntryTitle = dbContactsEntry != null && dbContactsEntry.address != null ? dbContactsEntry.address.getPersonTitle() : "";
        String string = dbContactsEntry != null && dbContactsEntry.id > 0L ? StringUtils.trimToNull((String)dbContactsEntry.getLetterAddress()) : null;
        DbContactsEntry.DefaultLetterAddress defaultLetterAddress = string != null ? DbContactsEntry.DefaultLetterAddress.lookup(string, this.currentEntryLastName, this.currentEntryTitle, this.currentEntryGender) : null;
        this.letterAddressBox.setSelectedIndex(-1);
        this.letterAddressBox.setSelectedItem(defaultLetterAddress != null ? new LetterAddress(defaultLetterAddress) : (string != null ? new LetterAddress(string) : new LetterAddress(DbContactsEntry.DefaultLetterAddress.FORMAL)));
        this.loadAddress((AddressImpl)(dbContactsEntry != null && dbContactsEntry.address != null ? dbContactsEntry.address : new CompanyAddressImpl()));
    }

    protected void preparePersonPanel(DefaultFormBuilder defaultFormBuilder) {
        this.letterAddressLabel = new JLabel();
        this.letterAddressBox = new JComboBox();
        this.letterAddressBox.setEditable(true);
        this.letterAddressBox.setRenderer((ListCellRenderer<LetterAddress>)new DefaultListCellRenderer((Renderer)new LetterAddressRenderer()));
        this.letterAddressBox.setEditor(new LetterAddressEditor());
        for (DbContactsEntry.DefaultLetterAddress defaultLetterAddress : DbContactsEntry.DefaultLetterAddress.values()) {
            this.letterAddressBox.addItem(new LetterAddress(defaultLetterAddress));
        }
        defaultFormBuilder.add((Component)this.letterAddressLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.letterAddressBox).xyw(3, defaultFormBuilder.row(), defaultFormBuilder.getNumberOfColumns() - 2);
    }

    public void save(DbContactsEntry dbContactsEntry) {
        LetterAddress letterAddress;
        if (dbContactsEntry.address == null) {
            dbContactsEntry.address = new CompanyAddressImpl();
        }
        this.saveAddress((AddressImpl)dbContactsEntry.address);
        Object object = this.letterAddressBox.getSelectedItem();
        LetterAddress letterAddress2 = object instanceof String ? new LetterAddress((String)object) : (letterAddress = object instanceof LetterAddress ? (LetterAddress)object : null);
        if (letterAddress != null && letterAddress.defaultLetterAddress != null) {
            dbContactsEntry.setLetterAddress(letterAddress.defaultLetterAddress);
        } else if (letterAddress != null && StringUtils.isNotBlank((CharSequence)letterAddress.customLetterAddress)) {
            dbContactsEntry.setLetterAddress(StringUtils.trimToNull((String)letterAddress.customLetterAddress));
        } else {
            dbContactsEntry.setLetterAddress((String)null);
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.letterAddressBox.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.letterAddressBox.setEnabled(bl);
    }

    private void updateCurrentGender(Gender gender) {
        if (this.currentEntryGender != gender) {
            Object object = this.letterAddressBox.getEditor().getItem();
            this.currentEntryGender = gender;
            this.letterAddressBox.repaint();
            this.letterAddressBox.getEditor().setItem(object);
        }
    }

    private void updateCurrentLastName(String string) {
        if (this.currentEntryLastName == null || !this.currentEntryLastName.equals(string)) {
            Object object = this.letterAddressBox.getEditor().getItem();
            this.currentEntryLastName = StringUtils.trimToEmpty((String)string);
            this.letterAddressBox.repaint();
            this.letterAddressBox.getEditor().setItem(object);
        }
    }

    private void updateCurrentTitle(String string) {
        if (this.currentEntryTitle == null || !this.currentEntryTitle.equals(string)) {
            Object object = this.letterAddressBox.getEditor().getItem();
            this.currentEntryTitle = StringUtils.trimToEmpty((String)string);
            this.letterAddressBox.repaint();
            this.letterAddressBox.getEditor().setItem(object);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.letterAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("letter address")) + ":");
    }

    private final class LetterAddressRenderer
    extends AbstractRenderer<LetterAddress> {
        private LetterAddressRenderer() {
            ContactsEntryAddressPanel.this.setOpaque(true);
        }

        public void render(LetterAddress letterAddress, JLabel jLabel) {
            if (letterAddress != null && letterAddress.defaultLetterAddress != null) {
                jLabel.setText(letterAddress.defaultLetterAddress.write(ContactsEntryAddressPanel.this.currentEntryLastName, ContactsEntryAddressPanel.this.currentEntryTitle, ContactsEntryAddressPanel.this.currentEntryGender));
            } else if (letterAddress != null && StringUtils.isNotBlank((CharSequence)letterAddress.customLetterAddress)) {
                jLabel.setText(DbContactsEntry.writeLetterAddress(letterAddress.customLetterAddress, ContactsEntryAddressPanel.this.currentEntryLastName, ContactsEntryAddressPanel.this.currentEntryTitle, ContactsEntryAddressPanel.this.currentEntryGender));
            } else {
                jLabel.setText("");
            }
        }
    }

    private final class LetterAddressEditor
    implements ComboBoxEditor {
        private final JTextField editor = new JTextField();

        private LetterAddressEditor() {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public Object getItem() {
            String string = this.editor.getText().trim();
            DbContactsEntry.DefaultLetterAddress defaultLetterAddress = DbContactsEntry.DefaultLetterAddress.lookup(string, ContactsEntryAddressPanel.this.currentEntryLastName, ContactsEntryAddressPanel.this.currentEntryTitle, ContactsEntryAddressPanel.this.currentEntryGender);
            return defaultLetterAddress != null ? new LetterAddress(defaultLetterAddress) : new LetterAddress(StringUtils.trimToNull((String)string));
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
        }

        @Override
        public void setItem(Object object) {
            LetterAddress letterAddress = object instanceof DbContactsEntry.DefaultLetterAddress ? new LetterAddress((DbContactsEntry.DefaultLetterAddress)((Object)object)) : (object instanceof LetterAddress ? (LetterAddress)object : null);
            if (letterAddress != null && letterAddress.defaultLetterAddress != null) {
                this.editor.setText(letterAddress.defaultLetterAddress.write(ContactsEntryAddressPanel.this.currentEntryLastName, ContactsEntryAddressPanel.this.currentEntryTitle, ContactsEntryAddressPanel.this.currentEntryGender));
            } else if (letterAddress != null && StringUtils.isNotBlank((CharSequence)letterAddress.customLetterAddress)) {
                this.editor.setText(DbContactsEntry.writeLetterAddress(letterAddress.customLetterAddress, ContactsEntryAddressPanel.this.currentEntryLastName, ContactsEntryAddressPanel.this.currentEntryTitle, ContactsEntryAddressPanel.this.currentEntryGender));
            } else {
                this.editor.setText("");
            }
        }
    }

    private static final class LetterAddress {
        private DbContactsEntry.DefaultLetterAddress defaultLetterAddress;
        private String customLetterAddress;

        private LetterAddress(DbContactsEntry.DefaultLetterAddress defaultLetterAddress) {
            this.defaultLetterAddress = defaultLetterAddress;
        }

        private LetterAddress(String string) {
            this.customLetterAddress = string;
        }
    }
}

