/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryRelationPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.addons.calendar.ContactsCalendarUtils;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarHandler;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsEntryCalendarEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryContactTablePanel
extends CalendarEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryContactTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryContactTablePanel.class);
    private static final String RELATION_TABLE_ID = "CalendarEntryContactTablePanel.RelationTable";
    private DbCalendarEntry currentCalendarEntry = null;
    private JXTitledSeparator formTitle;
    private JTabbedPane tabbedPane;
    private RelationsTab relationsTab;
    private NewEntryTab newEntryTab;

    public CalendarEntryContactTablePanel() {
        this.build();
    }

    private void build() {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.tabbedPane = new JTabbedPane();
        this.relationsTab = (RelationsTab)ImmoToolUtils.addTab((AbstractTab)new RelationsTab(), (JTabbedPane)this.tabbedPane);
        this.newEntryTab = ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT) ? (NewEntryTab)ImmoToolUtils.addTab((AbstractTab)new NewEntryTab(), (JTabbedPane)this.tabbedPane) : null;
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.formTitle, "North");
        this.add(this.tabbedPane, "Center");
        this.updateLocalization();
    }

    private void doEntryAdd() {
        if (this.newEntryTab == null) {
            return;
        }
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        if (!this.newEntryTab.submitNewContact(dbContactsEntry)) {
            return;
        }
        this.newEntryTab.entryAddAction.setEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new EntryAddTask(dbContactsEntry));
    }

    private void doEntryView() {
        int n = this.relationsTab.entriesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.relationsTab.entriesTable.getContactEntryIdAt(this.relationsTab.entriesTable.convertRowIndexToModel(n));
        new ContactsPlugin.EntryFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.relationsTab.entriesTable.setEnabled(false);
        this.relationsTab.entriesTable.clearSelection();
        this.relationsTab.entriesTable.clearRows();
        this.relationsTab.showActionsAction.setEnabled(false);
        ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        HashMap<Long, DbContactsEntryCalendarEntry> hashMap2 = new HashMap<Long, DbContactsEntryCalendarEntry>();
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel2 = new DefaultComboBoxModel<DbContactsGroup>();
        try {
            int dbContactsEntryArray;
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbContactsCalendarHandler dbContactsCalendarHandler = ContactsCalendarUtils.getCalendarHandler();
            defaultComboBoxModel.addElement(null);
            defaultComboBoxModel2.addElement(null);
            DbContactsGroup[] objectArray = dbContactsHandler.getGroups(connection);
            int lArray = objectArray.length;
            for (dbContactsEntryArray = 0; dbContactsEntryArray < lArray; ++dbContactsEntryArray) {
                DbContactsGroup dbContactsGroup = objectArray[dbContactsEntryArray];
                hashMap.put(dbContactsGroup.id, dbContactsGroup.name);
                defaultComboBoxModel.addElement(dbContactsGroup);
                defaultComboBoxModel2.addElement(dbContactsGroup);
            }
            if (this.currentCalendarEntry != null && this.currentCalendarEntry.id > 0L) {
                DbContactsEntryCalendarEntry[] dbContactsEntryCalendarEntryArray = dbContactsCalendarHandler.getEntryCalendarEntries(connection, 0L, this.currentCalendarEntry.id);
                long[] lArray2 = new long[dbContactsEntryCalendarEntryArray.length];
                for (dbContactsEntryArray = 0; dbContactsEntryArray < dbContactsEntryCalendarEntryArray.length; ++dbContactsEntryArray) {
                    lArray2[dbContactsEntryArray] = dbContactsEntryCalendarEntryArray[dbContactsEntryArray].contactsEntryId;
                    hashMap2.put(dbContactsEntryCalendarEntryArray[dbContactsEntryArray].contactsEntryId, dbContactsEntryCalendarEntryArray[dbContactsEntryArray]);
                }
                DbContactsEntry[] dbContactsEntryArray2 = dbContactsHandler.getEntries(connection, lArray2);
                dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray2);
                arrayList.addAll(Arrays.asList(dbContactsEntryArray2));
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(defaultComboBoxModel, defaultComboBoxModel2, arrayList, hashMap, hashMap2){
                final /* synthetic */ DefaultComboBoxModel val$newContactsGroupModel;
                final /* synthetic */ DefaultComboBoxModel val$relationContactsGroupModel;
                final /* synthetic */ List val$entriesList;
                final /* synthetic */ Map val$groupNames;
                final /* synthetic */ Map val$relationsMap;
                {
                    this.val$newContactsGroupModel = defaultComboBoxModel;
                    this.val$relationContactsGroupModel = defaultComboBoxModel2;
                    this.val$entriesList = list;
                    this.val$groupNames = map;
                    this.val$relationsMap = map2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (CalendarEntryContactTablePanel.this.newEntryTab != null) {
                            CalendarEntryContactTablePanel.this.newEntryTab.groupField.setModel(this.val$newContactsGroupModel);
                        }
                        CalendarEntryContactTablePanel.this.relationsTab.relationForm.setContactsGroupsModel(this.val$relationContactsGroupModel);
                        for (DbContactsEntry dbContactsEntry : this.val$entriesList) {
                            String string = (String)this.val$groupNames.get(dbContactsEntry.groupId);
                            String string2 = this.val$relationsMap.containsKey(dbContactsEntry.id) ? ((DbContactsEntryCalendarEntry)this.val$relationsMap.get((Object)Long.valueOf((long)dbContactsEntry.id))).relationNotes : null;
                            CalendarEntryContactTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(dbContactsEntry, string, string2));
                        }
                    }
                    finally {
                        CalendarEntryContactTablePanel.this.relationsTab.entriesTable.setEnabled(true);
                        CalendarEntryContactTablePanel.this.relationsTab.showActionsAction.setEnabled(false);
                        CalendarEntryContactTablePanel.this.relationsTab.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doRefresh() {
        try {
            this.load(this.currentCalendarEntry);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activity contacts!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activity contacts!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationsTab.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.relationsTab.entriesTable.removeSelectedRows()) {
            this.relationsTab.relationForm.unselectRelation();
            this.relationsTab.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.relationsTab.entriesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.add((Action)((Object)new EntryViewAction()));
        Object[] objectArray = this.relationsTab.entriesTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Long[] longArray = null;
            if (longArray == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = this.relationsTab.entriesTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = this.relationsTab.entriesTable.convertRowIndexToModel(n4);
                    arrayList.add(this.relationsTab.entriesTable.getContactEntryIdAt(n5));
                }
                longArray = arrayList.toArray(new Long[arrayList.size()]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    objectArray2 = object.createActionMenuItems(immoToolProject, longArray, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("addresses"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbCalendarEntry dbCalendarEntry) {
        this.currentCalendarEntry = dbCalendarEntry;
        this.relationsTab.relationForm.unselectRelation();
        this.relationsTab.entriesTable.setEnabled(false);
        this.relationsTab.entriesTable.clearSelection();
        this.relationsTab.entriesTable.clearRows();
        this.relationsTab.entriesTable.setEnabled(true);
        this.relationsTab.updateTitle();
    }

    public void save(DbCalendarEntry dbCalendarEntry) {
        this.tabbedPane.setSelectedIndex(0);
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) throws SQLException {
        DbContactsCalendarHandler dbContactsCalendarHandler = ContactsCalendarUtils.getCalendarHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbContactsCalendarHandler.getEntryCalendarEntries(connection, 0L, dbCalendarEntry.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                hashMap.put(((DbContactsEntryCalendarEntry)object).contactsEntryId, object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.relationsTab.entriesTable.getRowCount(); ++i) {
            Object object;
            Long l = this.relationsTab.entriesTable.getContactEntryIdAt(i);
            object = this.relationsTab.entriesTable.getNotesAt(i);
            Serializable serializable = hashMap.containsKey(l) ? (DbContactsEntryCalendarEntry)hashMap.get(l) : new DbContactsEntryCalendarEntry();
            ((DbContactsEntryCalendarEntry)serializable).calendarEntryId = dbCalendarEntry.id;
            ((DbContactsEntryCalendarEntry)serializable).contactsEntryId = l;
            ((DbContactsEntryCalendarEntry)serializable).relationNotes = object;
            dbContactsCalendarHandler.saveEntryCalendarEntry(connection, (DbContactsEntryCalendarEntry)serializable);
            arrayList.add(l);
            hashMap.put(l, serializable);
        }
        for (Serializable serializable : hashMap.keySet().toArray(new Long[0])) {
            if (arrayList.contains(serializable)) continue;
            dbContactsCalendarHandler.removeEntryCalendarEntry(connection, (DbContactsEntryCalendarEntry)hashMap.get(serializable));
            hashMap.remove(serializable);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("addresses for the calendar entry")));
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CalendarEntryContactTablePanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        private RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryContactTablePanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        private RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryContactTablePanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CalendarEntryContactTablePanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryContactTablePanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class EntryViewAction
    extends AbstractI18nAction {
        private EntryViewAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryContactTablePanel.this.doEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the addressbook entry."));
        }
    }

    private class EntryAddTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbContactsEntry newEntry;
        private String contactGroupName = null;

        private EntryAddTask(DbContactsEntry dbContactsEntry) {
            this.newEntry = dbContactsEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            this.contactGroupName = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsHandler.saveEntry(connection, this.newEntry);
                DbContactsGroup dbContactsGroup = dbContactsHandler.getGroup(connection, this.newEntry.groupId);
                if (dbContactsGroup == null) {
                    throw new Exception("Can't find group #" + this.newEntry.groupId + "!");
                }
                this.contactGroupName = dbContactsGroup.name;
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            CalendarEntryContactTablePanel.this.newEntryTab.entryAddAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CalendarEntryContactTablePanel.this.relationsTab.relationForm.unselectRelation();
            CalendarEntryContactTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(this.newEntry, this.contactGroupName, null));
            CalendarEntryContactTablePanel.this.relationsTab.updateTitle();
            CalendarEntryContactTablePanel.this.newEntryTab.clearNewContact();
            CalendarEntryContactTablePanel.this.tabbedPane.setSelectedIndex(0);
        }
    }

    private class EntryAddAction
    extends AbstractI18nAction {
        private EntryAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryContactTablePanel.this.doEntryAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save and assign the new address."));
        }
    }

    public static class RelationTableRow
    extends ContactsEntryTable.Row {
        private String relationNotes;

        public RelationTableRow(DbContactsEntry dbContactsEntry, String string, String string2) {
            super(dbContactsEntry, string);
            this.relationNotes = string2;
        }

        public String getRelationNotes() {
            return this.relationNotes;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof RelationTableColumn) {
                return this.getValueForRelation((RelationTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForRelation(RelationTableColumn relationTableColumn) {
            switch (relationTableColumn) {
                case RELATION_NOTES: {
                    return StringUtils.trimToNull((String)this.relationNotes);
                }
            }
            return null;
        }

        public void setRelationNotes(String string) {
            this.relationNotes = string;
        }
    }

    public static enum RelationTableColumn implements AbstractTable.Column
    {
        RELATION_NOTES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case RELATION_NOTES: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case RELATION_NOTES: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case RELATION_NOTES: {
                    return StringUtils.capitalize((String)I18N.tr("notes"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class RelationTable
    extends ContactsEntryTable<RelationTableRow> {
        private RelationTable() {
            super(CalendarEntryContactTablePanel.RELATION_TABLE_ID);
        }

        protected void doSelect() {
            CalendarEntryContactTablePanel.this.relationsTab.showActionsAction.setEnabled(this.getSelectedColumnCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CalendarEntryContactTablePanel.this.relationsTab.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CalendarEntryContactTablePanel.this.relationsTab.relationForm.selectRelation(this.getContactEntryAt(n), this.getNotesAt(n));
            }
        }

        protected void doShowActions(int n, int n2) {
            CalendarEntryContactTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CalendarEntryContactTablePanel.this.doEntryView();
        }

        public String getNotesAt(int n) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            return relationTableRow != null ? relationTableRow.getRelationNotes() : null;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(RelationTableColumn.values()));
            return list;
        }

        public void setNotesAt(int n, String string) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            if (relationTableRow != null) {
                relationTableRow.setRelationNotes(string);
            }
        }
    }

    private final class RelationForm
    extends ContactsEntryRelationPanel {
        private RelationForm() {
            super(true);
        }

        protected void close() {
            if (CalendarEntryContactTablePanel.this.relationsTab.entriesTable.getSelectedRowCount() > 0) {
                CalendarEntryContactTablePanel.this.relationsTab.entriesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbContactsGroup dbContactsGroup, DbContactsEntry dbContactsEntry, String string) {
            if (dbContactsGroup == null || dbContactsEntry == null) {
                return false;
            }
            CalendarEntryContactTablePanel.this.relationsTab.entriesTable.setEnabled(false);
            try {
                if (this.getCurrentContactEntryId() < 1L) {
                    CalendarEntryContactTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(dbContactsEntry, dbContactsGroup.name, string));
                } else {
                    int n = CalendarEntryContactTablePanel.this.relationsTab.entriesTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CalendarEntryContactTablePanel.this.relationsTab.entriesTable.convertRowIndexToModel(n);
                        CalendarEntryContactTablePanel.this.relationsTab.entriesTable.setRowAt(n2, (AbstractTable.Row)new RelationTableRow(dbContactsEntry, dbContactsGroup.name, string));
                    }
                }
            }
            finally {
                CalendarEntryContactTablePanel.this.relationsTab.entriesTable.clearSelection();
                CalendarEntryContactTablePanel.this.relationsTab.entriesTable.setEnabled(true);
                CalendarEntryContactTablePanel.this.relationsTab.updateTitle();
            }
            return true;
        }
    }

    private final class RelationsTab
    extends AbstractTab {
        private JXTitledSeparator entriesTitle;
        private RelationTable entriesTable;
        private RelationForm relationForm;
        private AbstractI18nAction relationAddAction;
        private AbstractI18nAction refreshAction;
        private AbstractI18nAction showActionsAction;

        private RelationsTab() {
            this.build();
        }

        private void build() {
            this.entriesTable = new RelationTable();
            this.entriesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.showActionsAction = new ShowActionsAction();
            this.relationAddAction = new RelationAddAction();
            this.refreshAction = new RefreshAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.entriesTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
            this.relationForm = new RelationForm();
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.entriesTable.createScrollPane(), "Center");
            this.add((Component)((Object)this.relationForm), "South");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("addresses"));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.updateTitle();
        }

        private void updateTitle() {
            int n;
            String string = StringUtils.capitalize((String)I18N.tr("assigned addresses"));
            int n2 = n = this.entriesTable != null ? this.entriesTable.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.entriesTitle.setTitle(string);
        }
    }

    private final class NewEntryTab
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator formTitle;
        private JLabel groupLabel;
        private JComboBox<DbContactsGroup> groupField;
        private ContactsEntryExtendedAddressPanel addressForm;
        private AbstractI18nAction entryAddAction;

        private NewEntryTab() {
            this.build();
        }

        private void build() {
            this.groupLabel = new JLabel();
            this.groupField = new JComboBox();
            this.groupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select address group") + " ]";
                }
            }));
            this.addressForm = new ContactsEntryExtendedAddressPanel(50);
            this.addressForm.load(new DbContactsEntry());
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule(this.groupField, ValidationHandler.NOT_BLANK);
            this.validationHandler.init();
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.entryAddAction = new EntryAddAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{this.entryAddAction});
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, pref:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.groupField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.addressForm).xyw(1, defaultFormBuilder.nextRow(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        private void clearNewContact() {
            this.addressForm.load(new DbContactsEntry());
            this.groupField.setSelectedItem(null);
            this.validationHandler.init();
            this.addressForm.initInputs();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("new address"));
        }

        private boolean submitNewContact(DbContactsEntry dbContactsEntry) {
            this.validationHandler.validate();
            this.addressForm.validateInputs();
            if (!this.validationHandler.isValid() || !this.addressForm.isValidInput()) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)CalendarEntryContactTablePanel.this.getViewPanel());
                return false;
            }
            this.addressForm.save(dbContactsEntry);
            dbContactsEntry.groupId = ((DbContactsGroup)this.groupField.getSelectedItem()).id;
            return true;
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("create a new address")));
            this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
        }
    }
}

