/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupListCellRenderer;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsEntryDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryDialog.class);
    private ImmoToolTask contactGroupTask = null;
    private boolean submitted = false;
    private JLabel contactGroupLabel;
    private JComboBox<DbContactsGroup> contactGroupField;
    private JXBusyLabel contactGroupBusyField;
    private JLabel contactEntryLabel;
    private ContactsEntryField contactEntryField;
    private JXBusyLabel contactEntryBusyField;
    private CancelAction cancelAction;
    private SubmitAction submitAction;

    private ContactsEntryDialog(Dialog dialog) {
        super(dialog, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private ContactsEntryDialog(Frame frame) {
        super(frame, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        this.cancelAction = new CancelAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{this.cancelAction});
    }

    protected JComponent buildMainComponent() {
        this.contactGroupLabel = new JLabel();
        this.contactGroupField = new JComboBox();
        this.contactGroupField.setRenderer((ListCellRenderer<DbContactsGroup>)((Object)new GroupListCellRenderer(){

            @Override
            public String getEmptyText() {
                return I18N.tr("select address group");
            }
        }));
        this.contactGroupField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbContactsGroup dbContactsGroup = (DbContactsGroup)ContactsEntryDialog.this.contactGroupField.getSelectedItem();
                if (dbContactsGroup == null) {
                    ContactsEntryDialog.this.contactEntryField.setContactsGroupId(0L);
                    ContactsEntryDialog.this.contactEntryField.setEnabled(false);
                } else {
                    ContactsEntryDialog.this.contactEntryField.setContactsGroupId(dbContactsGroup.id);
                    ContactsEntryDialog.this.contactEntryField.setValue(null);
                    ContactsEntryDialog.this.contactEntryField.setEnabled(true);
                }
            }
        });
        this.contactGroupBusyField = new JXBusyLabel();
        this.contactGroupBusyField.setOpaque(false);
        this.contactGroupBusyField.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(this.contactGroupField, "North");
        jPanel.add((Component)this.contactGroupBusyField, "South");
        this.contactEntryLabel = new JLabel();
        this.contactEntryField = new ContactsEntryField();
        this.contactEntryField.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

            public void valueChanged() {
                DbContactsEntry dbContactsEntry = ContactsEntryDialog.this.getSelectedContactsEntry();
                if (dbContactsEntry == null) {
                    ContactsEntryDialog.this.contactEntryField.setToolTipText("");
                } else {
                    ContactsEntryDialog.this.contactEntryField.setToolTipText(dbContactsEntry.writeToolTip());
                }
            }
        });
        this.contactEntryBusyField = new JXBusyLabel();
        this.contactEntryBusyField.setOpaque(false);
        this.contactEntryBusyField.setVisible(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)((Object)this.contactEntryField), "North");
        jPanel2.add((Component)this.contactEntryBusyField, "South");
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 200dlu:grow");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.contactGroupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)jPanel).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactEntryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)jPanel2).xy(3, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    private void doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.contactGroupField != null && this.contactEntryField != null) {
            DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactGroupField.getSelectedItem();
            DbContactsEntry dbContactsEntry = this.contactEntryField.getContactsEntry();
            if (dbContactsGroup == null || dbContactsEntry == null) {
                arrayList.add(I18N.tr("An address must be selected!"));
            }
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), arrayList, (Component)((Object)this));
            return;
        }
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return I18N.tr("Select an address.");
    }

    protected Icon getHeaderIcon() {
        return ContactsPlugin.getResourceIcon("edit_user.png", 32);
    }

    protected String getHeaderTitle() {
        return I18N.tr("Select an address.");
    }

    private DbContactsEntry getSelectedContactsEntry() {
        return this.contactEntryField.getContactsEntry();
    }

    private DbContactsGroup getSelectedContactsGroup() {
        return this.contactGroupField.getSelectedIndex() > 0 ? (DbContactsGroup)this.contactGroupField.getSelectedItem() : null;
    }

    private Result getSelectedResult() {
        return new Result(this.getSelectedContactsEntry(), this.getSelectedContactsGroup());
    }

    private void loadContact(DbContactsEntry dbContactsEntry) {
        if (this.contactGroupField == null || this.contactEntryField == null) {
            return;
        }
        this.contactEntryField.setContactsEntry(dbContactsEntry);
        this.contactGroupField.setSelectedIndex(-1);
        ImmoToolUtils.executeTask((ImmoToolTask)this.reloadContactGroups(dbContactsEntry != null ? dbContactsEntry.groupId : 0L));
    }

    private DefaultComboBoxModel<DbContactsGroup> loadContactGroupModel(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        defaultComboBoxModel.addElement(null);
        for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
            defaultComboBoxModel.addElement(dbContactsGroup);
        }
        return defaultComboBoxModel;
    }

    private ImmoToolTask reloadContactGroups(final long l) {
        final ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        final DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        if (this.contactGroupTask != null) {
            LOGGER.info("cancel running group-task...");
            this.contactGroupTask.cancel(true);
        }
        this.contactGroupField.setEnabled(false);
        this.contactGroupField.setVisible(false);
        this.contactGroupBusyField.setVisible(true);
        this.contactGroupBusyField.setBusy(true);
        this.contactGroupBusyField.setText(I18N.tr("Searching for address groups."));
        this.pack();
        this.contactGroupTask = new ImmoToolTask<DefaultComboBoxModel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected DefaultComboBoxModel doInBackground() throws Exception {
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    DefaultComboBoxModel defaultComboBoxModel = ContactsEntryDialog.this.loadContactGroupModel(connection, dbContactsHandler);
                    ContactsEntryDialog.this.contactGroupBusyField.setText(I18N.tr("Updating selection."));
                    ContactsEntryDialog.this.contactGroupField.setModel(defaultComboBoxModel);
                    DefaultComboBoxModel defaultComboBoxModel2 = defaultComboBoxModel;
                    return defaultComboBoxModel2;
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't load address groups!"), (Throwable)throwable, (Window)((Object)ContactsEntryDialog.this));
            }

            protected void finished() {
                super.finished();
                ContactsEntryDialog.this.contactGroupField.setEnabled(true);
                ContactsEntryDialog.this.contactGroupField.setVisible(true);
                ContactsEntryDialog.this.contactGroupBusyField.setVisible(false);
                ContactsEntryDialog.this.contactGroupBusyField.setBusy(false);
                ContactsEntryDialog.this.contactGroupTask = null;
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                if (l == 0L) {
                    ContactsEntryDialog.this.contactGroupField.setSelectedIndex(0);
                } else if (l > 0L) {
                    ContactsEntryDialog.this.contactGroupField.setSelectedIndex(-1);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        Object e = defaultComboBoxModel.getElementAt(i);
                        if (!(e instanceof DbContactsGroup)) continue;
                        DbContactsGroup dbContactsGroup = (DbContactsGroup)e;
                        if (dbContactsGroup.id != l) continue;
                        ContactsEntryDialog.this.contactGroupField.setSelectedIndex(i);
                        break;
                    }
                }
            }
        };
        return this.contactGroupTask;
    }

    public static Result showDialog(Window window) {
        Result result;
        ContactsEntryDialog contactsEntryDialog = null;
        try {
            contactsEntryDialog = window instanceof Dialog ? new ContactsEntryDialog((Dialog)window) : (window instanceof Frame ? new ContactsEntryDialog((Frame)window) : new ContactsEntryDialog((Frame)null));
            contactsEntryDialog.loadContact(null);
            contactsEntryDialog.setVisible(true);
            result = contactsEntryDialog.submitted ? contactsEntryDialog.getSelectedResult() : null;
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(contactsEntryDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsEntryDialog));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        Result result;
        if (l < 1L) {
            throw new IllegalArgumentException("Invalid entry id provided!");
        }
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        ContactsEntryDialog contactsEntryDialog = null;
        try {
            DbContactsEntry dbContactsEntry;
            contactsEntryDialog = window instanceof Dialog ? new ContactsEntryDialog((Dialog)window) : (window instanceof Frame ? new ContactsEntryDialog((Frame)window) : new ContactsEntryDialog((Frame)null));
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsEntry = dbContactsHandler.getEntry(connection, l);
                if (dbContactsEntry == null) {
                    throw new SQLException("Can't find address entry #" + l + "!");
                }
                dbContactsHandler.loadEntrySettings(connection, dbContactsEntry);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            contactsEntryDialog.loadContact(dbContactsEntry);
            contactsEntryDialog.setVisible(true);
            result = contactsEntryDialog.submitted ? contactsEntryDialog.getSelectedResult() : null;
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(contactsEntryDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsEntryDialog));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result showDialog(DbContactsEntry dbContactsEntry, ImmoToolProject immoToolProject, Window window) {
        Result result;
        if (dbContactsEntry == null) {
            throw new IllegalArgumentException("No address entry provided!");
        }
        ContactsEntryDialog contactsEntryDialog = null;
        try {
            contactsEntryDialog = window instanceof Dialog ? new ContactsEntryDialog((Dialog)window) : (window instanceof Frame ? new ContactsEntryDialog((Frame)window) : new ContactsEntryDialog((Frame)null));
            contactsEntryDialog.loadContact(dbContactsEntry);
            contactsEntryDialog.setVisible(true);
            result = contactsEntryDialog.submitted ? contactsEntryDialog.getSelectedResult() : null;
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(contactsEntryDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsEntryDialog));
        return result;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.contactGroupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
        this.contactEntryLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
    }

    public static final class Result {
        public final DbContactsEntry entry;
        public final DbContactsGroup group;

        private Result(DbContactsEntry dbContactsEntry, DbContactsGroup dbContactsGroup) {
            this.entry = dbContactsEntry;
            this.group = dbContactsGroup;
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }
}

