/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsGroupDialogTab;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsGroupDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsGroupDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsGroupDialog.class);
    private long currentGroupId = 0L;
    private boolean mayEditGroup = false;
    private boolean submitted = false;
    private JTabbedPane tabPanel;
    private GroupTab groupTab;
    private PermissionsTab permissionsTab;
    private SubmitAction submitAction;

    private ContactsGroupDialog(Dialog dialog) {
        super(dialog, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private ContactsGroupDialog(Frame frame) {
        super(frame, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.tabPanel = new JTabbedPane();
        this.groupTab = (GroupTab)ImmoToolUtils.addTab((AbstractTab)new GroupTab(), (JTabbedPane)this.tabPanel);
        this.permissionsTab = null;
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionsTab = (PermissionsTab)ImmoToolUtils.addTab((AbstractTab)new PermissionsTab(), (JTabbedPane)this.tabPanel);
        }
        return this.tabPanel;
    }

    private void doGroupPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.groupTab.textField);
        }
        catch (Exception exception) {
            LOGGER.error("Printing failed!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doSubmit() {
        boolean bl = false;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            ContactsGroupDialogTab contactsGroupDialogTab;
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof ContactsGroupDialogTab) || (contactsGroupDialogTab = (ContactsGroupDialogTab)((Object)component)).hasValidInput()) continue;
            bl = true;
        }
        if (bl) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)((Object)this));
        } else {
            this.submitted = true;
            this.setVisible(false);
        }
    }

    protected String getDialogTitle() {
        if (this.currentGroupId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("edit address group"));
        }
        return StringUtils.capitalize((String)I18N.tr("add address group"));
    }

    protected Icon getHeaderIcon() {
        return ContactsPlugin.getResourceIcon("edit_group.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentGroupId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("address group")) + " #" + this.currentGroupId;
        }
        return StringUtils.capitalize((String)I18N.tr("add address group"));
    }

    private void load(DbContactsGroup dbContactsGroup) {
        this.currentGroupId = dbContactsGroup != null ? dbContactsGroup.id : 0L;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof ContactsGroupDialogTab)) continue;
            ContactsGroupDialogTab contactsGroupDialogTab = (ContactsGroupDialogTab)((Object)component);
            this.tabPanel.setEnabledAt(i, false);
            try {
                contactsGroupDialogTab.load(dbContactsGroup);
                this.tabPanel.setEnabledAt(i, true);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Can't load group into tab '" + contactsGroupDialogTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPermissions(Connection connection, DbExtension dbExtension, DbContactsGroup dbContactsGroup, DbUser dbUser) throws SQLException {
        this.mayEditGroup = ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT);
        if (dbContactsGroup.permission != null) {
            this.mayEditGroup = this.mayEditGroup && dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
        }
        try {
            if (this.permissionsTab != null) {
                this.permissionsTab.loadPermissions(connection, dbExtension, dbContactsGroup, dbUser);
            }
        }
        finally {
            this.submitAction.setEnabled(this.mayEditGroup);
        }
    }

    private void save(DbContactsGroup dbContactsGroup) {
        if (dbContactsGroup == null) {
            throw new IllegalArgumentException("No address group provided!");
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof ContactsGroupDialogTab)) continue;
            ContactsGroupDialogTab contactsGroupDialogTab = (ContactsGroupDialogTab)((Object)component);
            contactsGroupDialogTab.save(dbContactsGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbContactsGroup showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbContactsGroup dbContactsGroup;
        ContactsGroupDialog contactsGroupDialog;
        block7: {
            DbContactsGroup dbContactsGroup2;
            contactsGroupDialog = null;
            try {
                contactsGroupDialog = window instanceof Dialog ? new ContactsGroupDialog((Dialog)window) : (window instanceof Frame ? new ContactsGroupDialog((Frame)window) : new ContactsGroupDialog((Frame)null));
                dbContactsGroup = new DbContactsGroup();
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    contactsGroupDialog.load(dbContactsGroup);
                    contactsGroupDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbContactsGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                contactsGroupDialog.setVisible(true);
                if (contactsGroupDialog.submitted) break block7;
                dbContactsGroup2 = null;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(contactsGroupDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
            return dbContactsGroup2;
        }
        contactsGroupDialog.save(dbContactsGroup);
        DbContactsGroup dbContactsGroup3 = dbContactsGroup;
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
        return dbContactsGroup3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbContactsGroup showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbContactsGroup dbContactsGroup;
        ContactsGroupDialog contactsGroupDialog;
        block9: {
            DbContactsGroup dbContactsGroup2;
            if (l < 1L) {
                return ContactsGroupDialog.showDialog(immoToolProject, window);
            }
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            contactsGroupDialog = null;
            try {
                contactsGroupDialog = window instanceof Dialog ? new ContactsGroupDialog((Dialog)window) : (window instanceof Frame ? new ContactsGroupDialog((Frame)window) : new ContactsGroupDialog((Frame)null));
                dbContactsGroup = null;
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    dbContactsGroup = dbContactsHandler.getGroup(connection, l);
                    if (dbContactsGroup == null) {
                        throw new SQLException("Can't find address group #" + l + "!");
                    }
                    contactsGroupDialog.load(dbContactsGroup);
                    contactsGroupDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbContactsGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                contactsGroupDialog.setVisible(true);
                if (contactsGroupDialog.submitted) break block9;
                dbContactsGroup2 = null;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(contactsGroupDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
            return dbContactsGroup2;
        }
        contactsGroupDialog.save(dbContactsGroup);
        DbContactsGroup dbContactsGroup3 = dbContactsGroup;
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
        return dbContactsGroup3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showDialog(DbContactsGroup dbContactsGroup, ImmoToolProject immoToolProject, Window window) throws SQLException {
        ContactsGroupDialog contactsGroupDialog;
        block8: {
            boolean bl;
            if (dbContactsGroup == null) {
                throw new IllegalArgumentException("No address group provided!");
            }
            contactsGroupDialog = null;
            try {
                contactsGroupDialog = window instanceof Dialog ? new ContactsGroupDialog((Dialog)window) : (window instanceof Frame ? new ContactsGroupDialog((Frame)window) : new ContactsGroupDialog((Frame)null));
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    contactsGroupDialog.load(dbContactsGroup);
                    contactsGroupDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbContactsGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                contactsGroupDialog.setVisible(true);
                if (contactsGroupDialog.submitted) break block8;
                bl = false;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(contactsGroupDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
            return bl;
        }
        contactsGroupDialog.save(dbContactsGroup);
        boolean bl = true;
        ImmoToolUtils.disposeRecursively((Component)((Object)contactsGroupDialog));
        return bl;
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class SubmitAction
    extends AbstractI18nAction {
        public SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsGroupDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class GroupPrintNotesAction
    extends AbstractI18nAction {
        public GroupPrintNotesAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"print.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsGroupDialog.this.doGroupPrintNotes();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("print notes")));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        public CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsGroupDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }

    private static final class PermissionsTab
    extends ContactsGroupDialogTab {
        private ImmoToolPermissionPanel form;

        private PermissionsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel(true);
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        @Override
        public void load(DbContactsGroup dbContactsGroup) {
        }

        public void loadPermissions(Connection connection, DbExtension dbExtension, DbContactsGroup dbContactsGroup, DbUser dbUser) throws SQLException {
            if (dbContactsGroup != null && dbContactsGroup.id > 0L) {
                this.form.setPermission(dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId, dbContactsGroup.permission);
            } else {
                this.form.setPermission(dbUser.id, 0L, null);
            }
            this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
        }

        @Override
        public void save(DbContactsGroup dbContactsGroup) {
            DbGroup dbGroup;
            dbContactsGroup.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbContactsGroup.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbContactsGroup.ownerGroupId = dbGroup.id;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private final class GroupTab
    extends ContactsGroupDialogTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator nameLabel;
        private JTextField nameField;
        private JXTitledSeparator textLabel;
        private DefaultTextArea textField;

        private GroupTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.nameLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.nameField = new JTextField();
            this.textLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.textField = new DefaultTextArea();
            JScrollPane jScrollPane = this.textField.createScrollPane();
            jScrollPane.setPreferredSize(new Dimension(100, 100));
            if (this.textField.getPopupMenu() != null) {
                this.textField.getPopupMenu().add(new JMenuItem((Action)((Object)new GroupPrintNotesAction())));
            }
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule((JComponent)this.nameField, ValidationHandler.NOT_BLANK);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"200dlu:grow");
            defaultFormBuilder.add((Component)this.nameLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.nameField).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)new JLabel("")).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.textLabel).xy(1, defaultFormBuilder.nextRow());
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder((Border)Paddings.DIALOG);
            this.add(defaultFormBuilder.getPanel(), "North");
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("group"));
        }

        @Override
        public boolean hasValidInput() {
            this.validationHandler.validate();
            return this.validationHandler.isValid();
        }

        @Override
        public void load(DbContactsGroup dbContactsGroup) {
            this.nameField.setText(StringUtils.trimToEmpty((String)dbContactsGroup.name));
            this.textField.setText(StringUtils.trimToEmpty((String)dbContactsGroup.notes));
            this.textField.setCaretPosition(0);
            if (dbContactsGroup.id > 0L) {
                this.validationHandler.validate();
            } else {
                this.validationHandler.init();
            }
        }

        @Override
        public void save(DbContactsGroup dbContactsGroup) {
            dbContactsGroup.name = ImmoToolUtils.stripTags((String)this.nameField.getText()).trim();
            dbContactsGroup.notes = ImmoToolUtils.stripTags((String)this.textField.getText()).trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.nameLabel.setTitle(StringUtils.capitalize((String)I18N.tr("title")));
            this.nameField.setToolTipText(I18N.tr("Select a descriptive name for the address group."));
            this.textLabel.setTitle(StringUtils.capitalize((String)I18N.tr("description")));
            this.textField.setToolTipText(I18N.tr("Enter a short description about the address group."));
        }
    }
}

