/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.gui;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GroupListCellRenderer
extends DefaultListCellRenderer<DbContactsGroup> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupListCellRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(GroupListCellRenderer.class);
    private final String emptyText;

    public GroupListCellRenderer() {
        this(null);
    }

    public GroupListCellRenderer(String string) {
        this.emptyText = string;
    }

    public String getEmptyText() {
        return StringUtils.trimToEmpty((String)this.emptyText);
    }

    public Component getRenderedComponent(JList<? extends DbContactsGroup> jList, DbContactsGroup dbContactsGroup, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getRenderedComponent(jList, (Object)dbContactsGroup, n, bl, bl2);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (dbContactsGroup == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + StringEscapeUtils.escapeXml11((String)this.getEmptyText()) + " ]</div></html>");
        } else {
            String string = (dbContactsGroup.notes != null ? dbContactsGroup.notes : "").trim();
            if (string.length() > 50) {
                string = string.substring(0, 50) + "...";
            }
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + dbContactsGroup.id + "</b> | " + StringEscapeUtils.escapeXml11((String)dbContactsGroup.name) + "<br><font size=\"-1\"><i>" + StringEscapeUtils.escapeXml11((String)string) + "</i></font></div></html>");
        }
        return jLabel;
    }

    protected void init() {
        super.init();
        this.setOpaque(true);
    }
}

