/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryExportFields;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.utils.CsvExportTask;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryExportCsvTask
extends CsvExportTask<DbContactsEntry>
implements ContactsEntryExportFields {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryExportCsvTask.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryExportCsvTask.class);
    private final Long groupId;
    private final DbContactsHandler contactsHandler;
    private final Map<Long, String> groupNames;
    private Connection dbConnection = null;

    public ContactsEntryExportCsvTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, Charset charset) {
        this(abstractDbDriver, dbContactsHandler, file, charset, null);
    }

    public ContactsEntryExportCsvTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, Charset charset, Long l) {
        super(file, charset, abstractDbDriver);
        this.setTitle(I18N.tr("Export addresses into a CSV table."));
        this.groupId = l;
        this.contactsHandler = dbContactsHandler;
        this.groupNames = new HashMap<Long, String>();
    }

    protected Long doInBackground() throws Exception {
        this.dbConnection = null;
        try {
            this.dbConnection = this.getDbDriver().getConnection();
            Long l = super.doInBackground();
            return l;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
        }
    }

    protected DbContactsHandler getContactsHandler() {
        return this.contactsHandler;
    }

    protected final String getFieldTitle(int n) {
        switch (n) {
            case 0: {
                return StringUtils.capitalize((String)I18N.tr("ID"));
            }
            case 1: {
                return StringUtils.capitalize((String)I18N.tr("nr"));
            }
            case 2: {
                return StringUtils.capitalize((String)I18N.tr("group"));
            }
            case 3: {
                return StringUtils.capitalize((String)I18N.tr("active"));
            }
            case 4: {
                return StringUtils.capitalize((String)I18N.tr("contacting"));
            }
            case 52: {
                return StringUtils.capitalize((String)I18N.tr("notes"));
            }
            case 8: {
                return StringUtils.capitalize((String)I18N.tr("place"));
            }
            case 9: {
                return StringUtils.capitalize((String)I18N.tr("district"));
            }
            case 10: {
                return StringUtils.capitalize((String)I18N.tr("country"));
            }
            case 12: {
                return StringUtils.capitalize((String)I18N.tr("latitude"));
            }
            case 13: {
                return StringUtils.capitalize((String)I18N.tr("longitude"));
            }
            case 7: {
                return StringUtils.capitalize((String)I18N.tr("postcode"));
            }
            case 11: {
                return StringUtils.capitalize((String)I18N.tr("region"));
            }
            case 5: {
                return StringUtils.capitalize((String)I18N.tr("street"));
            }
            case 6: {
                return StringUtils.capitalize((String)I18N.tr("street-nr"));
            }
            case 22: {
                return StringUtils.capitalize((String)I18N.tr("fax")) + " (" + I18N.tr("personal") + ")";
            }
            case 16: {
                return StringUtils.capitalize((String)I18N.tr("first name"));
            }
            case 17: {
                return StringUtils.capitalize((String)I18N.tr("gender"));
            }
            case 14: {
                return StringUtils.capitalize((String)I18N.tr("last name"));
            }
            case 23: {
                return StringUtils.capitalize((String)I18N.tr("letter address"));
            }
            case 19: {
                return StringUtils.capitalize((String)I18N.tr("e-mail")) + " (" + I18N.tr("personal") + ")";
            }
            case 15: {
                return StringUtils.capitalize((String)I18N.tr("middle name"));
            }
            case 21: {
                return StringUtils.capitalize((String)I18N.tr("mobile")) + " (" + I18N.tr("personal") + ")";
            }
            case 20: {
                return StringUtils.capitalize((String)I18N.tr("phone")) + " (" + I18N.tr("personal") + ")";
            }
            case 18: {
                return StringUtils.capitalize((String)I18N.tr("title"));
            }
            case 34: {
                return StringUtils.capitalize((String)I18N.tr("branch"));
            }
            case 27: {
                return StringUtils.capitalize((String)I18N.tr("department"));
            }
            case 32: {
                return StringUtils.capitalize((String)I18N.tr("fax")) + " (" + I18N.tr("company") + ")";
            }
            case 29: {
                return StringUtils.capitalize((String)I18N.tr("e-mail")) + " (" + I18N.tr("company") + ")";
            }
            case 31: {
                return StringUtils.capitalize((String)I18N.tr("mobile")) + " (" + I18N.tr("company") + ")";
            }
            case 24: {
                return StringUtils.capitalize((String)I18N.tr("company"));
            }
            case 25: {
                return StringUtils.capitalize((String)I18N.tr("company (addition)"));
            }
            case 30: {
                return StringUtils.capitalize((String)I18N.tr("phone")) + " (" + I18N.tr("company") + ")";
            }
            case 28: {
                return StringUtils.capitalize((String)I18N.tr("position"));
            }
            case 26: {
                return StringUtils.capitalize((String)I18N.tr("legal form"));
            }
            case 33: {
                return StringUtils.capitalize((String)I18N.tr("website"));
            }
            case 35: {
                return StringUtils.capitalize((String)I18N.tr("birthday"));
            }
            case 36: {
                return StringUtils.capitalize((String)I18N.tr("birthplace"));
            }
            case 37: {
                return StringUtils.capitalize((String)I18N.tr("citizenship"));
            }
            case 38: {
                return StringUtils.capitalize((String)I18N.tr("languages"));
            }
            case 39: {
                return I18N.tr("bank account owner");
            }
            case 40: {
                return I18N.tr("bank institute");
            }
            case 41: {
                return I18N.tr("bank account nr");
            }
            case 42: {
                return I18N.tr("bank nr");
            }
            case 43: {
                return I18N.tr("bank account IBAN");
            }
            case 44: {
                return I18N.tr("bank account BIC");
            }
            case 45: {
                return StringUtils.capitalize((String)I18N.tr("tax nr"));
            }
            case 46: {
                return StringUtils.capitalize((String)I18N.tr("tax ID nr"));
            }
            case 47: {
                return StringUtils.capitalize((String)I18N.tr("sales tax ID nr"));
            }
            case 48: {
                return StringUtils.capitalize((String)I18N.tr("economy ID nr"));
            }
            case 49: {
                return I18N.tr("ID-card nr");
            }
            case 50: {
                return I18N.tr("ID-card type");
            }
            case 51: {
                return I18N.tr("ID-card issuer");
            }
        }
        return null;
    }

    protected DbContactsEntry[] loadCsvObjects() throws SQLException {
        this.setMessage(I18N.tr("Looking up addresses."));
        DbContactsEntry[] dbContactsEntryArray = this.loadCsvObjects(this.dbConnection, this.getContactsHandler());
        this.getContactsHandler().loadEntrySettings(this.dbConnection, dbContactsEntryArray);
        this.groupNames.clear();
        for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
            if (this.groupNames.containsKey(dbContactsEntry.groupId)) continue;
            this.groupNames.put(dbContactsEntry.groupId, null);
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])this.groupNames.keySet().toArray(new Long[0]));
        for (DbContactsGroup dbContactsGroup : this.getContactsHandler().getGroups(this.dbConnection, lArray)) {
            this.groupNames.put(dbContactsGroup.id, dbContactsGroup.name);
        }
        return dbContactsEntryArray;
    }

    protected DbContactsEntry[] loadCsvObjects(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        if (this.groupId != null && this.groupId > 0L) {
            return dbContactsHandler.getGroupEntries(connection, this.groupId);
        }
        return dbContactsHandler.getEntries(connection);
    }

    protected String[] loadEmptyContainer() {
        return new String[53];
    }

    protected void writeValues(DbContactsEntry dbContactsEntry, String[] stringArray) {
        Object object;
        this.writeValue(0, String.valueOf(dbContactsEntry.id), stringArray);
        this.writeValue(1, dbContactsEntry.publicId, stringArray);
        this.writeValue(2, dbContactsEntry.groupId > 0L && this.groupNames.containsKey(dbContactsEntry.groupId) ? this.groupNames.get(dbContactsEntry.groupId) : "", stringArray);
        this.writeValue(3, String.valueOf(dbContactsEntry.isActive), stringArray);
        this.writeValue(4, String.valueOf(dbContactsEntry.isContactAllowed()), stringArray);
        this.writeValue(8, dbContactsEntry.address.getCity(), stringArray);
        this.writeValue(9, dbContactsEntry.address.getDistrict(), stringArray);
        this.writeValue(10, dbContactsEntry.address.getCountry(), stringArray);
        this.writeValue(7, dbContactsEntry.address.getPostalCode(), stringArray);
        this.writeValue(11, dbContactsEntry.address.getRegion(), stringArray);
        this.writeValue(5, dbContactsEntry.address.getStreet(), stringArray);
        this.writeValue(6, dbContactsEntry.address.getStreetNr(), stringArray);
        this.writeValue(22, dbContactsEntry.address.getPersonFax(), stringArray);
        this.writeValue(16, dbContactsEntry.address.getPersonFirstName(), stringArray);
        this.writeValue(14, dbContactsEntry.address.getPersonLastName(), stringArray);
        this.writeValue(23, dbContactsEntry.writeLetterAddress(), stringArray);
        this.writeValue(19, dbContactsEntry.address.getPersonMail(), stringArray);
        this.writeValue(15, dbContactsEntry.address.getPersonMiddleName(), stringArray);
        this.writeValue(21, dbContactsEntry.address.getPersonMobilePhone(), stringArray);
        this.writeValue(20, dbContactsEntry.address.getPersonPhone(), stringArray);
        this.writeValue(18, dbContactsEntry.address.getPersonTitle(), stringArray);
        this.writeValue(34, dbContactsEntry.address.getCompanyBusiness(), stringArray);
        this.writeValue(27, dbContactsEntry.address.getCompanyDepartment(), stringArray);
        this.writeValue(32, dbContactsEntry.address.getCompanyFax(), stringArray);
        this.writeValue(29, dbContactsEntry.address.getCompanyMail(), stringArray);
        this.writeValue(31, dbContactsEntry.address.getCompanyMobilePhone(), stringArray);
        this.writeValue(24, dbContactsEntry.address.getCompanyName(), stringArray);
        this.writeValue(25, dbContactsEntry.address.getCompanyNameAddition(), stringArray);
        this.writeValue(30, dbContactsEntry.address.getCompanyPhone(), stringArray);
        this.writeValue(28, dbContactsEntry.address.getCompanyPosition(), stringArray);
        this.writeValue(26, dbContactsEntry.address.getCompanyLegalForm(), stringArray);
        this.writeValue(51, dbContactsEntry.getIdentificationIssuer(), stringArray);
        this.writeValue(49, dbContactsEntry.getIdentificationNr(), stringArray);
        this.writeValue(37, dbContactsEntry.getCitizenship(), stringArray);
        this.writeValue(44, dbContactsEntry.getBankAccountBIC(), stringArray);
        this.writeValue(42, dbContactsEntry.getBankAccountBankCodeNr(), stringArray);
        this.writeValue(43, dbContactsEntry.getBankAccountIBAN(), stringArray);
        this.writeValue(39, dbContactsEntry.getBankAccountOwner(), stringArray);
        this.writeValue(40, dbContactsEntry.getBankAccountInstitute(), stringArray);
        this.writeValue(41, dbContactsEntry.getBankAccountNr(), stringArray);
        this.writeValue(36, dbContactsEntry.getPlaceOfBirth(), stringArray);
        this.writeValue(46, dbContactsEntry.getTaxIdNr(), stringArray);
        this.writeValue(45, dbContactsEntry.getTaxNr(), stringArray);
        this.writeValue(47, dbContactsEntry.getTaxUID(), stringArray);
        this.writeValue(48, dbContactsEntry.getTaxWirtschaftIdNr(), stringArray);
        String string = dbContactsEntry.getIdentificationType();
        DbContactsEntry.IdentificationType identificationType = DbContactsEntry.IdentificationType.fromValue(string);
        if (identificationType != null) {
            this.writeValue(50, identificationType.getTranslation(), stringArray);
        } else {
            this.writeValue(50, StringUtils.trimToNull((String)string), stringArray);
        }
        BigDecimal bigDecimal = dbContactsEntry.address.getLatitude();
        this.writeValue(12, bigDecimal != null ? bigDecimal.toString() : null, stringArray);
        BigDecimal bigDecimal2 = dbContactsEntry.address.getLongitude();
        this.writeValue(13, bigDecimal2 != null ? bigDecimal2.toString() : null, stringArray);
        Gender gender = dbContactsEntry.address.getPersonGender();
        this.writeValue(17, gender != null ? gender.getTranslation() : null, stringArray);
        URI uRI = dbContactsEntry.address.getCompanyWebsite();
        this.writeValue(33, uRI != null ? uRI.toString() : null, stringArray);
        Date date = dbContactsEntry.birthDay;
        this.writeValue(35, date != null ? DateFormat.getDateInstance().format(date) : null, stringArray);
        Object[] objectArray = dbContactsEntry.getLanguages();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            object = new ArrayList();
            for (Object object2 : objectArray) {
                object.add(((Locale)object2).getLanguage());
            }
            this.writeValue(38, StringUtils.join((Iterable)object, (String)", "), stringArray);
        }
        if (StringUtils.isBlank((CharSequence)(object = dbContactsEntry.notes))) {
            this.writeValue(52, "", stringArray);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                for (Object e : IOUtils.readLines((Reader)new StringReader((String)object))) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("<br/>");
                    }
                    stringBuilder.append(e);
                }
                this.writeValue(52, stringBuilder.toString(), stringArray);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read notes!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.writeValue(52, "", stringArray);
            }
        }
    }
}

