/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.BooleanRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.FormattedDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryTable.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryTable.class);
    private List<EntryTableExtension> addons;

    public ContactsEntryTable(String string) {
        super(string);
    }

    public ContactsEntryTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public EntryTableExtension[] getAddons() {
        return this.addons.toArray(new EntryTableExtension[0]);
    }

    public Long getContactGroupIdAt(int n) {
        DbContactsEntry dbContactsEntry = this.getContactEntryAt(n);
        return dbContactsEntry != null ? dbContactsEntry.groupId : 0L;
    }

    public DbContactsEntry getContactEntryAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getEntry() : null;
    }

    public Long getContactEntryIdAt(int n) {
        DbContactsEntry dbContactsEntry = this.getContactEntryAt(n);
        return dbContactsEntry != null ? dbContactsEntry.id : 0L;
    }

    public int getRowForEntryId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getContactEntryIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.setColumnControlVisible(true);
        super.init();
        this.getColumn(Column.ID).setMaxWidth(75);
        this.setSortOrder(Column.LASTNAME.getColumnId(), SortOrder.ASCENDING);
        this.addons = new ArrayList<EntryTableExtension>();
        try {
            for (EntryTableExtension entryTableExtension : ContactsPluginUtils.getEntryTableExtensions()) {
                this.addons.add(entryTableExtension);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load table extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbContactsEntry entry;
        private final String groupName;

        public Row(DbContactsEntry dbContactsEntry, String string) {
            this.entry = dbContactsEntry;
            this.groupName = string;
        }

        public DbContactsEntry getEntry() {
            return this.entry;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForContact((Column)column);
            }
            return null;
        }

        public Object getValueForContact(Column column) {
            if (this.entry == null) {
                return null;
            }
            CompanyAddressImpl companyAddressImpl = (CompanyAddressImpl)ObjectUtils.defaultIfNull((Object)this.entry.address, (Object)new CompanyAddressImpl());
            switch (column) {
                case ID: {
                    return this.entry.id;
                }
                case PUBLIC_ID: {
                    return StringUtils.trimToNull((String)this.entry.publicId);
                }
                case GROUP_ID: {
                    return this.entry.groupId;
                }
                case GROUP: {
                    return StringUtils.trimToNull((String)this.groupName);
                }
                case STATUS: {
                    return this.entry.writeActive();
                }
                case CONTACTING: {
                    return this.entry.isContactAllowed();
                }
                case DAY_OF_BIRTH: {
                    return this.entry.birthDay != null ? FormattedDate.createDateInstance((Date)this.entry.birthDay, (int)3) : null;
                }
                case POSTALCODE: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getPostalCode());
                }
                case CITY: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getCity());
                }
                case STREET: {
                    return StringUtils.trimToNull((String)companyAddressImpl.writeStreet());
                }
                case REGION: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getRegion());
                }
                case COUNTRY: {
                    return StringUtils.trimToNull((String)companyAddressImpl.writeCountry());
                }
                case FIRSTNAME: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getPersonFirstName());
                }
                case LASTNAME: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getPersonLastName());
                }
                case COMPANY: {
                    return StringUtils.trimToNull((String)companyAddressImpl.getCompanyName());
                }
                case PHONE: {
                    return StringUtils.trimToNull((String)this.entry.writePhones(", "));
                }
                case MOBILE: {
                    return StringUtils.trimToNull((String)this.entry.writeMobilePhones(", "));
                }
                case MAIL: {
                    return StringUtils.trimToNull((String)this.entry.writeMails(", "));
                }
                case LETTER_ADDRESS: {
                    return StringUtils.trimToNull((String)this.entry.writeLetterAddress());
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        PUBLIC_ID,
        LASTNAME,
        FIRSTNAME,
        COMPANY,
        STREET,
        POSTALCODE,
        CITY,
        REGION,
        COUNTRY,
        MAIL,
        PHONE,
        MOBILE,
        DAY_OF_BIRTH,
        LETTER_ADDRESS,
        GROUP,
        GROUP_ID,
        STATUS,
        CONTACTING;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case CONTACTING: {
                    return new DefaultTableCellRenderer((Renderer)new BooleanRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: 
                case GROUP_ID: {
                    return Long.class;
                }
                case DAY_OF_BIRTH: {
                    return Date.class;
                }
                case CONTACTING: {
                    return Boolean.class;
                }
                case PUBLIC_ID: 
                case GROUP: 
                case LASTNAME: 
                case FIRSTNAME: 
                case COMPANY: 
                case STREET: 
                case POSTALCODE: 
                case CITY: 
                case REGION: 
                case COUNTRY: 
                case MAIL: 
                case PHONE: 
                case MOBILE: 
                case LETTER_ADDRESS: 
                case STATUS: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case GROUP_ID: {
                    return StringUtils.capitalize((String)I18N.tr("group-ID"));
                }
                case DAY_OF_BIRTH: {
                    return StringUtils.capitalize((String)I18N.tr("birthday"));
                }
                case PUBLIC_ID: {
                    return StringUtils.capitalize((String)I18N.tr("nr"));
                }
                case GROUP: {
                    return StringUtils.capitalize((String)I18N.tr("group"));
                }
                case LASTNAME: {
                    return StringUtils.capitalize((String)I18N.tr("last name"));
                }
                case FIRSTNAME: {
                    return StringUtils.capitalize((String)I18N.tr("first name"));
                }
                case COMPANY: {
                    return StringUtils.capitalize((String)I18N.tr("company"));
                }
                case STREET: {
                    return StringUtils.capitalize((String)I18N.tr("street"));
                }
                case POSTALCODE: {
                    return StringUtils.capitalize((String)I18N.tr("postcode"));
                }
                case CITY: {
                    return StringUtils.capitalize((String)I18N.tr("place"));
                }
                case REGION: {
                    return StringUtils.capitalize((String)I18N.tr("region"));
                }
                case COUNTRY: {
                    return StringUtils.capitalize((String)I18N.tr("country"));
                }
                case MAIL: {
                    return StringUtils.capitalize((String)I18N.tr("e-mail"));
                }
                case PHONE: {
                    return StringUtils.capitalize((String)I18N.tr("phone"));
                }
                case MOBILE: {
                    return StringUtils.capitalize((String)I18N.tr("mobile"));
                }
                case LETTER_ADDRESS: {
                    return StringUtils.capitalize((String)I18N.tr("letter address"));
                }
                case STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("status"));
                }
                case CONTACTING: {
                    return StringUtils.capitalize((String)I18N.tr("contacting"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case CONTACTING: 
                case ID: 
                case GROUP_ID: 
                case DAY_OF_BIRTH: 
                case PUBLIC_ID: 
                case REGION: 
                case COUNTRY: 
                case LETTER_ADDRESS: {
                    return false;
                }
            }
            return true;
        }
    }
}

