/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsBulkLetterDialog;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.BulkLetterExtension;
import com.openindex.openestate.tool.contacts.extensions.EntryTableAdapter;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryTableBulkLetterExtension
extends EntryTableAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryTableBulkLetterExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryTableBulkLetterExtension.class);

    @Override
    public JMenuItem[] createActionMenuItems(final ImmoToolProject immoToolProject, final Long[] longArray, JComponent jComponent) {
        if (ArrayUtils.isEmpty((Object[])longArray)) {
            return null;
        }
        boolean bl = false;
        try {
            for (BulkLetterExtension object : ContactsPluginUtils.getBulkLetterExtensions()) {
                try {
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load bulk-letter-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load bulk-letter-extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (!bl) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            JMenuItem throwable = new JMenuItem();
            throwable.setText("Serienbrief verfassen");
            throwable.setIcon(ImmoToolEnvironment.getResourceIcon((String)"wizard.png", (int)16));
            arrayList.add(throwable);
            throwable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ContactsEntryTableBulkLetterExtension.this.doSendMailTo(longArray, immoToolProject);
                }
            });
        }
        catch (Throwable throwable) {
            LOGGER.error("Can't load contacts menu!");
            LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new JMenuItem[0]) : null;
    }

    private void doSendMailTo(final Long[] longArray, final ImmoToolProject immoToolProject) {
        final DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        ImmoToolTask<ContactsBulkLetterDialog.Recipient[], Void> immoToolTask = new ImmoToolTask<ContactsBulkLetterDialog.Recipient[], Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected ContactsBulkLetterDialog.Recipient[] doInBackground() throws Exception {
                ArrayList<ContactsBulkLetterDialog.Recipient> arrayList = new ArrayList<ContactsBulkLetterDialog.Recipient>();
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    HashMap<Long, String> hashMap = new HashMap<Long, String>();
                    long[] lArray = ArrayUtils.toPrimitive((Long[])longArray);
                    DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, lArray);
                    dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                    for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
                        Object object;
                        String string = dbContactsEntry.getAddressMail();
                        if (StringUtils.isBlank((CharSequence)string)) {
                            LOGGER.warn("Can't find mail address for contact entry #" + dbContactsEntry.id + "!");
                            continue;
                        }
                        if (!hashMap.containsKey(dbContactsEntry.groupId)) {
                            object = dbContactsHandler.getGroup(connection, dbContactsEntry.groupId);
                            hashMap.put(dbContactsEntry.groupId, object != null ? ((DbContactsGroup)object).name : null);
                        }
                        object = (String)hashMap.get(dbContactsEntry.groupId);
                        arrayList.add(new ContactsBulkLetterDialog.Recipient(dbContactsEntry, (String)object));
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                return arrayList.toArray(new ContactsBulkLetterDialog.Recipient[0]);
            }

            protected void succeeded(ContactsBulkLetterDialog.Recipient[] recipientArray) {
                super.succeeded((Object)recipientArray);
                ContactsBulkLetterDialog.showDialog(recipientArray, (Window)ImmoToolEnvironment.getFrame());
            }
        };
        ImmoToolUtils.executeTask((ImmoToolTask)immoToolTask);
    }
}

