/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryExportCsvTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryExportVcardTask;
import com.openindex.openestate.tool.contacts.ContactsEntryExportXlsTask;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsEntryViewTask;
import com.openindex.openestate.tool.contacts.ContactsGroupChooser;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsEntryLog;
import com.openindex.openestate.tool.contacts.db.DbContactsEntryLogHandler;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.contacts.gui.StatusRenderer;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsEntryTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryTablePanel.class);
    private static final String TABLE_ID = "ContactsEntryTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_PUBLIC_ID = 1;
    private static final int FILTER_COMPANY = 2;
    private static final int FILTER_ADDRESS = 3;
    private static final int FILTER_PERSON = 4;
    private static final int FILTER_CONTACT = 5;
    private static final int FILTER_STATUS = 6;
    private static final int COUNT_FILTERS = 7;
    private DbContactsGroup currentGroup = null;
    private List<String> filterValues;
    private JLabel idLabel;
    private JFormattedTextField idField;
    private JLabel publicIdLabel;
    private JTextField publicIdField;
    private JLabel adressLabel;
    private JTextField adressField;
    private JLabel personNameLabel;
    private JTextField personNameField;
    private JLabel companyNameLabel;
    private JTextField companyNameField;
    private JLabel contactLabel;
    private JTextField contactField;
    private JLabel groupLabel;
    private JComboBox<DbContactsGroup> groupBox;
    private JLabel statusLabel;
    private JComboBox<Boolean> statusBox;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private ContactsEntryTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new EntryAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ContactsPlugin.getResourceIcon("edit_user.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            this.filterValues.add(null);
        }
        this.idLabel = new JLabel();
        this.idField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.idField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!ContactsEntryTablePanel.this.idField.isEnabled()) {
                    return;
                }
                try {
                    ContactsEntryTablePanel.this.idField.commitEdit();
                }
                catch (Exception exception) {
                    ContactsEntryTablePanel.this.idField.setValue(null);
                }
                String string2 = string = ContactsEntryTablePanel.this.idField.isEditValid() ? ContactsEntryTablePanel.this.idField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && ContactsEntryTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(0))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(0, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.publicIdLabel = new JLabel();
        this.publicIdField = new JTextField();
        this.publicIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!ContactsEntryTablePanel.this.publicIdField.isEnabled()) {
                    return;
                }
                String string = ContactsEntryTablePanel.this.publicIdField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && ContactsEntryTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(1))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(1, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.statusLabel = new JLabel();
        this.statusBox = new JComboBox();
        this.statusBox.setRenderer((ListCellRenderer<Boolean>)new DefaultListCellRenderer((Renderer)new StatusRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("search by status") + " ]";
            }
        }));
        this.statusBox.addItem(null);
        this.statusBox.addItem(Boolean.TRUE);
        this.statusBox.addItem(Boolean.FALSE);
        this.statusBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContactsEntryTablePanel.this.statusBox.isEnabled()) {
                    return;
                }
                Boolean bl = (Boolean)ContactsEntryTablePanel.this.statusBox.getSelectedItem();
                if (bl == null && ContactsEntryTablePanel.this.filterValues.get(6) == null) {
                    return;
                }
                if (bl != null && bl.toString().equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(6))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(6, bl != null ? bl.toString() : null);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.groupLabel = new JLabel();
        this.groupBox = new JComboBox();
        this.groupBox.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("search by group") + " ]";
            }
        }));
        this.groupBox.addItem(null);
        this.groupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContactsEntryTablePanel.this.groupBox.isEnabled()) {
                    return;
                }
                DbContactsGroup dbContactsGroup = (DbContactsGroup)ContactsEntryTablePanel.this.groupBox.getSelectedItem();
                if (dbContactsGroup == null) {
                    ContactsEntryTablePanel.this.setGroup(null);
                    ContactsEntryTablePanel.this.doRefresh();
                    return;
                }
                try {
                    ContactsEntryTablePanel.this.setGroup(dbContactsGroup);
                    ContactsEntryTablePanel.this.doRefresh();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't search for group #" + dbContactsGroup.id + "!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    ImmoToolUtils.showMessageErrorDialog((String)("Can't search for group #" + dbContactsGroup.id + "!"), (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
                }
            }
        });
        this.adressLabel = new JLabel();
        this.adressField = new JTextField();
        this.adressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!ContactsEntryTablePanel.this.adressField.isEnabled()) {
                    return;
                }
                String string = ContactsEntryTablePanel.this.adressField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && ContactsEntryTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(3))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(3, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.personNameLabel = new JLabel();
        this.personNameField = new JTextField();
        this.personNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!ContactsEntryTablePanel.this.personNameField.isEnabled()) {
                    return;
                }
                String string = ContactsEntryTablePanel.this.personNameField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && ContactsEntryTablePanel.this.filterValues.get(4) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(4))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(4, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.companyNameLabel = new JLabel();
        this.companyNameField = new JTextField();
        this.companyNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!ContactsEntryTablePanel.this.companyNameField.isEnabled()) {
                    return;
                }
                String string = ContactsEntryTablePanel.this.companyNameField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && ContactsEntryTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(2))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(2, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        this.contactLabel = new JLabel();
        this.contactField = new JTextField();
        this.contactField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!ContactsEntryTablePanel.this.contactField.isEnabled()) {
                    return;
                }
                String string = ContactsEntryTablePanel.this.contactField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && ContactsEntryTablePanel.this.filterValues.get(5) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)ContactsEntryTablePanel.this.filterValues.get(5))) {
                    return;
                }
                ContactsEntryTablePanel.this.filterValues.set(5, string);
                ContactsEntryTablePanel.this.updateFilters(true);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 20dlu:grow, 3dlu, right:pref, 3dlu, 10dlu:grow");
        defaultFormBuilder.add((Component)this.idLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.idField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.companyNameLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.companyNameField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personNameLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.personNameField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.groupLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.groupBox).xy(15, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.publicIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.adressLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.adressField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.contactField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.statusLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.statusBox).xy(15, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static ContactsEntryTablePanel createTab() {
        return new ContactsEntryTablePanel();
    }

    public static ContactsEntryTablePanel createTab(DbContactsGroup dbContactsGroup) {
        ContactsEntryTablePanel contactsEntryTablePanel = new ContactsEntryTablePanel();
        if (dbContactsGroup != null) {
            contactsEntryTablePanel.setGroup(dbContactsGroup);
        }
        return contactsEntryTablePanel;
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(ContactsEntryTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)ContactsEntryTablePanel.this.adressField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 11.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPostalCode())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCity())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getDistrict())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getRegion())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.writeStreet())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(ContactsEntryTable.Row row) {
                String string = StringUtils.trimToNull((String)ContactsEntryTablePanel.this.companyNameField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 12.createPattern((String)this.value);
                }
                CompanyAddressImpl companyAddressImpl = row.getEntry().address;
                return this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCompanyName())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(ContactsEntryTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)ContactsEntryTablePanel.this.contactField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 13.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPersonMail())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getPersonPhone())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getPersonMobilePhone())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCompanyMail())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCompanyPhone())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCompanyMobilePhone())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){

            public boolean include(ContactsEntryTable.Row row) {
                Number number = ContactsEntryTablePanel.this.idField.isEditValid() ? (Number)((Number)ContactsEntryTablePanel.this.idField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getEntry().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(ContactsEntryTable.Row row) {
                String string = StringUtils.trimToNull((String)ContactsEntryTablePanel.this.publicIdField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 15.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)row.getEntry().publicId)).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(ContactsEntryTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)ContactsEntryTablePanel.this.personNameField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 16.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPersonLastName())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getPersonFirstName())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<ContactsEntryTable.Row>(){

            public boolean include(ContactsEntryTable.Row row) {
                Boolean bl = ContactsEntryTablePanel.this.statusBox.getSelectedIndex() > 0 ? (Boolean)ContactsEntryTablePanel.this.statusBox.getSelectedItem() : null;
                return bl == null || bl.equals(row.getEntry().isActive);
            }
        });
        return this.table;
    }

    private void doEntryExport() {
        int n2;
        if (!ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EXPORT)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n2 : this.table.getSelectedRows()) {
            int n3 = this.table.convertRowIndexToModel(n2);
            long l = this.table.getContactEntryIdAt(n3);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Object object = ContactsEntryExportDialog.showDialog((Window)ImmoToolEnvironment.getFrame());
        if (object == null) {
            return;
        }
        if (((ContactsEntryExportDialog.ExportSettings)object).format == null) {
            LOGGER.warn("Empty export format!");
            return;
        }
        File file = ContactsPlugin.getLastExportLocation();
        JFileChooser jFileChooser = new JFileChooser();
        if (file == null) {
            jFileChooser.setSelectedFile(new File(((ContactsEntryExportDialog.ExportSettings)object).getDefaultFileName()));
        } else {
            jFileChooser.setSelectedFile(new File(file.getAbsolutePath() + File.separator + ((ContactsEntryExportDialog.ExportSettings)object).getDefaultFileName()));
        }
        jFileChooser.setFileFilter(((ContactsEntryExportDialog.ExportSettings)object).getFileFilter());
        n2 = jFileChooser.showSaveDialog((Component)((Object)this));
        if (n2 != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        ContactsPlugin.setLastExportLocation(file2.getAbsoluteFile().getParentFile());
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        if (ContactsEntryExportDialog.Format.CSV.equals((Object)((ContactsEntryExportDialog.ExportSettings)object).format)) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryExportToCsvTask(lArray, immoToolProject.getDbDriver(), dbContactsHandler, file2, (ContactsEntryExportDialog.ExportSettings)object));
        } else if (ContactsEntryExportDialog.Format.XLS.equals((Object)((ContactsEntryExportDialog.ExportSettings)object).format)) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryExportToXlsTask(lArray, immoToolProject.getDbDriver(), dbContactsHandler, file2, (ContactsEntryExportDialog.ExportSettings)object));
        } else if (ContactsEntryExportDialog.Format.VCARD.equals((Object)((ContactsEntryExportDialog.ExportSettings)object).format)) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryExportToVcardTask(lArray, immoToolProject.getDbDriver(), dbContactsHandler, file2, (ContactsEntryExportDialog.ExportSettings)object));
        } else {
            LOGGER.warn("Unsupported export format: \"" + (Object)((Object)((ContactsEntryExportDialog.ExportSettings)object).format) + "\"!");
        }
    }

    private void doEntryRemove() {
        if (!ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_REMOVE)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getContactEntryIdAt(n2);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected addresses?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new EntryRemoveTask(lArray));
    }

    private void doEntrySetGroup() {
        DbContactsGroup dbContactsGroup;
        Object exception;
        if (!ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT_GROUP)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getContactEntryIdAt(n2);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        try {
            exception = I18N.tr("Please select a group, that you want to assign to the selected addresses.");
            dbContactsGroup = ContactsGroupChooser.showDialog(ImmoToolProject.getAppInstance(), (String)exception, true, false, (Window)ImmoToolEnvironment.getFrame());
        }
        catch (Exception exception2) {
            LOGGER.error("Can't load address group dialog!");
            LOGGER.error("> " + exception2.getLocalizedMessage(), (Throwable)exception2);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load address group dialog!", (Component)((Object)this));
            return;
        }
        if (dbContactsGroup == null) {
            return;
        }
        this.setButtonsEnabled(false);
        exception = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new EntrySetGroupTask((long[])exception, dbContactsGroup.id));
    }

    private void doEntrySetStatus(boolean bl) {
        if (!ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            long l = this.table.getContactEntryIdAt(n2);
            if (l <= 0L) continue;
            arrayList.add(l);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new EntrySetStatusTask(lArray, bl));
    }

    private void doEntryView() {
        if (!ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            long l = this.table.getContactEntryIdAt(n4);
            ImmoToolUtils.executeTask((ImmoToolTask)new ContactsEntryViewTask(immoToolProject.getDbDriver(), l, n == 1));
            if (++n2 >= 10) break;
        }
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"contacts.entries", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        this.updateFilters(false);
        this.groupBox.setEnabled(false);
        this.groupBox.removeAllItems();
        this.groupBox.addItem(null);
        this.groupBox.setSelectedIndex(0);
        ArrayList<DbContactsGroup> arrayList = new ArrayList<DbContactsGroup>();
        ArrayList<DbContactsEntry> arrayList2 = new ArrayList<DbContactsEntry>();
        try {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbContactsGroup[] dbContactsGroupArray = dbContactsHandler.getGroups(connection);
            arrayList.addAll(Arrays.asList(dbContactsGroupArray));
            DbContactsEntry[] dbContactsEntryArray = this.currentGroup != null ? dbContactsHandler.getGroupEntries(connection, this.currentGroup.id) : dbContactsHandler.getEntries(connection);
            dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
            arrayList2.addAll(Arrays.asList(dbContactsEntryArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, arrayList2){
                final /* synthetic */ List val$groupsList;
                final /* synthetic */ List val$entriesList;
                {
                    this.val$groupsList = list;
                    this.val$entriesList = list2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashMap<Long, String> hashMap = new HashMap<Long, String>();
                        TreeMap<String, DbContactsGroup> treeMap = new TreeMap<String, DbContactsGroup>();
                        for (Serializable serializable : this.val$groupsList) {
                            int n = 0;
                            String string = serializable.name;
                            while (treeMap.containsKey(string)) {
                                string = serializable.name + "_" + ++n;
                            }
                            treeMap.put(string, (DbContactsGroup)serializable);
                            hashMap.put(serializable.id, serializable.name);
                        }
                        for (Serializable serializable : treeMap.values()) {
                            ContactsEntryTablePanel.this.groupBox.addItem(serializable);
                            if (ContactsEntryTablePanel.this.currentGroup == null || ((ContactsEntryTablePanel)ContactsEntryTablePanel.this).currentGroup.id <= 0L || ((ContactsEntryTablePanel)ContactsEntryTablePanel.this).currentGroup.id != serializable.id) continue;
                            ContactsEntryTablePanel.this.groupBox.setSelectedIndex(ContactsEntryTablePanel.this.groupBox.getItemCount() - 1);
                        }
                        for (Serializable serializable : this.val$entriesList) {
                            ContactsEntryTablePanel.this.table.addRow(new ContactsEntryTable.Row((DbContactsEntry)serializable, (String)hashMap.get(((DbContactsEntry)serializable).groupId)));
                        }
                    }
                    finally {
                        ContactsEntryTablePanel.this.groupBox.setEnabled(true);
                        ContactsEntryTablePanel.this.table.setEnabled(true);
                        ContactsEntryTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new EntryViewAction()));
        jPopupMenu.add((Action)((Object)new EntryRemoveAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new EntrySetGroupAction()));
        JMenu jMenu = new JMenu(StringUtils.capitalize((String)I18N.tr("change status")));
        jMenu.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
        jMenu.add((Action)((Object)new EntrySetStatusAction(true)));
        jMenu.add((Action)((Object)new EntrySetStatusAction(false)));
        jPopupMenu.add(jMenu);
        jPopupMenu.add((Action)((Object)new EntryExportAction()));
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            arrayList.add(this.table.getContactEntryIdAt(n4));
        }
        Long[] longArray = arrayList.toArray(new Long[0]);
        int n5 = 0;
        for (EntryTableExtension entryTableExtension : this.table.getAddons()) {
            Object[] objectArray = entryTableExtension.createActionMenuItems(ImmoToolProject.getAppInstance(), longArray, (JComponent)((Object)this));
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (n5 == 0) {
                    jPopupMenu.addSeparator();
                    n5 = 1;
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    public long getCurrentGroupId() {
        return this.currentGroup != null ? this.currentGroup.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return ContactsPlugin.getResourceIcon("edit_user.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("my addresses"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("addresses"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of your addressbook entries.");
    }

    protected String getTableTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    public void setGroup(DbContactsGroup dbContactsGroup) {
        this.currentGroup = dbContactsGroup;
    }

    public void unsetGroup() {
        this.currentGroup = null;
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.idLabel.setText(StringUtils.capitalize((String)I18N.tr("ID")) + ":");
        this.idField.setToolTipText(I18N.tr("Filter table by address ID."));
        this.publicIdLabel.setText(StringUtils.capitalize((String)I18N.tr("nr")) + ":");
        this.publicIdField.setToolTipText(I18N.tr("Filter table by address number."));
        this.adressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.adressField.setToolTipText(I18N.tr("Filter table by street / city / postcode."));
        this.personNameLabel.setText(StringUtils.capitalize((String)I18N.tr("person")) + ":");
        this.personNameField.setToolTipText(I18N.tr("Filter table by firstname / lastname."));
        this.companyNameLabel.setText(StringUtils.capitalize((String)I18N.tr("company")) + ":");
        this.companyNameField.setToolTipText(I18N.tr("Filter table by company name."));
        this.contactLabel.setText(StringUtils.capitalize((String)I18N.tr("contact")) + ":");
        this.contactField.setToolTipText(I18N.tr("Filter table by phone / fax / e-mail."));
        this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
        this.groupBox.setToolTipText(I18N.tr("Filter table by address group."));
        this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
        this.statusBox.setToolTipText(I18N.tr("Filter table by address status."));
    }

    private class EntryViewAction
    extends AbstractI18nAction {
        private EntryViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryTablePanel.this.doEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show the selected addresses."));
        }
    }

    private class EntrySetStatusTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] entryIds;
        private final boolean active;

        private EntrySetStatusTask(long[] lArray, boolean bl) {
            this.entryIds = lArray;
            this.active = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbContactsEntryLogHandler dbContactsEntryLogHandler = ContactsPlugin.getDbContactsExtension().getContactsEntryLogHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (long l : this.entryIds) {
                    DbContactsEntry dbContactsEntry = dbContactsHandler.getEntry(connection, l);
                    if (dbContactsEntry.isActive == this.active) continue;
                    this.setMessage("#" + l);
                    dbContactsHandler.setEntryActive(connection, l, this.active);
                    DbContactsEntryLog dbContactsEntryLog = DbContactsEntryLog.create(l, "EDIT", immoToolProject.getUser());
                    dbContactsEntryLog.putChangedActive(dbContactsEntry.isActive, this.active);
                    dbContactsEntryLogHandler.saveLog(connection, dbContactsEntryLog);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change address status!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            ContactsEntryTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ContactsEntryTablePanel.this.doRefresh();
        }
    }

    private class EntrySetStatusAction
    extends AbstractI18nAction {
        private final boolean active;

        private EntrySetStatusAction(boolean bl) {
            this.active = bl;
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryTablePanel.this.doEntrySetStatus(this.active);
        }

        protected void updateLocalization() {
            if (this.active) {
                this.setName(I18N.tr("active"));
            } else {
                this.setName(I18N.tr("inactive"));
            }
            this.setShortDescription(I18N.tr("Change status of the selected addresses."));
        }
    }

    private class EntrySetGroupTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] entryIds;
        private final long groupId;

        private EntrySetGroupTask(long[] lArray, long l) {
            this.entryIds = lArray;
            this.groupId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbContactsEntryLogHandler dbContactsEntryLogHandler = ContactsPlugin.getDbContactsExtension().getContactsEntryLogHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (long l : this.entryIds) {
                    DbContactsEntry dbContactsEntry = dbContactsHandler.getEntry(connection, l);
                    if (dbContactsEntry == null || dbContactsEntry.groupId == this.groupId) continue;
                    dbContactsHandler.setEntryGroup(connection, l, this.groupId);
                    DbContactsEntryLog dbContactsEntryLog = DbContactsEntryLog.create(l, "EDIT", immoToolProject.getUser());
                    dbContactsEntryLog.putChangedGroupId(dbContactsEntry.groupId, this.groupId);
                    dbContactsEntryLogHandler.saveLog(connection, dbContactsEntryLog);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change address group!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            ContactsEntryTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ContactsEntryTablePanel.this.doRefresh();
        }
    }

    private class EntrySetGroupAction
    extends AbstractI18nAction {
        private EntrySetGroupAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon("edit_group.png", 16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT_GROUP));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryTablePanel.this.doEntrySetGroup();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("change group")));
            this.setShortDescription(I18N.tr("Change group of the selected addresses."));
        }
    }

    private class EntryRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] entryIds;

        private EntryRemoveTask(long[] lArray) {
            this.entryIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbContactsHandler.removeEntries(connection, this.entryIds);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            ContactsEntryTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            for (long l : this.entryIds) {
                int n = ContactsEntryTablePanel.this.table.getRowForEntryId(l);
                if (n <= -1) continue;
                ContactsEntryTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class EntryRemoveAction
    extends AbstractI18nAction {
        private EntryRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryTablePanel.this.doEntryRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove address")));
            this.setShortDescription(I18N.tr("Remove the selected addresses."));
        }
    }

    private static final class EntryExportToXlsTask
    extends ContactsEntryExportXlsTask {
        private final long[] entryIds;

        private EntryExportToXlsTask(long[] lArray, AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
            this.entryIds = lArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        @Override
        protected DbContactsEntry[] loadXlsObjects(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
            return dbContactsHandler.getEntries(connection, this.entryIds);
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EntryExportToVcardTask
    extends ContactsEntryExportVcardTask {
        private final long[] entryIds;

        private EntryExportToVcardTask(long[] lArray, AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
            this.entryIds = lArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        @Override
        protected DbContactsEntry[] loadContacts(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
            return dbContactsHandler.getEntries(connection, this.entryIds);
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static final class EntryExportToCsvTask
    extends ContactsEntryExportCsvTask {
        private final long[] entryIds;

        private EntryExportToCsvTask(long[] lArray, AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file, ContactsEntryExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, dbContactsHandler, file, exportSettings.charset, exportSettings.getGroupId());
            this.entryIds = lArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export addresses!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        @Override
        protected DbContactsEntry[] loadCsvObjects(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
            return dbContactsHandler.getEntries(connection, this.entryIds);
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The addresses were successfully exported."), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private class EntryExportAction
    extends AbstractI18nAction {
        private EntryExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EXPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryTablePanel.this.doEntryExport();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save addresses to")));
            this.setShortDescription(I18N.tr("Save the selected addresses to harddisk."));
        }
    }

    private static class EntryAddAction
    extends AbstractI18nAction {
        private EntryAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ContactsPlugin.EntryFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new addressbook entry."));
        }
    }

    private class Table
    extends ContactsEntryTable<ContactsEntryTable.Row> {
        public Table() {
            super(ContactsEntryTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            ContactsEntryTablePanel.this.doEntryRemove();
        }

        protected void doSelect() {
            ContactsEntryTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            ContactsEntryTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            ContactsEntryTablePanel.this.doEntryView();
        }
    }
}

