/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.gui.GroupRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.LastModified;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class CalendarEntryPanel<EntryType extends DbCalendarEntry>
extends CalendarEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryPanel.class);
    private DbCalendarEntry currentCalendarEntry = null;
    private long currentCalendarId = 0L;
    protected final ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    protected final ModificationHandler modificationHandler = ImmoToolUtils.createModificationHandler();
    private JXTitledSeparator formTitle;
    private JLabel summaryLabel;
    private JTextField summaryField;
    private JLabel groupLabel;
    private JComboBox<DbCalendarGroup> groupField;

    protected CalendarEntryPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.summaryLabel = new JLabel();
        this.summaryField = new JTextField();
        this.groupLabel = new JLabel();
        this.groupField = new JComboBox();
        this.groupField.setRenderer((ListCellRenderer<DbCalendarGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select calendar") + " ]";
            }
        }));
        this.validationHandler.putRule((JComponent)this.summaryField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule(this.groupField, (ValidationRule)new NonEmptyComboBoxRule(this.groupField));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.summaryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.summaryField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.groupField).xy(3, defaultFormBuilder.row());
        if (bl) {
            JPanel jPanel = new JPanel();
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.setLayout(new BorderLayout(10, 10));
            jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
            jPanel.add((Component)this.buildEntryPanel(), "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
        } else {
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(10, 10));
            this.add(defaultFormBuilder.getPanel(), "North");
            this.add(this.buildEntryPanel(), "Center");
        }
        this.updateLocalization();
        this.load(null);
    }

    protected abstract JPanel buildEntryPanel();

    public abstract EntryType createEntry();

    public void doLoadInBackground(Connection connection) throws Exception {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
        DbUser dbUser = immoToolProject.getUser();
        final DefaultComboBoxModel<DbCalendarGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbCalendarGroup>();
        defaultComboBoxModel.addElement(null);
        for (DbCalendarGroup dbCalendarGroup : dbCalendarHandler.getGroups(connection)) {
            boolean bl = dbCalendarGroup.permission.canWrite(dbUser, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
            if ((this.currentCalendarId <= 0L || dbCalendarGroup.id != this.currentCalendarId) && !bl) continue;
            defaultComboBoxModel.addElement(dbCalendarGroup);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                CalendarEntryPanel.this.groupField.setEnabled(false);
                try {
                    CalendarEntryPanel.this.groupField.setModel(defaultComboBoxModel);
                    CalendarEntryPanel.this.groupField.setSelectedIndex(0);
                    for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                        DbCalendarGroup dbCalendarGroup = (DbCalendarGroup)defaultComboBoxModel.getElementAt(i);
                        if (dbCalendarGroup == null || dbCalendarGroup.id != CalendarEntryPanel.this.currentCalendarId) continue;
                        CalendarEntryPanel.this.groupField.setSelectedIndex(i);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    CalendarEntryPanel.this.groupField.setEnabled(CalendarEntryPanel.this.currentCalendarEntry == null || ((CalendarEntryPanel)CalendarEntryPanel.this).currentCalendarEntry.id < 1L || CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT_GROUP));
                    throw throwable;
                }
                CalendarEntryPanel.this.groupField.setEnabled(CalendarEntryPanel.this.currentCalendarEntry == null || ((CalendarEntryPanel)CalendarEntryPanel.this).currentCalendarEntry.id < 1L || CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT_GROUP));
            }
        });
    }

    public long getCalendarId() {
        return this.groupField.getSelectedIndex() > 0 ? ((DbCalendarGroup)this.groupField.getSelectedItem()).id : 0L;
    }

    public final boolean isLoadedInBackground() {
        return true;
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbCalendarEntry dbCalendarEntry) {
        this.currentCalendarEntry = dbCalendarEntry;
        this.currentCalendarId = this.currentCalendarEntry != null ? this.currentCalendarEntry.groupId : 0L;
        this.summaryField.setText(this.currentCalendarEntry != null ? StringUtils.trimToEmpty((String)this.currentCalendarEntry.title) : "");
        this.groupField.setEnabled(false);
        this.modificationHandler.clear();
        this.modificationHandler.putValue((JComponent)this.summaryField);
        this.validationHandler.init();
    }

    @Override
    public void save(DbCalendarEntry dbCalendarEntry) {
        dbCalendarEntry.groupId = this.getCalendarId();
        dbCalendarEntry.setTitle(ImmoToolUtils.stripTags((String)this.summaryField.getText()).trim());
        dbCalendarEntry.putProperty((Property)new LastModified(new DateTime((java.util.Date)new Date())));
    }

    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) {
    }

    public void setCalendarId(Long l) {
        if (l == null || l < 1L) {
            this.currentCalendarId = 0L;
            this.groupField.setSelectedIndex(this.groupField.getItemCount() > 0 ? 0 : -1);
        } else {
            this.currentCalendarId = l;
            for (int i = 1; i < this.groupField.getItemCount(); ++i) {
                long l2 = this.groupField.getItemAt((int)i).id;
                if (l2 != l) continue;
                this.groupField.setSelectedIndex(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCalendarGroupsModel(ComboBoxModel<DbCalendarGroup> comboBoxModel) {
        this.groupField.setEnabled(false);
        try {
            if (comboBoxModel != null && comboBoxModel.getSize() > 0) {
                this.groupField.setModel(comboBoxModel);
            } else {
                DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
                defaultComboBoxModel.addElement(null);
                this.groupField.setModel(defaultComboBoxModel);
            }
            this.groupField.setSelectedIndex(0);
            if (this.currentCalendarId > 0L) {
                for (int i = 1; i < this.groupField.getItemCount(); ++i) {
                    long l = this.groupField.getItemAt((int)i).id;
                    if (l != this.currentCalendarId) continue;
                    this.groupField.setSelectedIndex(i);
                    break;
                }
            }
            this.groupField.setEnabled(comboBoxModel != null);
        }
        catch (Throwable throwable) {
            this.groupField.setEnabled(comboBoxModel != null);
            this.validationHandler.validate(this.groupField);
            this.modificationHandler.putValue(this.groupField);
            throw throwable;
        }
        this.validationHandler.validate(this.groupField);
        this.modificationHandler.putValue(this.groupField);
    }

    public void setDate(java.util.Date date) {
    }

    public void setDateInterval(java.util.Date date, java.util.Date date2) {
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general")));
        this.summaryLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
        this.summaryField.setToolTipText(I18N.tr("Enter a title for the calendar entry."));
        this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("calendar")) + ":");
        this.groupField.setToolTipText(I18N.tr("Select a group for this calendar entry."));
    }
}

