/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.sql.Connection;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryRemoveTask
extends ImmoToolTask<Boolean, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryRemoveTask.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryRemoveTask.class);
    private final long[] entryIds;
    private final AbstractDbDriver dbDriver;
    private final DbCalendarHandler calendarHandler;

    public CalendarEntryRemoveTask(AbstractDbDriver abstractDbDriver, DbCalendarHandler dbCalendarHandler, long l) {
        this(abstractDbDriver, dbCalendarHandler, new long[]{l});
    }

    public CalendarEntryRemoveTask(AbstractDbDriver abstractDbDriver, DbCalendarHandler dbCalendarHandler, long[] lArray) {
        super(I18N.tr("Remove calendar entry."));
        this.dbDriver = abstractDbDriver;
        this.calendarHandler = dbCalendarHandler;
        this.entryIds = !ArrayUtils.isEmpty((long[])lArray) ? lArray : new long[]{};
    }

    protected Boolean doInBackground() throws Exception {
        Connection connection = null;
        try {
            connection = this.dbDriver.getConnection();
            this.calendarHandler.removeEntries(connection, this.entryIds);
            Boolean bl = true;
            return bl;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }
}

