/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import com.openindex.openestate.tool.gui.DefaultMenu;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarFrameSidebarExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_EVENT = 4;
    public static final int MENU_ADD_TODO = 5;
    public static final int MENU_ADD_GROUP = 6;
    public static final int MENU_ADD_END = 7;
    public static final int MENU_SELECTION = 8;
    public static final int MENU_ELSE = 9;
    public static final int MENU_ELSE_BEGIN = 10;
    public static final int MENU_ELSE_SYNC = 11;
    public static final int MENU_ELSE_END = 12;
    public static final int MENU_END = 13;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        String string;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbCalendarGroup dbCalendarGroup = treeNode != null ? treeNode.getLocalCalendar() : null;
        long l = dbCalendarGroup != null ? dbCalendarGroup.id : 0L;
        VirtualCalendarExtension virtualCalendarExtension = treeNode != null ? treeNode.getVirtualCalendar() : null;
        Collection collection = CalendarFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, CalendarFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.SidebarRefreshAction())));
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the calendar addon."));
            }
        };
        defaultMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        CalendarFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.EntryFormAction(DbCalendarEntry.Type.VTODO))));
        }
        CalendarFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.EntryFormAction(DbCalendarEntry.Type.VEVENT))));
        }
        CalendarFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT)) {
            if (defaultMenu.getItemCount() > 0) {
                defaultMenu.addSeparator();
            }
            defaultMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarDialogAction())));
        }
        CalendarFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        CalendarFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)defaultMenu);
        }
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        if (treeNode != null && treeNode.getType() == 10) {
            string = dbCalendarGroup != null ? StringUtils.capitalize((String)I18N.tr("calendar")) + " '" + StringUtils.trimToEmpty((String)dbCalendarGroup.name) + "'" : (virtualCalendarExtension != null ? StringUtils.capitalize((String)I18N.tr("calendar")) + " '" + StringUtils.trimToEmpty((String)virtualCalendarExtension.getTitle()) + "'" : StringUtils.capitalize((String)I18N.tr("all calendars")));
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)string, (int)40)));
            if (virtualCalendarExtension != null) {
                jPopupMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarViewAction(virtualCalendarExtension, true))));
            } else {
                jPopupMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarViewAction(l, true))));
            }
            if (l > 0L) {
                if (CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarDialogAction(l))));
                }
                if (CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_REMOVE)) {
                    jPopupMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarRemoveAction(l))));
                }
            }
        }
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)8, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)"", (int)5));
        string = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
                this.setToolTipText(I18N.tr("Further actions in the calendar addon."));
            }
        };
        CalendarFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)10, (SidebarTreeNode)treeNode, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_IMPORT)) {
            string.add(new JMenuItem((Action)((Object)new CalendarPlugin.SyncAction())));
        }
        CalendarFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)11, (SidebarTreeNode)treeNode, (Collection)collection);
        CalendarFrameSidebarExtension.loadMenu((JMenu)((Object)string), (int)12, (SidebarTreeNode)treeNode, (Collection)collection);
        if (string.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)((Object)string));
        }
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)9, (SidebarTreeNode)treeNode, (Collection)collection);
        CalendarFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)13, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode(0))));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModel createTreeModel() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            TreeModel treeModel = CalendarFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbCalendarHandler);
            return treeModel;
        }
        catch (Exception exception) {
            LOGGER.error("Can't load calendars!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            TreeModel treeModel = null;
            return treeModel;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static TreeModel createTreeModel(ImmoToolProject immoToolProject, Connection connection, DbCalendarHandler dbCalendarHandler) throws SQLException {
        TreeNode treeNode = new TreeNode(0);
        TreeNode treeNode2 = new TreeNode(10);
        treeNode.add((MutableTreeNode)((Object)treeNode2));
        for (DbCalendarGroup dbCalendarGroup : dbCalendarHandler.getGroups(connection)) {
            TreeNode treeNode3 = new TreeNode(10, dbCalendarGroup);
            treeNode2.add((MutableTreeNode)((Object)treeNode3));
        }
        for (VirtualCalendarExtension virtualCalendarExtension : CalendarPlugin.getVirtualCalendars()) {
            TreeNode treeNode4 = new TreeNode(10, virtualCalendarExtension);
            treeNode2.add((MutableTreeNode)((Object)treeNode4));
        }
        for (FrameSidebarAddonExtension frameSidebarAddonExtension : CalendarFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, CalendarFrameSidebarExtension.class)) {
            frameSidebarAddonExtension.initTree(connection, (SidebarTreeNode)treeNode);
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode));
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return CalendarPlugin.getResourceIcon("vcalendar.png", 32);
    }

    public JPopupMenu getMenu() {
        return CalendarFrameSidebarExtension.createActionMenu(null);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("calendar"));
    }

    public String getTooltipText() {
        return I18N.tr("Manage events and tasks in your calendars.");
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() throws Exception {
                return CalendarFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandAll();
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            CalendarFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid agency-tree was registered!");
            CalendarFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        CalendarFrameSidebarExtension.setCurrentSidebar(null, null);
    }

    public static class TreeNode
    extends SidebarTreeNode {
        private static final int TYPE_ROOT = 0;
        private static final int TYPE_CALENDAR = 10;
        private int type;
        private DbCalendarGroup localCalendar;
        private VirtualCalendarExtension virtualCalendar;

        private TreeNode(int n) {
            this.type = n;
            this.localCalendar = null;
            this.virtualCalendar = null;
        }

        private TreeNode(int n, DbCalendarGroup dbCalendarGroup) {
            this(n);
            this.localCalendar = dbCalendarGroup;
        }

        private TreeNode(int n, VirtualCalendarExtension virtualCalendarExtension) {
            this(n);
            this.virtualCalendar = virtualCalendarExtension;
        }

        public void doShow(boolean bl) {
            switch (this.getType()) {
                case 10: {
                    if (this.virtualCalendar != null) {
                        new CalendarPlugin.CalendarViewAction(this.virtualCalendar, bl).actionPerformed(null);
                        break;
                    }
                    new CalendarPlugin.CalendarViewAction(this.localCalendar != null ? this.localCalendar.id : 0L, bl).actionPerformed(null);
                    break;
                }
            }
        }

        public DbCalendarGroup getLocalCalendar() {
            return this.localCalendar;
        }

        public JPopupMenu getMenu() {
            return CalendarFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            switch (this.type) {
                case 10: {
                    return this.localCalendar != null ? CalendarPlugin.getResourceIcon("vcalendar.png", 16) : (this.virtualCalendar != null ? this.virtualCalendar.getIcon() : null);
                }
            }
            return null;
        }

        public String getNodeText() {
            switch (this.type) {
                case 0: {
                    return "";
                }
                case 10: {
                    if (this.localCalendar != null) {
                        return this.localCalendar.name;
                    }
                    if (this.virtualCalendar != null) {
                        return this.virtualCalendar.getTitle();
                    }
                    return this.title(StringUtils.capitalize((String)I18N.tr("all calendars")));
                }
            }
            return "???";
        }

        public String getNodeTooltip() {
            switch (this.getType()) {
                case 10: {
                    if (this.localCalendar != null) {
                        return StringEscapeUtils.escapeXml11((String)this.localCalendar.notes);
                    }
                    if (this.virtualCalendar != null) {
                        return this.virtualCalendar.getToolTip();
                    }
                    return I18N.tr("Show entries of all calendars.");
                }
            }
            return null;
        }

        public int getType() {
            return this.type;
        }

        public VirtualCalendarExtension getVirtualCalendar() {
            return this.virtualCalendar;
        }

        public void setLocalCalendar(DbCalendarGroup dbCalendarGroup) {
            this.localCalendar = dbCalendarGroup;
        }
    }

    public static class Tree
    extends SidebarTree {
        public TreeNode getRootNode() {
            return (TreeNode)((Object)this.getModel().getRoot());
        }

        public void putCalendar(DbCalendarGroup dbCalendarGroup) {
            TreeNode treeNode;
            if (dbCalendarGroup == null) {
                throw new IllegalArgumentException("No calendar was provided!");
            }
            if (dbCalendarGroup.id < 1L) {
                throw new IllegalArgumentException("An unsaved calendar was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode2 = this.getRootNode();
            if (treeNode2 == null) {
                return;
            }
            for (int i = 0; i < treeNode2.getChildCount(); ++i) {
                DbCalendarGroup dbCalendarGroup2;
                treeNode = (TreeNode)((Object)treeNode2.getChildAt(i));
                if (treeNode.getType() != 10 || (dbCalendarGroup2 = treeNode.getLocalCalendar()) == null || dbCalendarGroup2.id != dbCalendarGroup.id) continue;
                treeNode.setLocalCalendar(dbCalendarGroup);
                defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode));
                return;
            }
            TreeNode treeNode3 = new TreeNode(10, dbCalendarGroup);
            treeNode = (TreeNode)((Object)treeNode2.getFirstChild());
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)treeNode3), (MutableTreeNode)((Object)treeNode), treeNode.getChildCount());
            this.expandPath(new TreePath(new Object[]{treeNode2, treeNode, treeNode3}));
        }

        public boolean removeCalendar(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid calendar-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getRootNode();
            if (treeNode == null) {
                return false;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbCalendarGroup dbCalendarGroup;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 10 || (dbCalendarGroup = treeNode2.getLocalCalendar()) == null || dbCalendarGroup.id != l) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }
    }
}

