/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.calendar.gui.PriorityRenderer;
import com.openindex.openestate.tool.calendar.gui.StatusRenderer;
import com.openindex.openestate.tool.gui.DateTimeIntervalValidationListener;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultDateTimeField;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarTodoEntryPanel
extends CalendarEntryPanel<DbCalendarTodoEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarTodoEntryPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarTodoEntryPanel.class);
    private ButtonGroup timeGroup;
    private JXTitledSeparator detailsTitle;
    private JRadioButton singleDayButton;
    private JRadioButton intervalButton;
    private JLabel dateLabel;
    private DefaultDatePicker dateField;
    private JLabel beginTimeLabel;
    private DefaultDateTimeField beginTimeField;
    private JLabel finishTimeLabel;
    private DefaultDateTimeField finishTimeField;
    private JXTitledSeparator optionsTitle;
    private JLabel priorityLabel;
    private JComboBox<Priority> priorityField;
    private JLabel statusLabel;
    private JComboBox<Status> statusField;
    private JLabel percentageLabel;
    private JSpinner percentageField;
    private JXTitledSeparator locationTitle;
    private JLabel locationLabel;
    private DefaultTextArea locationField;
    private JLabel longitudeLabel;
    private JFormattedTextField longitudeField;
    private JLabel latitudeLabel;
    private JFormattedTextField latitudeField;

    public CalendarTodoEntryPanel(boolean bl) {
        super(bl);
    }

    @Override
    protected JPanel buildEntryPanel() {
        this.detailsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.optionsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.locationTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.timeGroup = new ButtonGroup();
        this.singleDayButton = new JRadioButton();
        this.singleDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarTodoEntryPanel.this.singleDayButton.isEnabled()) {
                    return;
                }
                CalendarTodoEntryPanel.this.updateInterval();
                if (CalendarTodoEntryPanel.this.dateField.getDate() == null) {
                    CalendarTodoEntryPanel.this.dateField.setDate(new Date());
                }
            }
        });
        this.timeGroup.add(this.singleDayButton);
        this.dateLabel = new JLabel();
        this.dateField = new DefaultDatePicker();
        this.intervalButton = new JRadioButton();
        this.intervalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarTodoEntryPanel.this.intervalButton.isEnabled()) {
                    return;
                }
                CalendarTodoEntryPanel.this.updateInterval();
                Date date = CalendarTodoEntryPanel.this.beginTimeField.getValueAsDate();
                Date date2 = CalendarTodoEntryPanel.this.finishTimeField.getValueAsDate();
                Calendar calendar = Calendar.getInstance();
                if (date != null) {
                    calendar.setTime(date);
                } else {
                    CalendarTodoEntryPanel.this.beginTimeField.setValue(calendar);
                }
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.add(12, 30);
                if (date2 == null) {
                    CalendarTodoEntryPanel.this.finishTimeField.setValue(calendar2);
                }
            }
        });
        this.timeGroup.add(this.intervalButton);
        this.beginTimeLabel = new JLabel();
        this.beginTimeField = new DefaultDateTimeField();
        this.finishTimeLabel = new JLabel();
        this.finishTimeField = new DefaultDateTimeField();
        this.percentageLabel = new JLabel();
        this.percentageField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        this.percentageField.setEditor(new JSpinner.NumberEditor(this.percentageField, "#.##%"));
        this.priorityLabel = new JLabel();
        this.priorityField = new JComboBox<Priority>(new Priority[]{null, Priority.UNDEFINED, Priority.LOW, Priority.MEDIUM, Priority.HIGH});
        this.priorityField.setRenderer((ListCellRenderer<Priority>)new DefaultListCellRenderer((Renderer)new PriorityRenderer()));
        this.statusLabel = new JLabel();
        this.statusField = new JComboBox<Status>(new Status[]{null, Status.VTODO_NEEDS_ACTION, Status.VTODO_IN_PROCESS, Status.VTODO_COMPLETED, Status.VTODO_CANCELLED});
        this.statusField.setRenderer((ListCellRenderer<Status>)new DefaultListCellRenderer((Renderer)new StatusRenderer(DbCalendarEntry.Type.VTODO)));
        this.locationLabel = new JLabel();
        this.locationField = new DefaultTextArea();
        JScrollPane jScrollPane = this.locationField.createScrollPane();
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        this.longitudeLabel = new JLabel();
        this.longitudeField = new JFormattedTextField(NumberFormat.getInstance());
        this.latitudeLabel = new JLabel();
        this.latitudeField = new JFormattedTextField(NumberFormat.getInstance());
        this.validationHandler.putRule((JComponent)this.percentageField, ValidationHandler.NOT_NULL);
        this.validationHandler.putRule(this.priorityField, (ValidationRule)new NonEmptyComboBoxRule(this.priorityField));
        this.validationHandler.putRule(this.statusField, (ValidationRule)new NonEmptyComboBoxRule(this.statusField));
        this.validationHandler.putRule((JComponent)this.dateField, ValidationHandler.NOT_NULL);
        DateTimeIntervalValidationListener.install((ValidationHandler)this.validationHandler, (DefaultDateTimeField)this.beginTimeField, (DefaultDateTimeField)this.finishTimeField);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, pref:grow, 3dlu,right:[40dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.add((Component)this.detailsTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.optionsTitle).xyw(5, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.singleDayButton).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.statusLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.statusField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.dateLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.dateField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.priorityLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.priorityField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.intervalButton).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.percentageLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.percentageField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.beginTimeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.beginTimeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.finishTimeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.finishTimeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.locationTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.locationLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
        defaultFormBuilder.addRaw((Component)jScrollPane).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.longitudeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.longitudeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.latitudeLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.latitudeField).xy(7, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    @Override
    public DbCalendarTodoEntry createEntry() {
        DbCalendarTodoEntry dbCalendarTodoEntry = new DbCalendarTodoEntry();
        dbCalendarTodoEntry.setEmptyComponent();
        return dbCalendarTodoEntry;
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("task"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DbCalendarEntry dbCalendarEntry) {
        Geo geo;
        super.load(dbCalendarEntry);
        DbCalendarTodoEntry dbCalendarTodoEntry = (DbCalendarTodoEntry)dbCalendarEntry;
        VToDo vToDo = dbCalendarTodoEntry != null ? dbCalendarTodoEntry.getComponent() : null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dbCalendarTodoEntry != null && dbCalendarTodoEntry.begin != null ? dbCalendarTodoEntry.begin : new Date());
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(12, 30);
        this.singleDayButton.setEnabled(false);
        this.intervalButton.setEnabled(false);
        try {
            this.timeGroup.clearSelection();
            if (dbCalendarTodoEntry == null || dbCalendarTodoEntry.end == null) {
                this.singleDayButton.setSelected(true);
            } else {
                this.intervalButton.setSelected(true);
            }
        }
        finally {
            this.updateInterval();
            this.singleDayButton.setEnabled(true);
            this.intervalButton.setEnabled(true);
        }
        this.dateField.setDate(dbCalendarTodoEntry != null && dbCalendarTodoEntry.begin != null ? dbCalendarTodoEntry.begin : calendar.getTime());
        this.beginTimeField.setValue(dbCalendarTodoEntry != null && dbCalendarTodoEntry.begin != null ? dbCalendarTodoEntry.begin : calendar.getTime());
        this.finishTimeField.setValue(dbCalendarTodoEntry != null && dbCalendarTodoEntry.end != null ? dbCalendarTodoEntry.end : calendar2.getTime());
        PercentComplete percentComplete = vToDo != null ? vToDo.getPercentComplete() : null;
        this.percentageField.setValue(0.0);
        if (percentComplete != null) {
            double d = (double)percentComplete.getPercentage() / 100.0;
            this.percentageField.setValue(d);
        }
        Priority priority = vToDo != null ? vToDo.getPriority() : null;
        this.priorityField.setSelectedItem(priority != null ? priority : Priority.UNDEFINED);
        this.statusField.setSelectedItem(dbCalendarTodoEntry != null && dbCalendarTodoEntry.status != null ? dbCalendarTodoEntry.status : Status.VTODO_NEEDS_ACTION);
        String string = dbCalendarTodoEntry != null ? dbCalendarTodoEntry.getLocation() : null;
        this.locationField.setText(StringUtils.trimToEmpty((String)string));
        this.locationField.setCaretPosition(0);
        this.latitudeField.setValue(null);
        this.longitudeField.setValue(null);
        Geo geo2 = geo = vToDo != null ? vToDo.getGeographicPos() : null;
        if (geo != null && geo.getLatitude() != null && geo.getLongitude() != null) {
            this.latitudeField.setValue(geo.getLatitude().doubleValue());
            this.longitudeField.setValue(geo.getLongitude().doubleValue());
        }
        if (dbCalendarEntry != null && dbCalendarEntry.id > 0L) {
            this.validationHandler.validate();
        } else {
            this.validationHandler.init();
        }
        this.modificationHandler.putValue((JComponent)this.singleDayButton);
        this.modificationHandler.putValue((JComponent)this.intervalButton);
        this.modificationHandler.putValue((JComponent)this.dateField);
        this.modificationHandler.putValue((JComponent)this.beginTimeField);
        this.modificationHandler.putValue((JComponent)this.finishTimeField);
        this.modificationHandler.putValue(this.priorityField);
        this.modificationHandler.putValue(this.statusField);
        this.modificationHandler.putValue((JComponent)this.locationField);
        this.modificationHandler.putValue((JComponent)this.longitudeField);
        this.modificationHandler.putValue((JComponent)this.latitudeField);
        this.modificationHandler.putValue((JComponent)this.percentageField);
    }

    @Override
    public void save(DbCalendarEntry dbCalendarEntry) {
        super.save(dbCalendarEntry);
        DbCalendarTodoEntry dbCalendarTodoEntry = (DbCalendarTodoEntry)dbCalendarEntry;
        if (this.singleDayButton.isSelected()) {
            dbCalendarTodoEntry.setSingleDay(this.dateField.getDate());
        } else if (this.intervalButton.isSelected()) {
            dbCalendarTodoEntry.setBeginTime(this.beginTimeField.getValueAsDate());
            dbCalendarTodoEntry.setEndTime(this.finishTimeField.getValueAsDate());
        }
        if (this.statusField.getSelectedIndex() < 1) {
            dbCalendarTodoEntry.removeProperty("STATUS");
        } else {
            dbCalendarTodoEntry.setStatus((Status)this.statusField.getSelectedItem());
        }
        if (this.priorityField.getSelectedIndex() < 1) {
            dbCalendarTodoEntry.removeProperty("PRIORITY");
        } else {
            dbCalendarTodoEntry.putProperty((Property)((Priority)this.priorityField.getSelectedItem()));
        }
        if (this.percentageField.getValue() != null) {
            try {
                this.percentageField.commitEdit();
                int n = (int)(((Number)this.percentageField.getValue()).doubleValue() * 100.0);
                dbCalendarTodoEntry.putProperty((Property)new PercentComplete(n));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read percentage value: " + exception.getLocalizedMessage(), (Throwable)exception);
                dbCalendarTodoEntry.removeProperty("PERCENT-COMPLETE");
            }
        } else {
            dbCalendarTodoEntry.removeProperty("PERCENT-COMPLETE");
        }
        dbCalendarTodoEntry.setLocation(this.locationField.getText().trim());
        Number number = (Number)this.latitudeField.getValue();
        Number number2 = (Number)this.longitudeField.getValue();
        if (number == null || number2 == null) {
            dbCalendarTodoEntry.removeProperty("GEO");
        } else {
            dbCalendarTodoEntry.putProperty((Property)new Geo(BigDecimal.valueOf(number.doubleValue()), BigDecimal.valueOf(number2.doubleValue())));
        }
    }

    @Override
    public void setDate(Date date) {
        this.dateField.setDate(date);
        this.singleDayButton.setSelected(true);
        this.updateInterval();
    }

    @Override
    public void setDateInterval(Date date, Date date2) {
        if (date2 == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(12, 30);
            date2 = calendar.getTime();
        }
        this.beginTimeField.setValue(date);
        this.finishTimeField.setValue(date2);
        this.intervalButton.setSelected(true);
        this.updateInterval();
    }

    private void updateInterval() {
        boolean bl = this.singleDayButton.isSelected();
        boolean bl2 = this.intervalButton.isSelected();
        this.dateField.setEnabled(bl);
        this.beginTimeField.setEnabled(bl2);
        this.finishTimeField.setEnabled(bl2);
        this.validationHandler.validate((JComponent)this.dateField);
        this.validationHandler.validate((JComponent)this.beginTimeField);
        this.validationHandler.validate((JComponent)this.finishTimeField);
    }

    @Override
    protected void updateLocalization() {
        super.updateLocalization();
        this.detailsTitle.setTitle(StringUtils.capitalize((String)I18N.tr("details about the task")));
        this.singleDayButton.setText("<html><b>" + I18N.tr("task on a single day") + "</b></html>");
        this.dateLabel.setText(StringUtils.capitalize((String)I18N.tr("day")) + ":");
        this.dateField.setToolTipText(I18N.tr("Select the day of the calendar entry."));
        this.intervalButton.setText("<html><b>" + I18N.tr("task in a timeframe") + "</b></html>");
        this.beginTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
        this.beginTimeField.setToolTipText(I18N.tr("Enter the beginning time of the calendar entry."));
        this.finishTimeLabel.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
        this.finishTimeField.setToolTipText(I18N.tr("Enter the ending time of the calendar entry."));
        this.optionsTitle.setTitle(StringUtils.capitalize((String)I18N.tr("options for the task")));
        this.priorityLabel.setText(StringUtils.capitalize((String)I18N.tr("priority")) + ":");
        this.priorityField.setToolTipText(I18N.tr("Select a priority for the calendar entry."));
        this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
        this.statusField.setToolTipText(I18N.tr("Select a status for the calendar entry."));
        this.percentageLabel.setText(StringUtils.capitalize((String)I18N.tr("progress")) + ":");
        this.percentageField.setToolTipText(I18N.tr("Enter the progress of the task."));
        this.locationTitle.setTitle(StringUtils.capitalize((String)I18N.tr("location of the task")));
        this.locationLabel.setText("<html><div style=\"text-align:right;\">" + StringUtils.capitalize((String)I18N.tr("location")) + "&nbsp;<br>/&nbsp;" + StringUtils.capitalize((String)I18N.tr("address")) + ":</div></html>");
        this.locationField.setToolTipText(I18N.tr("Enter your notes about the location of the calendar entry."));
        this.longitudeLabel.setText(StringUtils.capitalize((String)I18N.tr("longitude")) + ":");
        this.longitudeField.setToolTipText(StringUtils.capitalize((String)I18N.tr("Enter the longitude of the location.")));
        this.latitudeLabel.setText(StringUtils.capitalize((String)I18N.tr("latitude")) + ":");
        this.latitudeField.setToolTipText(StringUtils.capitalize((String)I18N.tr("Enter the latitude of the location.")));
    }
}

