/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.util.Calendar;
import javax.swing.ImageIcon;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCalendarTodoEntry
extends DbCalendarEntry<VToDo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarTodoEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarTodoEntry.class);
    public static final Status CANCELLED = Status.VTODO_CANCELLED;
    public static final Status COMPLETED = Status.VTODO_COMPLETED;
    public static final Status IN_PROCESS = Status.VTODO_IN_PROCESS;
    public static final Status NEEDS_ACTION = Status.VTODO_NEEDS_ACTION;
    public VToDo todo = new VToDo();

    @Override
    public Color getColor() {
        if (COMPLETED.equals((Object)this.status)) {
            return new Color(162, 249, 162);
        }
        if (NEEDS_ACTION.equals((Object)this.status)) {
            return new Color(249, 162, 162);
        }
        if (IN_PROCESS.equals((Object)this.status)) {
            return new Color(162, 162, 249);
        }
        return new Color(240, 240, 240);
    }

    @Override
    public VToDo getComponent() {
        return this.todo;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(CalendarPlugin.getResourceImage("todo.png", 16));
    }

    @Override
    public Color getStatusColor() {
        return DbCalendarTodoEntry.getStatusColor(this.status);
    }

    public static Color getStatusColor(Status status) {
        if (Status.VTODO_CANCELLED.equals((Object)status)) {
            return Color.GRAY;
        }
        if (Status.VTODO_COMPLETED.equals((Object)status)) {
            return Color.BLACK;
        }
        if (Status.VTODO_IN_PROCESS.equals((Object)status)) {
            return Color.RED;
        }
        if (Status.VTODO_NEEDS_ACTION.equals((Object)status)) {
            return Color.ORANGE.darker();
        }
        return null;
    }

    public static Status[] getStatusOptions() {
        return new Status[]{CANCELLED, COMPLETED, IN_PROCESS, NEEDS_ACTION};
    }

    @Override
    public final DbCalendarEntry.Type getType() {
        return DbCalendarEntry.Type.VTODO;
    }

    @Override
    public boolean hasBeginDate() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && !DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasBeginTime() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasEndDate() {
        Completed completed = (Completed)this.getProperty("COMPLETED");
        return completed != null && completed.getDate() != null && !DateTime.class.isInstance(completed.getDate());
    }

    @Override
    public boolean hasEndTime() {
        Completed completed = (Completed)this.getProperty("COMPLETED");
        return completed != null && completed.getDate() != null && DateTime.class.isInstance(completed.getDate());
    }

    @Override
    public void setBeginDate(java.util.Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            this.putProperty((Property)new DtStart(new Date(date)));
            this.begin = (java.util.Date)date.clone();
        }
    }

    @Override
    public void setBeginTime(java.util.Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            TimeZone timeZone = CalendarPluginUtils.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setUtc(false);
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtStart((Date)dateTime));
            this.begin = calendar.getTime();
        }
    }

    @Override
    public void setComponent(Component component) {
        this.todo = component instanceof VToDo ? (VToDo)component : new VToDo();
    }

    @Override
    public void setEmptyComponent() {
        this.setComponent((Component)new VToDo());
    }

    @Override
    public void setEndDate(java.util.Date date) {
        this.removeProperty("DURATION");
        this.removeProperty("COMPLETED");
        if (date == null) {
            this.removeProperty("DUE");
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(6, 1);
            calendar.add(14, -1);
            this.setEndTime(calendar.getTime());
        }
    }

    @Override
    public void setEndTime(java.util.Date date) {
        this.removeProperty("DURATION");
        this.removeProperty("COMPLETED");
        if (date == null) {
            this.removeProperty("DUE");
        } else {
            TimeZone timeZone = CalendarPluginUtils.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setUtc(false);
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new Due((Date)dateTime));
            this.end = calendar.getTime();
        }
    }

    @Override
    public synchronized void updateTimeFieldsFromComponent() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        this.begin = dtStart != null ? dtStart.getDate() : null;
        this.end = null;
        Due due = (Due)this.getProperty("DUE");
        if (due != null) {
            this.end = due.getDate();
        } else {
            Duration duration;
            Completed completed = (Completed)this.getProperty("COMPLETED");
            if (completed != null) {
                this.end = completed.getDate();
            } else if (this.begin != null && (duration = (Duration)this.getProperty("DURATION")) != null) {
                this.end = duration.getDuration().getTime(this.begin);
            }
        }
        if (this.end != null && this.begin != null && this.end.before(this.begin)) {
            LOGGER.warn("Invalid calendar entry #" + this.id + "!");
            LOGGER.warn("> end time (" + this.end + ") is before start time (" + this.begin + ")");
            LOGGER.warn("> drop end time");
            this.setEndDate(null);
        }
    }
}

