/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarExtension;
import com.openindex.openestate.tool.calendar.extensions.EntryViewExtension;
import com.openindex.openestate.tool.calendar.extensions.SourceViewExtension;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.RandomUidGenerator;
import net.fortuna.ical4j.util.UidGenerator;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarPluginUtils.class);
    private static TimeZoneRegistry TIMEZONE_REGISTRY;
    private static UidGenerator UID_GENERATOR;

    private CalendarPluginUtils() {
    }

    public static Uid generateUid() {
        return UID_GENERATOR.generateUid();
    }

    public static DbCalendarExtension getDbCalendarExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? CalendarPluginUtils.getDbCalendarExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbCalendarExtension getDbCalendarExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? CalendarPluginUtils.getDbCalendarExtension(abstractDbDriver.getName()) : null;
    }

    public static DbCalendarExtension getDbCalendarExtension(String string) {
        for (Object object : CalendarPluginUtils.getExtensionHandlers("DbCalendarExtension", DbCalendarExtension.class, null, null)) {
            DbCalendarExtension dbCalendarExtension = (DbCalendarExtension)object;
            if (!dbCalendarExtension.isSupportedDriver(string)) continue;
            return dbCalendarExtension;
        }
        return null;
    }

    public static Collection<DbCalendarExtension> getDbCalendarExtensions() {
        ArrayList<DbCalendarExtension> arrayList = new ArrayList<DbCalendarExtension>();
        for (Object object : CalendarPluginUtils.getExtensionHandlers("DbCalendarExtension", DbCalendarExtension.class, null, null)) {
            arrayList.add((DbCalendarExtension)object);
        }
        return arrayList;
    }

    public static Collection<EntryViewExtension> getEntryViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<EntryViewExtension> arrayList = new ArrayList<EntryViewExtension>();
        for (Object object : CalendarPluginUtils.getExtensionHandlers("EntryViewExtension", EntryViewExtension.class, immoToolProject, null)) {
            arrayList.add((EntryViewExtension)object);
        }
        return arrayList;
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-Calendar", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    public static Collection<SourceViewExtension> getSourceViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<SourceViewExtension> arrayList = new ArrayList<SourceViewExtension>();
        for (Object object : CalendarPluginUtils.getExtensionHandlers("SourceViewExtension", SourceViewExtension.class, immoToolProject, null)) {
            arrayList.add((SourceViewExtension)object);
        }
        return arrayList;
    }

    private static DateFormat getTimeFormat() {
        return new SimpleDateFormat("HH-mm");
    }

    public static synchronized net.fortuna.ical4j.model.TimeZone getTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        String string = timeZone.getID();
        net.fortuna.ical4j.model.TimeZone timeZone2 = TIMEZONE_REGISTRY.getTimeZone(string);
        if (timeZone2 != null) {
            return timeZone2;
        }
        return CalendarPluginUtils.getTimeZoneRegistry().getTimeZone("Europe/Berlin");
    }

    public static TimeZoneRegistry getTimeZoneRegistry() {
        return TIMEZONE_REGISTRY;
    }

    public static UidGenerator getUidGenerator() {
        return UID_GENERATOR;
    }

    public static Collection<VirtualCalendarExtension> getVirtualCalendarExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<VirtualCalendarExtension> arrayList = new ArrayList<VirtualCalendarExtension>();
        for (Object object : CalendarPluginUtils.getExtensionHandlers("VirtualCalendarExtension", VirtualCalendarExtension.class, immoToolProject, null)) {
            VirtualCalendarExtension virtualCalendarExtension = (VirtualCalendarExtension)object;
            if (!virtualCalendarExtension.isUsable()) continue;
            arrayList.add(virtualCalendarExtension);
        }
        return arrayList;
    }

    public static net.fortuna.ical4j.model.Calendar parseCalendarComponent(String string) throws IOException, ParserException {
        return CalendarPluginUtils.parseCalendarComponents(new String[]{string});
    }

    public static net.fortuna.ical4j.model.Calendar parseCalendarComponents(String[] stringArray) throws IOException, ParserException {
        if (stringArray == null) {
            return null;
        }
        ProdId prodId = new ProdId("-//OpenEstate.org//iCal4j 1.0//EN");
        Version version = Version.VERSION_2_0;
        CalScale calScale = CalScale.GREGORIAN;
        Method method = Method.PUBLISH;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN:VCALENDAR").append(System.lineSeparator());
        stringBuilder.append(prodId.getName()).append(":").append(prodId.getValue()).append(System.lineSeparator());
        stringBuilder.append(version.getName()).append(":").append(version.getValue()).append(System.lineSeparator());
        stringBuilder.append(calScale.getName()).append(":").append(calScale.getValue()).append(System.lineSeparator());
        stringBuilder.append(method.getName()).append(":").append(method.getValue()).append(System.lineSeparator());
        for (String string : stringArray) {
            stringBuilder.append(string.trim()).append(System.lineSeparator());
        }
        stringBuilder.append("END:VCALENDAR").append(System.lineSeparator());
        try (StringReader stringReader = new StringReader(stringBuilder.toString());){
            String string;
            CalendarBuilder calendarBuilder = new CalendarBuilder();
            string = calendarBuilder.build((Reader)stringReader);
            return string;
        }
    }

    public static Calendar parseTime(String string, int n, int n2) {
        Calendar calendar = null;
        if (string != null) {
            try {
                calendar = Calendar.getInstance();
                calendar.setTime(CalendarPluginUtils.getTimeFormat().parse(string));
            }
            catch (Exception exception) {
                calendar = null;
                LOGGER.warn("Invalid time: " + string, (Throwable)exception);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(6, 1);
        calendar2.set(1, 2000);
        calendar2.set(11, calendar != null ? calendar.get(11) : n);
        calendar2.set(12, calendar != null ? calendar.get(12) : n2);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        return calendar2;
    }

    public static String printTime(Calendar calendar) {
        return calendar != null ? CalendarPluginUtils.getTimeFormat().format(calendar.getTime()) : null;
    }

    public static DbCalendarEntry[] searchForDbEntries(Connection connection, DbCalendarHandler dbCalendarHandler, long[] lArray, DbCalendarEntry.Type[] typeArray, Status[] statusArray, Date date, Date date2) throws SQLException {
        DbCalendarEntry[] dbCalendarEntryArray;
        if (lArray != null && lArray.length == 0) {
            return new DbCalendarEntry[0];
        }
        for (DbCalendarEntry dbCalendarEntry : dbCalendarEntryArray = dbCalendarHandler.getEntries(connection, statusArray, typeArray, lArray, date, date2)) {
            try {
                dbCalendarEntry.updateTimeFieldsFromComponent();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't update calendar entry #" + dbCalendarEntry.id + " from ical source!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return dbCalendarEntryArray;
    }

    public static VirtualCalendarEntry[] searchForVirtualEntries(Connection connection, DbCalendarHandler dbCalendarHandler, VirtualCalendarExtension virtualCalendarExtension, Date date, Date date2) throws IOException, SQLException {
        return virtualCalendarExtension != null ? CalendarPluginUtils.searchForVirtualEntries(connection, dbCalendarHandler, new VirtualCalendarExtension[]{virtualCalendarExtension}, date, date2) : new VirtualCalendarEntry[]{};
    }

    public static VirtualCalendarEntry[] searchForVirtualEntries(Connection connection, DbCalendarHandler dbCalendarHandler, VirtualCalendarExtension[] virtualCalendarExtensionArray, Date date, Date date2) throws IOException, SQLException {
        ArrayList arrayList;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (virtualCalendarExtensionArray == null) {
            arrayList = new ArrayList();
            for (VirtualCalendarExtension virtualCalendarExtension : CalendarPluginUtils.getVirtualCalendarExtensions()) {
                try {
                    arrayList.add(virtualCalendarExtension);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load virtual calendar extension!");
                    LOGGER.warn("> " + virtualCalendarExtension.getClass().getName());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            virtualCalendarExtensionArray = arrayList.toArray(new VirtualCalendarExtension[0]);
        }
        if (ArrayUtils.isEmpty((Object[])virtualCalendarExtensionArray)) {
            return new VirtualCalendarEntry[0];
        }
        arrayList = new ArrayList();
        for (VirtualCalendarExtension virtualCalendarExtension : virtualCalendarExtensionArray) {
            List list = virtualCalendarExtension.getEntries(connection, immoToolProject.getDbDriver().getName(), date, date2);
            if (list == null || list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        return arrayList.toArray(new VirtualCalendarEntry[0]);
    }

    static {
        try {
            TIMEZONE_REGISTRY = TimeZoneRegistryFactory.getInstance().createRegistry();
        }
        catch (Exception exception) {
            LOGGER.error("Can't load timezone-registry!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            UID_GENERATOR = new RandomUidGenerator();
        }
        catch (Exception exception) {
            LOGGER.error("Can't load uid-generator!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

