/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.calendar.gui.EntryRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryField
extends DefaultAutoCompleteField<DbCalendarEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryField.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryField.class);
    private long calendarGroupId = 0L;

    public CalendarEntryField() {
        this.setCustomValueAllowed(false);
        this.setMultipleSelectionAllowed(false);
        this.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)new EntryRenderer("-")));
        this.setAutoCompleteHandler(new Handler());
        DbCalendarEventEntry dbCalendarEventEntry = new DbCalendarEventEntry();
        dbCalendarEventEntry.title = "example";
        dbCalendarEventEntry.begin = new Date();
        this.setCalendarEntry(dbCalendarEventEntry);
    }

    public DbCalendarEntry getCalendarEntry() {
        return (DbCalendarEntry)this.getValue();
    }

    public long getCalendarGroupId() {
        return this.calendarGroupId;
    }

    public void setCalendarEntry(DbCalendarEntry dbCalendarEntry) {
        this.setValue(dbCalendarEntry);
    }

    public void setCalendarGroupId(long l) {
        this.calendarGroupId = l;
    }

    private final class Handler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbCalendarEntry> {
        private Handler() {
        }

        public Dimension getOptionIconSize() {
            return new Dimension(16, 16);
        }

        public String getOptionText(DbCalendarEntry dbCalendarEntry) {
            if (dbCalendarEntry != null) {
                return dbCalendarEntry.print();
            }
            return "-";
        }

        public URL getOptionIconUrl(DbCalendarEntry dbCalendarEntry) {
            if (dbCalendarEntry instanceof DbCalendarEventEntry) {
                return CalendarPlugin.getResourceImageURL("event.png", 16);
            }
            if (dbCalendarEntry instanceof DbCalendarTodoEntry) {
                return CalendarPlugin.getResourceImageURL("todo.png", 16);
            }
            return CalendarPlugin.getResourceImageURL("vcalendar.png", 16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbCalendarEntry> search(String string) throws Exception {
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                DbCalendarEntry[] dbCalendarEntryArray = dbCalendarHandler.getEntries(connection, string, CalendarEntryField.this.getCalendarGroupId(), 100);
                List<DbCalendarEntry> list = Arrays.asList(dbCalendarEntryArray);
                return list;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

